/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.ActionWithTempFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RepeatSvnActionThroughBusy;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnFileSystemListener
implements LocalFileOperationsHandler,
Disposable,
CommandListener {
    private static final Logger LOG = Logger.getInstance(SvnFileSystemListener.class);
    @NotNull
    private final SvnVcs myVcs;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private final List<AddedFileInfo> myAddedFiles;
    private final List<File> myDeletedFiles;
    private final List<MovedFileInfo> myMovedFiles;
    private final List<VcsException> myMoveExceptions;
    private final List<VirtualFile> myFilesToRefresh;
    @Nullable
    private File myStorageForUndo;
    private final List<Couple<File>> myUndoStorageContents;
    private boolean myUndoingMove;
    private boolean myIsInCommand;
    private boolean myIsOperationStarted;

    public SvnFileSystemListener(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnFileSystemListener.$$$reportNull$$$0(0);
        }
        this.myAddedFiles = new ArrayList<AddedFileInfo>();
        this.myDeletedFiles = new ArrayList<File>();
        this.myMovedFiles = new ArrayList<MovedFileInfo>();
        this.myMoveExceptions = new ArrayList<VcsException>();
        this.myFilesToRefresh = new ArrayList<VirtualFile>();
        this.myUndoStorageContents = new ArrayList<Couple<File>>();
        this.myUndoingMove = false;
        this.myVcs = vcs;
        LocalFileSystem.getInstance().registerAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CommandListener.TOPIC, (Object)this);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)vcs.getProject());
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)vcs);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)vcs);
    }

    public void dispose() {
        LocalFileSystem.getInstance().unregisterAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
    }

    private boolean isMyVcs(@NotNull VirtualFile file) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(1);
        }
        return VcsUtil.isFileForVcs((VirtualFile)file, (Project)this.myVcs.getProject(), (AbstractVcs)this.myVcs);
    }

    @NotNull
    private static VcsException handleMoveException(@NotNull VcsException e) {
        if (e == null) {
            SvnFileSystemListener.$$$reportNull$$$0(2);
        }
        VcsException vcsException = e instanceof SvnBindException && ((SvnBindException)e).contains(ErrorCode.ENTRY_EXISTS) ? SvnFileSystemListener.createMoveTargetExistsError((Exception)((Object)e)) : e;
        if (vcsException == null) {
            SvnFileSystemListener.$$$reportNull$$$0(3);
        }
        return vcsException;
    }

    @NotNull
    private static VcsException createMoveTargetExistsError(@NotNull Exception e) {
        if (e == null) {
            SvnFileSystemListener.$$$reportNull$$$0(4);
        }
        return new VcsException(Arrays.asList(SvnBundle.message("error.target.of.move.operation.is.already.under.version.control", new Object[0]), SvnBundle.message("error.move.have.not.been.performed", new Object[0]), e.getMessage()));
    }

    @Nullable
    public File copy(@NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String copyName) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(5);
        }
        if (toDir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(6);
        }
        if (copyName == null) {
            SvnFileSystemListener.$$$reportNull$$$0(7);
        }
        if (!this.isMyVcs(toDir)) {
            return null;
        }
        this.startOperation(toDir);
        File srcFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        File destFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)toDir), copyName);
        if (!SvnUtil.isSvnVersioned(this.myVcs, destFile.getParentFile()) && !this.isPendingAdd(toDir)) {
            return null;
        }
        if (!SvnUtil.isSvnVersioned(this.myVcs, srcFile.getParentFile())) {
            this.myAddedFiles.add(new AddedFileInfo(toDir, copyName, null, false));
            return null;
        }
        Status fileStatus = this.getFileStatus(srcFile);
        if (fileStatus != null && fileStatus.is(StatusType.STATUS_ADDED)) {
            this.myAddedFiles.add(new AddedFileInfo(toDir, copyName, null, false));
            return null;
        }
        if (this.sameRoot(file.getParent(), toDir)) {
            this.myAddedFiles.add(new AddedFileInfo(toDir, copyName, srcFile, false));
            return null;
        }
        this.myAddedFiles.add(new AddedFileInfo(toDir, copyName, null, false));
        return null;
    }

    private boolean sameRoot(@NotNull VirtualFile srcDir, @NotNull VirtualFile dstDir) {
        if (srcDir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(8);
        }
        if (dstDir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(9);
        }
        String srcUUID = this.getRepositoryUUID(srcDir);
        String dstUUID = this.getRepositoryUUID(dstDir);
        return srcUUID != null && srcUUID.equals(dstUUID);
    }

    @Nullable
    private String getRepositoryUUID(final @NotNull VirtualFile dir) {
        block6: {
            if (dir == null) {
                SvnFileSystemListener.$$$reportNull$$$0(10);
            }
            try {
                Info info1 = (Info)new RepeatSvnActionThroughBusy(){

                    @Override
                    protected void executeImpl() {
                        this.myT = SvnFileSystemListener.this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
                    }
                }.compute();
                if (info1 == null || info1.getRepositoryId() == null) {
                    VirtualFile parent = dir.getParent();
                    if (parent == null) {
                        return null;
                    }
                    if (this.isPendingAdd(parent)) {
                        return this.getRepositoryUUID(parent);
                    }
                    break block6;
                }
                return info1.getRepositoryId();
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean move(@NotNull VirtualFile file, @NotNull VirtualFile toDir) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(11);
        }
        if (toDir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(12);
        }
        if (!this.isMyVcs(toDir)) {
            return false;
        }
        this.startOperation(toDir);
        if (!this.isMyVcs(file)) {
            return this.createItem(toDir, file.getName(), file.isDirectory(), true);
        }
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(SvnFileSystemListener.getIOFile(toDir), file.getName());
        if (this.isPendingAdd(toDir)) {
            this.myMovedFiles.add(new MovedFileInfo(srcFile, dstFile));
            return true;
        }
        this.myFilesToRefresh.add(file.getParent());
        this.myFilesToRefresh.add(toDir);
        return this.doMove(srcFile, dstFile);
    }

    public boolean rename(@NotNull VirtualFile file, @NotNull String newName) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(13);
        }
        if (newName == null) {
            SvnFileSystemListener.$$$reportNull$$$0(14);
        }
        if (!this.isMyVcs(file)) {
            return false;
        }
        this.startOperation(file);
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(srcFile.getParentFile(), newName);
        this.myFilesToRefresh.add(file.getParent());
        return this.doMove(srcFile, dstFile);
    }

    private boolean doMove(@NotNull File src, @NotNull File dst) {
        if (src == null) {
            SvnFileSystemListener.$$$reportNull$$$0(15);
        }
        if (dst == null) {
            SvnFileSystemListener.$$$reportNull$$$0(16);
        }
        try {
            Status srcStatus;
            boolean isUndo = this.isUndo();
            String list = isUndo ? null : SvnChangelistListener.getCurrentMapping(this.myVcs, src);
            WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(src);
            boolean is17OrLater = format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN);
            if (is17OrLater ? SvnFileSystemListener.isUnversioned(srcStatus = this.getFileStatus(src)) && (this.isUnversioned(dst.getParentFile()) || this.isUnversioned(dst)) || this.for17move(src, dst, isUndo, srcStatus) : this.for16move(dst, isUndo)) {
                return false;
            }
            if (!isUndo && list != null) {
                SvnChangelistListener.putUnderList(this.myVcs, list, dst);
            }
        }
        catch (VcsException e) {
            this.myMoveExceptions.add(SvnFileSystemListener.handleMoveException(e));
            return false;
        }
        return true;
    }

    private static boolean isUnversioned(@Nullable Status status) {
        return status == null || status.is(StatusType.STATUS_UNVERSIONED);
    }

    private boolean isUnversioned(@NotNull File file) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(17);
        }
        return SvnFileSystemListener.isUnversioned(this.getFileStatus(file));
    }

    private boolean for17move(File src, File dst, boolean undo, Status srcStatus) throws VcsException {
        if (srcStatus != null && srcStatus.getCopyFromUrl() == null) {
            undo = false;
        }
        if (undo) {
            this.myUndoingMove = true;
            boolean isCaseOnlyMove = FileUtil.filesEqual((File)src, (File)dst);
            this.createRevertAction(isCaseOnlyMove ? src : dst, true).execute();
            SvnFileSystemListener.copyUnversionedMembersOfDirectory(src, dst);
            if (SvnFileSystemListener.isUnversioned(srcStatus)) {
                FileUtil.delete((File)src);
            } else {
                this.createRevertAction(isCaseOnlyMove ? dst : src, true).execute();
            }
            this.restoreFromUndoStorage(dst);
        } else {
            if (this.doUsualMove(src)) {
                return true;
            }
            if (this.isUnversioned(dst.getParentFile())) {
                try {
                    FileUtil.copyFileOrDir((File)src, (File)dst);
                }
                catch (IOException e) {
                    throw new SvnBindException(e);
                }
                this.createDeleteAction(src, true).execute();
                return false;
            }
            SvnFileSystemListener.moveFileWithSvn(this.myVcs, src, dst);
        }
        return false;
    }

    public static void moveFileWithSvn(final SvnVcs vcs, final File src, final File dst) throws VcsException {
        new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                vcs.getFactory(src).createCopyMoveClient().copy(src, dst, false, true);
            }
        }.execute();
    }

    private static void copyUnversionedMembersOfDirectory(File src, File dst) throws SvnBindException {
        if (src.isDirectory()) {
            SvnBindException[] exc = new SvnBindException[1];
            FileUtil.processFilesRecursively((File)src, file -> {
                String relativePath = FileUtil.getRelativePath((File)src, (File)file);
                File newFile = new File(dst, relativePath);
                if (!newFile.exists()) {
                    try {
                        FileUtil.copyFileOrDir((File)src, (File)dst);
                    }
                    catch (IOException e) {
                        exc[0] = new SvnBindException(e);
                        return false;
                    }
                }
                return true;
            });
            if (exc[0] != null) {
                throw exc[0];
            }
        }
    }

    private boolean doUsualMove(File src) {
        Status srcStatus = this.getFileStatus(src);
        return srcStatus == null || srcStatus.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_OBSTRUCTED, StatusType.STATUS_MISSING, StatusType.STATUS_EXTERNAL);
    }

    private boolean for16move(File dst, boolean undo) {
        if (undo) {
            this.myUndoingMove = true;
            this.restoreFromUndoStorage(dst);
        }
        return true;
    }

    private void restoreFromUndoStorage(File dst) {
        File[] files;
        String normPath = FileUtil.toSystemIndependentName((String)dst.getPath());
        Iterator<Couple<File>> it = this.myUndoStorageContents.iterator();
        while (it.hasNext()) {
            Couple<File> e = it.next();
            String p = FileUtil.toSystemIndependentName((String)((File)e.first).getPath());
            if (!p.startsWith(normPath)) continue;
            try {
                FileUtil.rename((File)((File)e.second), (File)((File)e.first));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
                FileUtil.asyncDelete((File)((File)e.second));
            }
            it.remove();
        }
        if (this.myStorageForUndo != null && ((files = this.myStorageForUndo.listFiles()) == null || files.length == 0)) {
            FileUtil.asyncDelete((File)this.myStorageForUndo);
            this.myStorageForUndo = null;
        }
    }

    public boolean createFile(@NotNull VirtualFile dir, @NotNull String name) {
        if (dir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(18);
        }
        if (name == null) {
            SvnFileSystemListener.$$$reportNull$$$0(19);
        }
        if (!this.isMyVcs(dir)) {
            return false;
        }
        this.startOperation(dir);
        return this.createItem(dir, name, false, false);
    }

    public boolean createDirectory(@NotNull VirtualFile dir, @NotNull String name) {
        if (dir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(20);
        }
        if (name == null) {
            SvnFileSystemListener.$$$reportNull$$$0(21);
        }
        if (!this.isMyVcs(dir)) {
            return false;
        }
        this.startOperation(dir);
        return this.createItem(dir, name, true, false);
    }

    public boolean delete(@NotNull VirtualFile file) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(22);
        }
        if (!this.isMyVcs(file)) {
            return false;
        }
        this.startOperation(file);
        if (SvnUtil.isAdminDirectory(file)) {
            return true;
        }
        VcsShowConfirmationOption.Value value = this.myDeleteConfirmation.getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            return false;
        }
        File ioFile = SvnFileSystemListener.getIOFile(file);
        if (!SvnUtil.isSvnVersioned(this.myVcs, ioFile.getParentFile()) || SvnUtil.isWorkingCopyRoot(ioFile)) {
            return false;
        }
        Status status = this.getFileStatus(ioFile);
        if (status == null || status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_OBSTRUCTED, StatusType.STATUS_EXTERNAL, StatusType.STATUS_IGNORED)) {
            return false;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            if (this.isUndo()) {
                this.moveToUndoStorage(file);
            }
            return true;
        }
        if (this.isAboveSourceOfCopyOrMove(ioFile)) {
            this.myDeletedFiles.add(ioFile);
            return true;
        }
        if (status.is(StatusType.STATUS_ADDED)) {
            try {
                this.createRevertAction(ioFile, false).execute();
            }
            catch (VcsException vcsException) {}
        } else {
            this.myDeletedFiles.add(ioFile);
            if (file.isDirectory() || this.isUndo()) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private RepeatSvnActionThroughBusy createRevertAction(final @NotNull File file, final boolean recursive) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(23);
        }
        return new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                SvnFileSystemListener.this.myVcs.getFactory(file).createRevertClient().revert(Collections.singletonList(file), Depth.allOrFiles(recursive), null);
            }
        };
    }

    @NotNull
    private RepeatSvnActionThroughBusy createDeleteAction(final @NotNull File file, final boolean force) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(24);
        }
        return new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                SvnFileSystemListener.this.myVcs.getFactory(file).createDeleteClient().delete(file, force, false, null);
            }
        };
    }

    private boolean isAboveSourceOfCopyOrMove(File ioFile) {
        for (MovedFileInfo file : this.myMovedFiles) {
            if (!FileUtil.isAncestor((File)ioFile, (File)file.mySrc, (boolean)false)) continue;
            return true;
        }
        for (AddedFileInfo info2 : this.myAddedFiles) {
            if (info2.myCopyFrom == null || !FileUtil.isAncestor((File)ioFile, (File)info2.myCopyFrom, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void moveToUndoStorage(VirtualFile file) {
        if (this.myStorageForUndo == null) {
            try {
                this.myStorageForUndo = FileUtil.createTempDirectory((String)"svnUndoStorage", (String)"");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        File tmpFile = FileUtil.findSequentNonexistentFile((File)this.myStorageForUndo, (String)"tmp", (String)"");
        this.myUndoStorageContents.add(0, (Couple<File>)Couple.of((Object)VfsUtilCore.virtualToIoFile((VirtualFile)file), (Object)tmpFile));
        VfsUtilCore.virtualToIoFile((VirtualFile)file).renameTo(tmpFile);
    }

    private boolean createItem(VirtualFile dir, String name, boolean directory, boolean recursive) {
        VcsShowConfirmationOption.Value value = this.myAddConfirmation.getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            return false;
        }
        if (this.isUndo() && SvnUtil.isAdminDirectory(dir, name)) {
            return false;
        }
        File ioDir = SvnFileSystemListener.getIOFile(dir);
        boolean pendingAdd = this.isPendingAdd(dir);
        if (!SvnUtil.isSvnVersioned(this.myVcs, ioDir) && !pendingAdd) {
            return false;
        }
        File targetFile = new File(ioDir, name);
        Status status = this.getFileStatus(targetFile);
        if (status == null || status.is(StatusType.STATUS_NONE, StatusType.STATUS_UNVERSIONED)) {
            this.myAddedFiles.add(new AddedFileInfo(dir, name, null, recursive));
            return false;
        }
        if (status.is(StatusType.STATUS_MISSING)) {
            return false;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            NodeKind kind = status.getNodeKind();
            if (directory && !kind.isDirectory() || !directory && !kind.isFile()) {
                return false;
            }
            try {
                if (this.isUndo()) {
                    this.createRevertAction(targetFile, false).execute();
                    return true;
                }
                this.myAddedFiles.add(new AddedFileInfo(dir, name, null, recursive));
                return false;
            }
            catch (VcsException e) {
                FileUtil.delete((File)targetFile);
                return false;
            }
        }
        return false;
    }

    private boolean isPendingAdd(VirtualFile dir) {
        for (AddedFileInfo i : this.myAddedFiles) {
            if (!Comparing.equal((Object)i.myDir, (Object)dir.getParent()) || !i.myName.equals(dir.getName())) continue;
            return true;
        }
        return false;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            SvnFileSystemListener.$$$reportNull$$$0(25);
        }
        this.myIsInCommand = true;
        this.myUndoingMove = false;
        if (this.myVcs.getProject() != event.getProject()) {
            return;
        }
        this.commandStarted();
    }

    private void commandStarted() {
        this.myUndoingMove = false;
        this.myMoveExceptions.clear();
    }

    public void commandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            SvnFileSystemListener.$$$reportNull$$$0(26);
        }
        this.myIsInCommand = false;
        if (this.myVcs.getProject() != event.getProject()) {
            return;
        }
        this.commandFinished();
    }

    private void commandFinished() {
        this.checkOverwrites();
        if (!this.myAddedFiles.isEmpty()) {
            this.processAddedFiles();
        }
        this.processMovedFiles();
        if (!this.myDeletedFiles.isEmpty()) {
            this.processDeletedFiles();
        }
        if (!this.myMoveExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).showErrors(this.myMoveExceptions, SvnBundle.message("move.files.errors.title", new Object[0]));
        }
        if (!this.myFilesToRefresh.isEmpty()) {
            this.refreshFiles();
        }
    }

    private void checkOverwrites() {
        if (this.myAddedFiles.isEmpty() || this.myDeletedFiles.isEmpty()) {
            return;
        }
        Iterator<AddedFileInfo> iterator = this.myAddedFiles.iterator();
        while (iterator.hasNext()) {
            AddedFileInfo addedFileInfo = iterator.next();
            File ioFile = new File(addedFileInfo.myDir.getPath(), addedFileInfo.myName);
            if (!this.myDeletedFiles.remove(ioFile)) continue;
            iterator.remove();
        }
    }

    private void refreshFiles() {
        ArrayList<VirtualFile> toRefreshFiles = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> toRefreshDirs = new ArrayList<VirtualFile>();
        for (VirtualFile file : this.myFilesToRefresh) {
            if (file == null) continue;
            if (file.isDirectory()) {
                toRefreshDirs.add(file);
                continue;
            }
            toRefreshFiles.add(file);
        }
        SvnFileSystemListener.filterOutInvalid(this.myFilesToRefresh);
        RefreshQueue.getInstance().refresh(true, true, () -> {
            if (this.myVcs.getProject().isDisposed()) {
                return;
            }
            SvnFileSystemListener.filterOutInvalid(toRefreshFiles);
            SvnFileSystemListener.filterOutInvalid(toRefreshDirs);
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject());
            vcsDirtyScopeManager.filesDirty((Collection)toRefreshFiles, (Collection)toRefreshDirs);
        }, this.myFilesToRefresh);
        this.myFilesToRefresh.clear();
    }

    private static void filterOutInvalid(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            SvnFileSystemListener.$$$reportNull$$$0(27);
        }
        Iterator<VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (file == null) {
                iterator.remove();
                continue;
            }
            if (file.isValid() && file.exists()) continue;
            LOG.info("Refresh root is not valid: " + file.getPath());
            iterator.remove();
        }
    }

    private void processAddedFiles() {
        ArrayList addedVFiles = new ArrayList();
        HashMap<VirtualFile, File> copyFromMap = new HashMap<VirtualFile, File>();
        HashSet recursiveItems = new HashSet();
        this.fillAddedFiles(addedVFiles, copyFromMap, recursiveItems);
        if (addedVFiles.isEmpty()) {
            return;
        }
        VcsShowConfirmationOption.Value value = this.myAddConfirmation.getValue();
        if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            this.runNotUnderWriteAction(() -> {
                AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)this.myVcs.getProject());
                Collection<VirtualFile> filesToProcess = this.promptAboutAddition(addedVFiles, value, vcsHelper);
                if (filesToProcess != null && !filesToProcess.isEmpty()) {
                    ArrayList exceptions = new ArrayList();
                    this.runInBackground(SvnBundle.message("progress.title.adding.files.to.subversion", new Object[0]), this.createAdditionRunnable(copyFromMap, filesToProcess, exceptions));
                    if (!exceptions.isEmpty()) {
                        vcsHelper.showErrors(exceptions, SvnBundle.message("add.files.errors.title", new Object[0]));
                    }
                }
            });
        }
    }

    private void runNotUnderWriteAction(@NotNull Runnable runnable) {
        Application application;
        if (runnable == null) {
            SvnFileSystemListener.$$$reportNull$$$0(28);
        }
        if ((application = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            application.invokeLater(runnable, this.myVcs.getProject().getDisposed());
        } else {
            runnable.run();
        }
    }

    private void runInBackground(@NlsContexts.ProgressTitle @NotNull String name, @NotNull Runnable runnable) {
        if (name == null) {
            SvnFileSystemListener.$$$reportNull$$$0(29);
        }
        if (runnable == null) {
            SvnFileSystemListener.$$$reportNull$$$0(30);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, name, false, this.myVcs.getProject());
        } else {
            runnable.run();
        }
    }

    private Runnable createAdditionRunnable(Map<VirtualFile, File> copyFromMap, Collection<? extends VirtualFile> filesToProcess, List<? super VcsException> exceptions) {
        return () -> {
            for (VirtualFile file : filesToProcess) {
                final File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    final File copyFrom = (File)copyFromMap.get(file);
                    if (copyFrom != null) {
                        try {
                            new ActionWithTempFile(ioFile){

                                protected void executeInternal() throws VcsException {
                                    new RepeatSvnActionThroughBusy(){

                                        @Override
                                        protected void executeImpl() throws VcsException {
                                            SvnFileSystemListener.this.myVcs.getFactory(copyFrom).createCopyMoveClient().copy(copyFrom, ioFile, true, false);
                                        }
                                    }.execute();
                                }
                            }.execute();
                        }
                        catch (VcsException e) {
                            exceptions.add(e);
                        }
                    } else {
                        new RepeatSvnActionThroughBusy(){

                            @Override
                            protected void executeImpl() throws VcsException {
                                SvnFileSystemListener.this.myVcs.getFactory(ioFile).createAddClient().add(ioFile, null, false, false, true, null);
                            }
                        }.execute();
                    }
                    VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).fileDirty(file);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        };
    }

    private Collection<VirtualFile> promptAboutAddition(List<VirtualFile> addedVFiles, VcsShowConfirmationOption.Value value, AbstractVcsHelper vcsHelper) {
        Collection<Object> filesToProcess;
        if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToProcess = addedVFiles;
        } else {
            String singleFilePrompt = addedVFiles.size() == 1 && addedVFiles.get(0).isDirectory() ? SvnBundle.message("confirmation.text.add.dir", new Object[0]) : SvnBundle.message("confirmation.text.add.file", new Object[0]);
            filesToProcess = vcsHelper.selectFilesToProcess(addedVFiles, SvnBundle.message("confirmation.title.add.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.add.file", new Object[0]), singleFilePrompt, this.myAddConfirmation);
        }
        return filesToProcess;
    }

    private void fillAddedFiles(List<? super VirtualFile> addedVFiles, Map<VirtualFile, File> copyFromMap, Set<? super VirtualFile> recursiveItems) {
        ArrayList<AddedFileInfo> addedFileInfos = new ArrayList<AddedFileInfo>(this.myAddedFiles);
        this.myAddedFiles.clear();
        for (AddedFileInfo addedFileInfo : addedFileInfos) {
            boolean isIgnored;
            Status fileStatus;
            File ioFile = new File(SvnFileSystemListener.getIOFile(addedFileInfo.myDir), addedFileInfo.myName);
            VirtualFile addedFile = addedFileInfo.myDir.findChild(addedFileInfo.myName);
            if (addedFile == null) {
                addedFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            }
            if (addedFile == null || (fileStatus = this.getFileStatus(ioFile)) != null && fileStatus.is(StatusType.STATUS_IGNORED) || (isIgnored = ChangeListManager.getInstance((Project)this.myVcs.getProject()).isIgnoredFile(addedFile))) continue;
            addedVFiles.add((VirtualFile)addedFile);
            copyFromMap.put(addedFile, addedFileInfo.myCopyFrom);
            if (!addedFileInfo.myRecursive) continue;
            recursiveItems.add((VirtualFile)addedFile);
        }
    }

    private void processDeletedFiles() {
        ArrayList deletedFiles = new ArrayList();
        ArrayList<FilePath> filesToProcess = new ArrayList<FilePath>();
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)this.myVcs.getProject());
        try {
            this.fillDeletedFiles(deletedFiles, filesToProcess);
            if (deletedFiles.isEmpty() && filesToProcess.isEmpty() || this.myUndoingMove) {
                return;
            }
            VcsShowConfirmationOption.Value value = this.myDeleteConfirmation.getValue();
            if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                Collection<FilePath> confirmed;
                if (!deletedFiles.isEmpty() && (confirmed = this.promptAboutDeletion(deletedFiles, value, vcsHelper)) != null) {
                    filesToProcess.addAll(confirmed);
                }
                if (!filesToProcess.isEmpty()) {
                    this.runInBackground(SvnBundle.message("progress.title.deleting.files.from.subversion", new Object[0]), this.createDeleteRunnable(filesToProcess, exceptions));
                }
                List deletedFilesFiles = ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst());
                for (FilePath file : deletedFilesFiles) {
                    FilePath parent = file.getParentPath();
                    if (parent == null) continue;
                    this.myFilesToRefresh.add(parent.getVirtualFile());
                }
                for (FilePath file : deletedFilesFiles) {
                    if (filesToProcess.contains(file)) continue;
                    FileUtil.delete((File)file.getIOFile());
                }
            }
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            vcsHelper.showErrors(exceptions, SvnBundle.message("delete.files.errors.title", new Object[0]));
        }
    }

    private Runnable createDeleteRunnable(Collection<? extends FilePath> filesToProcess, List<? super VcsException> exceptions) {
        return () -> {
            for (FilePath file : filesToProcess) {
                VirtualFile vFile = file.getVirtualFile();
                File ioFile = new File(file.getPath());
                try {
                    this.createDeleteAction(ioFile, true).execute();
                    if (vFile != null && vFile.isValid() && vFile.isDirectory()) {
                        vFile.refresh(true, true);
                        VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).dirDirtyRecursively(vFile);
                        continue;
                    }
                    VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).fileDirty(file);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        };
    }

    private Collection<FilePath> promptAboutDeletion(List<? extends Pair<FilePath, WorkingCopyFormat>> deletedFiles, VcsShowConfirmationOption.Value value, AbstractVcsHelper vcsHelper) {
        List filesToProcess;
        if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToProcess = ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst());
        } else {
            String singleFilePrompt = deletedFiles.size() == 1 && ((FilePath)deletedFiles.get(0).getFirst()).isDirectory() ? (((WorkingCopyFormat)((Object)deletedFiles.get(0).getSecond())).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? SvnBundle.message("confirmation.text.delete.dir.17", new Object[0]) : SvnBundle.message("confirmation.text.delete.dir", new Object[0])) : SvnBundle.message("confirmation.text.delete.file", new Object[0]);
            Collection files = vcsHelper.selectFilePathsToProcess(ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst()), SvnBundle.message("confirmation.title.delete.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.delete.file", new Object[0]), singleFilePrompt, this.myDeleteConfirmation);
            filesToProcess = files == null ? null : new ArrayList(files);
        }
        return filesToProcess;
    }

    private void fillDeletedFiles(List<? super Pair<FilePath, WorkingCopyFormat>> deletedFiles, Collection<? super FilePath> deleteAnyway) throws VcsException {
        ArrayList<File> files = new ArrayList<File>(this.myDeletedFiles);
        this.myDeletedFiles.clear();
        for (final File file : files) {
            Status status = (Status)new RepeatSvnActionThroughBusy(){

                @Override
                protected void executeImpl() throws VcsException {
                    this.myT = SvnFileSystemListener.this.myVcs.getFactory(file).createStatusClient().doStatus(file, false);
                }
            }.compute();
            FilePath filePath = VcsUtil.getFilePath((File)file);
            if (status.is(StatusType.STATUS_ADDED)) {
                deleteAnyway.add((FilePath)filePath);
                continue;
            }
            deletedFiles.add((Pair<FilePath, WorkingCopyFormat>)Pair.create((Object)filePath, (Object)((Object)this.myVcs.getWorkingCopyFormat(file))));
        }
    }

    private void processMovedFiles() {
        if (this.myMovedFiles.isEmpty()) {
            return;
        }
        Runnable runnable = () -> {
            Iterator<MovedFileInfo> iterator = this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFileInfo = iterator.next();
                this.doMove(movedFileInfo.mySrc, movedFileInfo.myDst);
                iterator.remove();
            }
        };
        this.runInBackground(SvnBundle.message("progress.title.moving.files.in.subversion", new Object[0]), runnable);
    }

    @NotNull
    private static File getIOFile(@NotNull VirtualFile vf) {
        if (vf == null) {
            SvnFileSystemListener.$$$reportNull$$$0(31);
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)vf).getAbsoluteFile();
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(32);
        }
        return file;
    }

    @Nullable
    private Status getFileStatus(final @NotNull File file) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(33);
        }
        try {
            return (Status)new RepeatSvnActionThroughBusy(){

                @Override
                protected void executeImpl() throws VcsException {
                    this.myT = SvnFileSystemListener.this.myVcs.getFactory(file).createStatusClient().doStatus(file, false);
                }
            }.compute();
        }
        catch (VcsException e) {
            return null;
        }
    }

    private boolean isUndo() {
        return UndoManager.getInstance((Project)this.myVcs.getProject()).isUndoInProgress();
    }

    private void startOperation(@NotNull VirtualFile file) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(34);
        }
        if (!this.myIsInCommand) {
            boolean bl = this.myIsOperationStarted = this.myVcs.getProject() == ProjectLocator.getInstance().guessProjectForFile(file);
            if (this.myIsOperationStarted) {
                this.commandStarted();
            }
        }
    }

    public void afterDone(@NotNull ThrowableConsumer<? super LocalFileOperationsHandler, ? extends IOException> invoker) {
        if (invoker == null) {
            SvnFileSystemListener.$$$reportNull$$$0(35);
        }
        if (!this.myIsInCommand && this.myIsOperationStarted) {
            this.commandFinished();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnFileSystemListener";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstDir";
                break;
            }
            case 10: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 19: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnFileSystemListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "handleMoveException";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIOFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMyVcs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleMoveException";
                break;
            }
            case 3: 
            case 32: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMoveTargetExistsError";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sameRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryUUID";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUnversioned";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createRevertAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteAction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "commandStarted";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "commandFinished";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterOutInvalid";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "runNotUnderWriteAction";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runInBackground";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getIOFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFileStatus";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "startOperation";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "afterDone";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 32 -> new IllegalStateException(string);
        };
    }

    private static class AddedFileInfo {
        private final VirtualFile myDir;
        private final String myName;
        @Nullable
        private final File myCopyFrom;
        private final boolean myRecursive;

        AddedFileInfo(@NotNull VirtualFile dir, @NotNull String name, @Nullable File copyFrom, boolean recursive) {
            if (dir == null) {
                AddedFileInfo.$$$reportNull$$$0(0);
            }
            if (name == null) {
                AddedFileInfo.$$$reportNull$$$0(1);
            }
            this.myDir = dir;
            this.myName = name;
            this.myCopyFrom = copyFrom;
            this.myRecursive = recursive;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/SvnFileSystemListener$AddedFileInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MovedFileInfo {
        private final File mySrc;
        private final File myDst;

        private MovedFileInfo(@NotNull File src, @NotNull File dst) {
            if (src == null) {
                MovedFileInfo.$$$reportNull$$$0(0);
            }
            if (dst == null) {
                MovedFileInfo.$$$reportNull$$$0(1);
            }
            this.mySrc = src;
            this.myDst = dst;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "src";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dst";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/SvnFileSystemListener$MovedFileInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

