/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Path;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;

public class GeneralSettingsPanel
implements ConfigurableUi<SvnConfiguration>,
Disposable {
    @NotNull
    private final Project myProject;
    private JPanel myMainPanel;
    private JCheckBox myUseCustomConfigurationDirectory;
    private TextFieldWithBrowseButton myConfigurationDirectoryText;
    private JButton myClearAuthButton;
    private JBCheckBox myRunUnderTerminal;
    private TextFieldWithBrowseButton myCommandLineClient;

    public GeneralSettingsPanel(@NotNull Project project) {
        if (project == null) {
            GeneralSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myUseCustomConfigurationDirectory.addActionListener(e -> {
            boolean enabled = this.myUseCustomConfigurationDirectory.isSelected();
            this.myConfigurationDirectoryText.setEnabled(enabled);
            this.myConfigurationDirectoryText.setEditable(enabled);
            SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
            String path = configuration.getConfigurationDirectory();
            if (!enabled || path == null) {
                this.myConfigurationDirectoryText.setText(((Path)SvnUtil.USER_CONFIGURATION_PATH.getValue()).toString());
            } else {
                this.myConfigurationDirectoryText.setText(path);
            }
        });
        this.myCommandLineClient.addBrowseFolderListener(SvnBundle.message("dialog.title.select.path.to.subversion.executable", new Object[0]), SvnBundle.message("label.select.path.to.subversion.executable", new Object[0]), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myClearAuthButton.addActionListener(e -> SvnAuthenticationNotifier.clearAuthenticationCache(this.myProject, this.myMainPanel, this.myConfigurationDirectoryText.getText()));
        this.myConfigurationDirectoryText.addActionListener(e -> {
            @NonNls String path = this.myConfigurationDirectoryText.getText().trim();
            SvnConfigurable.selectConfigurationDirectory(path, (Consumer<? super String>)((Consumer)s -> this.myConfigurationDirectoryText.setText(s)), this.myProject, this.myMainPanel);
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            GeneralSettingsPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void reset(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            GeneralSettingsPanel.$$$reportNull$$$0(2);
        }
        String path = configuration.getConfigurationDirectory();
        if (configuration.isUseDefaultConfiguration() || path == null) {
            path = ((Path)SvnUtil.USER_CONFIGURATION_PATH.getValue()).toString();
        }
        this.myConfigurationDirectoryText.setText(path);
        this.myUseCustomConfigurationDirectory.setSelected(!configuration.isUseDefaultConfiguration());
        boolean enabled = this.myUseCustomConfigurationDirectory.isSelected();
        this.myConfigurationDirectoryText.setEnabled(enabled);
        this.myConfigurationDirectoryText.setEditable(enabled);
        this.myRunUnderTerminal.setSelected(configuration.isRunUnderTerminal());
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        this.myCommandLineClient.setText(applicationSettings17.getCommandLinePath());
    }

    public boolean isModified(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            GeneralSettingsPanel.$$$reportNull$$$0(3);
        }
        if (configuration.isUseDefaultConfiguration() == this.myUseCustomConfigurationDirectory.isSelected()) {
            return true;
        }
        if (configuration.isRunUnderTerminal() != this.myRunUnderTerminal.isSelected()) {
            return true;
        }
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        if (!Objects.equals(applicationSettings17.getCommandLinePath(), this.myCommandLineClient.getText().trim())) {
            return true;
        }
        return !configuration.getConfigurationDirectory().equals(this.myConfigurationDirectoryText.getText().trim());
    }

    public void apply(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            GeneralSettingsPanel.$$$reportNull$$$0(4);
        }
        configuration.setConfigurationDirParameters(!this.myUseCustomConfigurationDirectory.isSelected(), this.myConfigurationDirectoryText.getText());
        SvnVcs vcs17 = SvnVcs.getInstance(this.myProject);
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        boolean reloadWorkingCopies = !StringUtil.equals((CharSequence)applicationSettings17.getCommandLinePath(), (CharSequence)this.myCommandLineClient.getText().trim());
        configuration.setRunUnderTerminal(this.myRunUnderTerminal.isSelected());
        applicationSettings17.setCommandLinePath(this.myCommandLineClient.getText().trim());
        boolean isClientValid = vcs17.checkCommandLineVersion();
        if (!this.myProject.isDefault() && isClientValid && reloadWorkingCopies) {
            vcs17.invokeRefreshSvnRoots();
            VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
        }
    }

    public void dispose() {
    }

    private void createUIComponents() {
        this.myCommandLineClient = new TextFieldWithBrowseButton(null, (Disposable)this);
        this.myConfigurationDirectoryText = new TextFieldWithBrowseButton(null, (Disposable)this);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myClearAuthButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/SvnBundle", GeneralSettingsPanel.class).getString("button.text.clear.authentication.cache"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/SvnBundle", GeneralSettingsPanel.class).getString("label.text.delete.stored.credentials"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myCommandLineClient;
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/SvnBundle", GeneralSettingsPanel.class).getString("label.path.to.svn.executable"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/SvnBundle", GeneralSettingsPanel.class).getString("command.line.interactive.mode.description"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myUseCustomConfigurationDirectory = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/SvnBundle", GeneralSettingsPanel.class).getString("settings.use.custom.directory"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myConfigurationDirectoryText;
        textFieldWithBrowseButton2.setEditable(false);
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myRunUnderTerminal = jBCheckBox = new JBCheckBox();
        jBCheckBox.setMargin(new Insets(2, -2, 2, 3));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SvnBundle", GeneralSettingsPanel.class).getString("command.line.interactive.mode.title"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/GeneralSettingsPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/GeneralSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

