/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.ui.JBUI;
import com.jediterm.core.util.TermSize;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalContentController;
import org.jetbrains.plugins.terminal.exp.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.TerminalPanel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/exp/PlainTerminalController;", "Lorg/jetbrains/plugins/terminal/exp/TerminalContentController;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "panel", "Lorg/jetbrains/plugins/terminal/exp/TerminalPanel;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "getTerminalSize", "Lcom/jediterm/core/util/TermSize;", "isFocused", "", "intellij.terminal"})
public final class PlainTerminalController
implements TerminalContentController {
    @NotNull
    private final TerminalSession session;
    @NotNull
    private final TerminalPanel panel;

    public PlainTerminalController(@NotNull Project project, @NotNull TerminalSession session, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.session = session;
        TerminalEventsHandler eventsHandler = new TerminalEventsHandler(this.session, settings);
        this.panel = new TerminalPanel(project, settings, this.session.getModel(), eventsHandler);
        this.panel.setBorder((Border)JBUI.Borders.empty());
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                TermSize termSize = this.getTerminalSize();
                if (termSize == null) {
                    return;
                }
                TermSize newSize = termSize;
                session.postResize(newSize);
            }
        });
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.panel));
    }

    @Override
    @Nullable
    public TermSize getTerminalSize() {
        if (this.panel.getBounds().isEmpty()) {
            return null;
        }
        Dimension contentSize = this.panel.getContentSize();
        return TerminalUiUtils.INSTANCE.calculateTerminalSize(contentSize, this.panel.getCharSize());
    }

    @Override
    public boolean isFocused() {
        return this.panel.isFocused();
    }

    @NotNull
    public JComponent getComponent() {
        return this.panel;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.panel.getPreferredFocusableComponent();
    }

    public void dispose() {
    }
}

