/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaExcludedPluginsCalculator;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaExcludedPluginsCalculatorKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0002J2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExcludedPluginsCalculator;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "commandName", "", "getCommandName", "()Ljava/lang/String;", "requiredModality", "", "getRequiredModality", "()I", "calculateActual", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "included", "", "main", "", "args", "printHelpAndExit", "processPlugin", "descriptor", "include", "", "processed", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaExcludedPluginsCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaExcludedPluginsCalculator.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExcludedPluginsCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1603#2,9:105\n1855#2:114\n1856#2:116\n1612#2:117\n1549#2:118\n1620#2,3:119\n1549#2:122\n1620#2,3:123\n1603#2,9:126\n1855#2:135\n1856#2:137\n1612#2:138\n1#3:115\n1#3:136\n*S KotlinDebug\n*F\n+ 1 QodanaExcludedPluginsCalculator.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExcludedPluginsCalculator\n*L\n40#1:105,9\n40#1:114\n40#1:116\n40#1:117\n61#1:118\n61#1:119,3\n85#1:122\n85#1:123,3\n100#1:126,9\n100#1:135\n100#1:137\n100#1:138\n40#1:115\n100#1:136\n*E\n"})
public final class QodanaExcludedPluginsCalculator
implements ApplicationStarter {
    @NotNull
    public String getCommandName() {
        return "qodanaExcludedPlugins";
    }

    public int getRequiredModality() {
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    public void main(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (args.size() < 3) {
            this.printHelpAndExit();
        }
        String input = args.get(1);
        String output2 = args.get(2);
        try {
            void $this$mapNotNullTo$iv$iv;
            List requiredIds = FilesKt.readLines$default((File)new File(input), null, (int)1, null);
            if (requiredIds.isEmpty()) {
                this.printHelpAndExit();
            }
            Set<IdeaPluginDescriptor> included = this.calculateActual(requiredIds);
            Path dockerIgnorePath = Paths.get(output2, new String[0]);
            Path baseFolder = dockerIgnorePath.getParent().toAbsolutePath();
            Iterable $this$mapNotNull$iv = included;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
                boolean bl2 = false;
                String pathPresentation = ((Object)it.getPluginPath()).toString();
                Path path = Paths.get(pathPresentation, new String[0]).toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if ((Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? "!" + baseFolder.relativize(path) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List includedPaths = (List)destination$iv$iv;
            File file = dockerIgnorePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dockerIgnorePath.toFile()");
            FilesKt.appendText$default((File)file, (String)("\n" + CollectionsKt.joinToString$default((Iterable)includedPaths, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), null, (int)2, null);
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
        catch (Throwable e) {
            QodanaExcludedPluginsCalculatorKt.access$getLOG$p().error(e);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void printHelpAndExit() {
        System.out.println((Object)"Expected parameters: <path to file with list of included plugins> <.dockerginore path>");
        System.exit(1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IdeaPluginDescriptor> calculateActual(List<String> included) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        List list2 = PluginManagerCore.getLoadedPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLoadedPlugins()");
        List plugins = list2;
        Iterable $this$map$iv2 = plugins;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv2;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(it.getPluginId().getIdString());
        }
        List pluginIds2 = (List)destination$iv$iv;
        Set processed = new LinkedHashSet();
        LinkedList toProcess = new LinkedList(included);
        Set include = new LinkedHashSet();
        while (!((Collection)toProcess).isEmpty()) {
            String idString = (String)toProcess.pop();
            PluginId pluginId = PluginId.findId((String)idString);
            if (pluginId == null) {
                QodanaExcludedPluginsCalculatorKt.access$getLOG$p().error("Can't find plugin id '" + idString + "'");
                continue;
            }
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            if (descriptor == null) continue;
            CollectionsKt.addAll((Collection)toProcess, (Iterable)this.processPlugin(descriptor, include, processed));
        }
        System.out.println((Object)"=====INCLUDED=======");
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)include, (CharSequence)"\n", null, null, (int)0, null, (Function1)calculateActual.1.INSTANCE, (int)30, null));
        Iterable pluginId = include;
        iterable = pluginIds2;
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getPluginId().getIdString());
        }
        List disabled = CollectionsKt.minus((Iterable)iterable, (Iterable)((List)destination$iv$iv2));
        System.out.println((Object)"=====DISABLED=======");
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)disabled), (CharSequence)"\n", null, null, (int)0, null, (Function1)calculateActual.2.INSTANCE, (int)30, null));
        return include;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> processPlugin(IdeaPluginDescriptor descriptor, Set<IdeaPluginDescriptor> include, Set<String> processed) {
        void $this$mapNotNullTo$iv$iv;
        String string = descriptor.getPluginId().getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.pluginId.idString");
        String idString = string;
        if (processed.contains(idString)) {
            return CollectionsKt.emptyList();
        }
        processed.add(idString);
        include.add(descriptor);
        List list2 = descriptor.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"descriptor.dependencies");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IdeaPluginDependency it = (IdeaPluginDependency)element$iv$iv;
            boolean bl2 = false;
            if ((processed.contains(it.getPluginId().getIdString()) || it.isOptional() ? null : it.getPluginId().getIdString()) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

