/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.InspectScope;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifierKt;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/IncludeScopeModifier;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaScopeModifier;", "scope", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "level", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "severity", "", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;Lcom/intellij/codeHighlighting/HighlightDisplayLevel;Ljava/lang/String;)V", "getLevel", "()Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "updateProfileScopes", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "Ljava/nio/file/Path;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaScopeModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaScopeModifier.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/IncludeScopeModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1726#2,3:136\n*S KotlinDebug\n*F\n+ 1 QodanaScopeModifier.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/IncludeScopeModifier\n*L\n88#1:136,3\n*E\n"})
public final class IncludeScopeModifier
extends QodanaScopeModifier {
    @NotNull
    private final HighlightDisplayLevel level;

    public IncludeScopeModifier(@NotNull InspectScope scope, @NotNull HighlightDisplayLevel level, @NotNull String severity) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Object[] objectArray = new Object[]{severity, scope.getName()};
        String string = QodanaBundle.message("qodana.yaml.include.scope.name.w.severity", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"qodana.yaml.inc\u2026y\", severity, scope.name)");
        super(scope, string);
        this.level = level;
    }

    @NotNull
    public final HighlightDisplayLevel getLevel() {
        return this.level;
    }

    @Override
    public void updateProfileScopes(@NotNull QodanaInspectionProfile profile2, @NotNull Project project2, @NotNull Path projectPath) {
        boolean isEmptyScope;
        Intrinsics.checkNotNullParameter((Object)((Object)profile2), (String)"profile");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        ToolsImpl toolsImpl = profile2.getToolsOrNull(this.getScope().getName(), project2);
        if (toolsImpl == null) {
            return;
        }
        ToolsImpl tools = toolsImpl;
        boolean bl = isEmptyScope = this.getScope().getPaths().isEmpty() && this.getScope().getPatterns().isEmpty();
        if (tools.isEnabled()) {
            if (!isEmptyScope) {
                tools.prependTool(this.getProfileScope$intellij_qodana(projectPath), tools.getTool(), true, this.level);
            }
            return;
        }
        tools.getDefaultState().setEnabled(false);
        tools.setEnabled(true);
        if (isEmptyScope) {
            boolean bl2;
            block8: {
                List list2 = tools.getTools();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"tools.tools");
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ScopeToolState it = (ScopeToolState)element$iv;
                        boolean bl3 = false;
                        if (!it.isEnabled()) continue;
                        bl2 = false;
                        break block8;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                tools.getDefaultState().setEnabled(true);
                tools.getDefaultState().setLevel(this.level);
            }
            return;
        }
        QodanaScopeModifierKt.access$disableAllScopes(tools);
        tools.prependTool(this.getProfileScope$intellij_qodana(projectPath), tools.getTool(), true, this.level);
    }
}

