/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.highlight.QodanaHighlightedReportService;
import org.jetbrains.qodana.report.LocalReportDescriptor;
import org.jetbrains.qodana.report.LocalReportDescriptorKt;
import org.jetbrains.qodana.report.QodanaLocalReportsService;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollectorKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/qodana/actions/OpenLocalReportAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "reportDescriptor", "Lorg/jetbrains/qodana/report/LocalReportDescriptor;", "(Lorg/jetbrains/qodana/report/LocalReportDescriptor;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "logHighlightStats", "", "project", "Lcom/intellij/openapi/project/Project;", "isHighlighted", "setSelected", "newSelectedButtonState", "Companion", "intellij.qodana"})
public final class OpenLocalReportAction
extends DumbAwareToggleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalReportDescriptor reportDescriptor;

    public OpenLocalReportAction(@NotNull LocalReportDescriptor reportDescriptor) {
        Intrinsics.checkNotNullParameter((Object)reportDescriptor, (String)"reportDescriptor");
        this.reportDescriptor = reportDescriptor;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return false;
        }
        LocalReportDescriptor.HighlightedState highlightedState = LocalReportDescriptorKt.getHighlightedState(this.reportDescriptor, project2);
        e.getPresentation().setText(this.reportDescriptor.getName(highlightedState));
        return switch (WhenMappings.$EnumSwitchMapping$0[highlightedState.ordinal()]) {
            case 1, 2 -> true;
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public void setSelected(@NotNull AnActionEvent e, boolean newSelectedButtonState) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        QodanaHighlightedReportService highlightedReportService = QodanaHighlightedReportService.Companion.getInstance(project3);
        if (WhenMappings.$EnumSwitchMapping$0[LocalReportDescriptorKt.getHighlightedState(this.reportDescriptor, project3).ordinal()] == 3) {
            QodanaHighlightedReportService.launchHighlightReport$default(highlightedReportService, this.reportDescriptor, false, false, 6, null);
            this.logHighlightStats(project3, true);
        } else {
            QodanaHighlightedReportService.launchHighlightReport$default(highlightedReportService, null, false, false, 6, null);
            this.logHighlightStats(project3, false);
        }
    }

    private final void logHighlightStats(Project project2, boolean isHighlighted) {
        QodanaPluginStatsCounterCollector.UPDATE_HIGHLIGHTED_REPORT.log(project2, (Object)isHighlighted, (Object)QodanaPluginStatsCounterCollectorKt.toStatsReportType(this.reportDescriptor), (Object)QodanaPluginStatsCounterCollector.SourceHighlight.TOOLS_LIST);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/actions/OpenLocalReportAction$Companion;", "", "()V", "getLocalReportsActions", "", "Lorg/jetbrains/qodana/actions/OpenLocalReportAction;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nOpenLocalReportAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenLocalReportAction.kt\norg/jetbrains/qodana/actions/OpenLocalReportAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1549#2:65\n1620#2,3:66\n*S KotlinDebug\n*F\n+ 1 OpenLocalReportAction.kt\norg/jetbrains/qodana/actions/OpenLocalReportAction$Companion\n*L\n17#1:65\n17#1:66,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<OpenLocalReportAction> getLocalReportsActions(@NotNull Project project2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Iterable $this$map$iv = QodanaLocalReportsService.Companion.getInstance(project2).getReports();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LocalReportDescriptor localReportDescriptor = (LocalReportDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new OpenLocalReportAction((LocalReportDescriptor)it));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LocalReportDescriptor.HighlightedState.values().length];
            try {
                nArray[LocalReportDescriptor.HighlightedState.SELECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocalReportDescriptor.HighlightedState.LOADING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocalReportDescriptor.HighlightedState.NOT_SELECTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

