/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.model.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryNavigatable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.PackageUtilKt;
import org.jetbrains.security.api.BuildFileProvider;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.extension.jps.JpsBuildFileProvider;
import org.jetbrains.security.extension.maven.MavenBuildFileProvider;
import org.jetbrains.security.model.Dependency;
import org.jetbrains.security.model.impl.IJModuleModel;
import org.jetbrains.security.model.impl.IntellijModuleProjectDependenciesModel;
import org.jetbrains.security.model.impl.MutableModuleModel;
import org.jetbrains.security.model.impl.ProjectDependenciesModelBase;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.service.PackageCheckerDisposable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J4\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0014\u0010\u0018\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/security/model/impl/IntellijModuleProjectDependenciesModel;", "Lorg/jetbrains/security/model/impl/ProjectDependenciesModelBase;", "Lorg/jetbrains/security/model/impl/IJModuleModel;", "Lcom/intellij/openapi/project/ModuleListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectDependencies", "", "Lorg/jetbrains/security/model/Dependency;", "module", "Lcom/intellij/openapi/module/Module;", "createModule", "declaredDependencies", "", "Lorg/jetbrains/security/api/PackageDeclaration;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getAllModules", "moduleRemoved", "", "modulesAdded", "modules", "modulesRenamed", "oldNameProvider", "Lcom/intellij/util/Function;", "", "shouldProcess", "", "supports", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nIntellijModuleProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijModuleProjectDependenciesModel.kt\norg/jetbrains/security/model/impl/IntellijModuleProjectDependenciesModel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n8#2:140\n1#3:141\n3792#4:142\n4307#4,2:143\n1549#5:145\n1620#5,3:146\n*S KotlinDebug\n*F\n+ 1 IntellijModuleProjectDependenciesModel.kt\norg/jetbrains/security/model/impl/IntellijModuleProjectDependenciesModel\n*L\n60#1:140\n111#1:142\n111#1:143,2\n113#1:145\n113#1:146,3\n*E\n"})
public final class IntellijModuleProjectDependenciesModel
extends ProjectDependenciesModelBase<IJModuleModel>
implements ModuleListener {
    @NotNull
    private final Project project;

    public IntellijModuleProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        String string = IntellijModuleProjectDependenciesModel.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IntellijModuleProjectDep\u2026iesModel::class.java.name");
        super(completableJob.plus((CoroutineContext)new CoroutineName(string)));
        this.project = project;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ProjectTopics.MODULES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"MODULES");
        messageBusConnection.subscribe(topic, (Object)this);
        this.init();
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
    }

    public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        for (Module module : modules) {
            if (!this.shouldProcess(module)) continue;
            this.addModule((MutableModuleModel)this.createModule(module));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldProcess(@NotNull Module module) {
        String string;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed()) {
            return false;
        }
        try {
            string = ExternalSystemModulePropertyManager.Companion.getInstance(module).getExternalSystemId();
        }
        catch (Exception e) {
            IntellijModuleProjectDependenciesModel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(IntellijModuleProjectDependenciesModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error("Can't get externalSystemId for module: " + module + ", module.isLoaded: " + module.isLoaded() + ", module.project: " + module.getProject() + ", module.file: " + module.getModuleFile(), (Throwable)e);
            return false;
        }
        String externalSystemId = string;
        if (Intrinsics.areEqual((Object)new ProjectSystemId("GRADLE").getId(), (Object)externalSystemId)) return false;
        MavenBuildFileProvider mavenBuildFileProvider = (MavenBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtension(MavenBuildFileProvider.class, (AreaInstance)this.project);
        if (mavenBuildFileProvider == null) return true;
        boolean bl = mavenBuildFileProvider.supports(module);
        if (bl) return false;
        return true;
    }

    public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
        this.refresh();
    }

    private final IJModuleModel createModule(Module module) {
        IJModuleModel iJModuleModel;
        IJModuleModel $this$createModule_u24lambda_u240 = iJModuleModel = new IJModuleModel(module.getName() + " IJ module", module, this.project);
        boolean bl = false;
        $this$createModule_u24lambda_u240.setDependencies(this.collectDependencies(module));
        return iJModuleModel;
    }

    private final Iterable<Dependency> collectDependencies(Module module) {
        List deps = new ArrayList();
        if (module.isDisposed()) {
            return deps;
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> IntellijModuleProjectDependenciesModel.collectDependencies$lambda$1((Function1)new Function1<Library, Boolean>((List<Dependency>)deps, module){
            final /* synthetic */ List<Dependency> $deps;
            final /* synthetic */ Module $module;
            {
                this.$deps = $deps;
                this.$module = $module;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Library it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Package pkg = PackageUtilKt.createPackage(it);
                if (pkg != null) {
                    this.$deps.add(new Dependency(pkg, CollectionsKt.emptyList(), arg_0 -> collectDependencies.1.invoke$lambda$0(it, this.$module, arg_0)));
                }
                return true;
            }

            private static final Object invoke$lambda$0(Library $it, Module $module, String dataId) {
                Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                return CommonDataKeys.NAVIGATABLE.is(dataId) ? new LibraryNavigatable($it, $module) : (PlatformDataKeys.MODULE.is(dataId) ? $module : null);
            }
        }, arg_0));
        return deps;
    }

    public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.refresh();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<IJModuleModel> getAllModules() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(this.project).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Module element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!this.shouldProcess((Module)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module element$iv$iv;
            element$iv$iv = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createModule((Module)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).supports(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).supports(module);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).declaredDependencies(psiFile);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = ReadAction.compute(() -> IntellijModuleProjectDependenciesModel.declaredDependencies$lambda$5(this, module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute<List<PackageDecl\u2026   } ?: emptyList()\n    }");
        return (List)object;
    }

    private static final boolean collectDependencies$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List declaredDependencies$lambda$5(IntellijModuleProjectDependenciesModel this$0, Module $module) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
                object = ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this$0.project)).moduleScript($module);
                if (object == null) break block2;
                PsiFile it = object;
                boolean bl = false;
                List<PackageDeclaration> list = this$0.declaredDependencies(it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

