/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.maven;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.security.PackageUtilKt;
import org.jetbrains.security.extension.BuildFileProviderBase;
import org.jetbrains.security.extension.maven.MavenBuildFileProvider;
import org.jetbrains.security.extension.maven.MavenBuildFileProviderKt;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/security/extension/maven/MavenBuildFileProvider;", "Lorg/jetbrains/security/extension/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getModule", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "getRoots", "", "Lorg/jetbrains/security/package/Package;", "", "pkgs", "importedPackages", "module", "moduleScript", "supports", "", "versionFallback", "", "unifiedDependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nMavenBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenBuildFileProvider.kt\norg/jetbrains/security/extension/maven/MavenBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1603#2,9:86\n1855#2:95\n1856#2:97\n1612#2:98\n1603#2,9:99\n1855#2:108\n1856#2:110\n1612#2:111\n1#3:96\n1#3:109\n*S KotlinDebug\n*F\n+ 1 MavenBuildFileProvider.kt\norg/jetbrains/security/extension/maven/MavenBuildFileProvider\n*L\n31#1:86,9\n31#1:95\n31#1:97\n31#1:98\n40#1:99,9\n40#1:108\n40#1:110\n40#1:111\n31#1:96\n40#1:109\n*E\n"})
public final class MavenBuildFileProvider
extends BuildFileProviderBase {
    public MavenBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return MavenDomUtil.isProjectFile((PsiFile)file2) && MavenDomUtil.findContainingMavenizedModule((PsiFile)file2) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)this.getProject()).findProject(file2.getVirtualFile());
        if (mavenProject == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject findProject = mavenProject;
        List list = findProject.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findProject.dependencies");
        List dependencies = list;
        Iterable $this$mapNotNull$iv = dependencies;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifact mavenArtifact = (MavenArtifact)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"mavenArtifact");
            if (MavenBuildFileProviderKt.createPackage(mavenArtifact) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull Module module) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)this.getProject()).findProject(module);
        if (mavenProject == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject findProject = mavenProject;
        List list = findProject.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findProject.dependencies");
        List dependencies = list;
        Iterable $this$mapNotNull$iv = dependencies;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifact it = (MavenArtifact)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (MavenBuildFileProviderKt.createPackage(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Module getModule(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = MavenDomUtil.findContainingMavenizedModule((PsiFile)file2);
        if (module == null) {
            throw new IllegalStateException("Non Maven file".toString());
        }
        return module;
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MavenUtil.isMavenModule((Module)module);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file2, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return MapsKt.emptyMap();
        }
        VirtualFile virtualFile2 = virtualFile;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"getInstance(project)");
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(virtualFile2);
        if (mavenProject == null) {
            return MapsKt.emptyMap();
        }
        MavenProject mavenProject2 = mavenProject;
        List list = mavenProject2.getDependencyTree();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mavenProject.dependencyTree");
        List dependencyTree = list;
        return PackageUtilKt.rootDependencies(dependencyTree, getRoots.1.INSTANCE, getRoots.2.INSTANCE);
    }

    @Override
    @Nullable
    protected String versionFallback(@Nullable PsiFile file2, @NotNull Module module, @NotNull UnifiedDependency unifiedDependency) {
        MavenArtifact mavenArtifact;
        Object v4;
        block2: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)unifiedDependency, (String)"unifiedDependency");
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)this.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"getInstance(project)");
            MavenProjectsManager manager = mavenProjectsManager;
            MavenProject mavenProject = manager.findProject(module);
            if (mavenProject == null) {
                return null;
            }
            MavenProject mavenProject2 = mavenProject;
            List list = mavenProject2.getDependencyTree();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mavenProject.dependencyTree");
            List dependencyTree = list;
            Iterable iterable = dependencyTree;
            for (Object t : iterable) {
                MavenArtifactNode it = (MavenArtifactNode)t;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.getArtifact().getGroupId(), (Object)unifiedDependency.getCoordinates().getGroupId()) && Intrinsics.areEqual((Object)it.getArtifact().getArtifactId(), (Object)unifiedDependency.getCoordinates().getArtifactId());
                if (!bl2) continue;
                v4 = t;
                break block2;
            }
            v4 = null;
        }
        MavenArtifactNode mavenArtifactNode = v4;
        return mavenArtifactNode != null && (mavenArtifact = mavenArtifactNode.getArtifact()) != null ? mavenArtifact.getVersion() : null;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)this.getProject()).findProject(module);
        if (mavenProject == null) {
            return null;
        }
        MavenProject findProject = mavenProject;
        if (this.getProject().isDisposed() || !findProject.getFile().isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)this.getProject()).findFile(findProject.getFile());
    }
}

