/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ui.targetPathEditor;

import com.intellij.execution.Platform;
import com.intellij.execution.target.BrowsableTargetEnvironmentType;
import com.intellij.execution.target.TargetBrowserHints;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetUIUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.ui.targetPathEditor.ManualPathEntryDialog;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/ui/targetPathEditor/ManualPathEntryDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "platform", "Lcom/intellij/execution/Platform;", "targetConfig", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/Platform;Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)V", "<set-?>", "", "path", "getPath", "()Ljava/lang/String;", "targetConfigAndType", "Lkotlin/Pair;", "Lcom/intellij/execution/target/BrowsableTargetEnvironmentType;", "createCenterPanel", "Ljavax/swing/JComponent;", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nManualPathEntryDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualPathEntryDialog.kt\ncom/jetbrains/python/ui/targetPathEditor/ManualPathEntryDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class ManualPathEntryDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Platform platform;
    @Nullable
    private final Pair<TargetEnvironmentConfiguration, BrowsableTargetEnvironmentType> targetConfigAndType;
    @NotNull
    private String path;

    /*
     * WARNING - void declaration
     */
    public ManualPathEntryDialog(@Nullable Project project, @NotNull Platform platform, @Nullable TargetEnvironmentConfiguration targetConfig) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        super(project);
        this.project = project;
        this.platform = platform;
        ManualPathEntryDialog manualPathEntryDialog = this;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = targetConfig;
        TargetEnvironmentType targetEnvironmentType = targetEnvironmentConfiguration != null ? TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)targetEnvironmentConfiguration) : null;
        BrowsableTargetEnvironmentType browsableTargetEnvironmentType = targetEnvironmentType instanceof BrowsableTargetEnvironmentType ? (BrowsableTargetEnvironmentType)targetEnvironmentType : null;
        if (browsableTargetEnvironmentType != null) {
            void it;
            BrowsableTargetEnvironmentType browsableTargetEnvironmentType2 = browsableTargetEnvironmentType;
            ManualPathEntryDialog manualPathEntryDialog2 = manualPathEntryDialog;
            boolean bl = false;
            pair = new Pair((Object)targetConfig, (Object)it);
            manualPathEntryDialog = manualPathEntryDialog2;
        } else {
            pair = null;
        }
        manualPathEntryDialog.targetConfigAndType = pair;
        this.path = "";
        this.setTitle(PyBundle.message("enter.path.dialog.title", new Object[0]));
        this.init();
    }

    public /* synthetic */ ManualPathEntryDialog(Project project, Platform platform, TargetEnvironmentConfiguration targetEnvironmentConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            platform = Platform.UNIX;
        }
        if ((n & 4) != 0) {
            targetEnvironmentConfiguration = null;
        }
        this(project, platform, targetEnvironmentConfiguration);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        String string = PyBundle.message("path.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"path.label\")");
        String label = string;
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(label, this){
            final /* synthetic */ String $label;
            final /* synthetic */ ManualPathEntryDialog this$0;
            {
                this.$label = $label;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.row(this.$label, (Function1)new Function1<Row, Unit>(this.this$0, this.$label){
                    final /* synthetic */ ManualPathEntryDialog this$0;
                    final /* synthetic */ String $label;
                    {
                        this.this$0 = $receiver;
                        this.$label = $label;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Cell cell;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        if (ManualPathEntryDialog.access$getTargetConfigAndType$p(this.this$0) == null) {
                            cell = TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                                @Nullable
                                public Object get() {
                                    return ((ManualPathEntryDialog)((Object)this.receiver)).getPath();
                                }

                                public void set(@Nullable Object value) {
                                    ManualPathEntryDialog.access$setPath$p((ManualPathEntryDialog)((Object)this.receiver), (String)value);
                                }
                            }));
                        } else {
                            BrowsableTargetEnvironmentType browsableTargetEnvironmentType = (BrowsableTargetEnvironmentType)ManualPathEntryDialog.access$getTargetConfigAndType$p(this.this$0).getSecond();
                            Supplier<TargetEnvironmentConfiguration> supplier = () -> createCenterPanel.1.invoke$lambda$0(this.this$0);
                            Project project = ManualPathEntryDialog.access$getProject$p(this.this$0);
                            Intrinsics.checkNotNull((Object)project);
                            cell = TargetUIUtil.textFieldWithBrowseTargetButton((Row)$this$row, (BrowsableTargetEnvironmentType)browsableTargetEnvironmentType, supplier, (Project)project, (String)this.$label, (MutableProperty)MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                                @Nullable
                                public Object get() {
                                    return ((ManualPathEntryDialog)((Object)this.receiver)).getPath();
                                }

                                public void set(@Nullable Object value) {
                                    ManualPathEntryDialog.access$setPath$p((ManualPathEntryDialog)((Object)this.receiver), (String)value);
                                }
                            })), (TargetBrowserHints)new TargetBrowserHints(true, null, 2, null));
                        }
                        Cell textFieldComponent2 = cell;
                        textFieldComponent2.validationOnApply((Function2)new Function2<ValidationInfoBuilder, ?, ValidationInfo>(this.this$0){
                            final /* synthetic */ ManualPathEntryDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull Object textField) {
                                ValidationInfo validationInfo;
                                Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
                                String text = ((TextAccessor)textField).getText();
                                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                                if (StringsKt.isBlank((CharSequence)text)) {
                                    String string = PyBundle.message("path.must.not.be.empty.error.message", new Object[0]);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"path.must.not.be.empty.error.message\")");
                                    validationInfo = $this$validationOnApply.error(string);
                                } else if (!ManualPathEntryDialog.Companion.isAbsolutePath(text, ManualPathEntryDialog.access$getPlatform$p(this.this$0))) {
                                    String string = PyBundle.message("path.must.be.absolute.error.message", new Object[0]);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"path.must.be.absolute.error.message\")");
                                    validationInfo = $this$validationOnApply.error(string);
                                } else if (StringsKt.endsWith$default((String)text, (String)" ", (boolean)false, (int)2, null)) {
                                    String string = PyBundle.message("path.ends.with.whitespace.warning.message", new Object[0]);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"path.ends.with.\u2026tespace.warning.message\")");
                                    validationInfo = $this$validationOnApply.warning(string);
                                } else {
                                    validationInfo = null;
                                }
                                return validationInfo;
                            }
                        }).focused();
                    }

                    private static final TargetEnvironmentConfiguration invoke$lambda$0(ManualPathEntryDialog this$0) {
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        return (TargetEnvironmentConfiguration)ManualPathEntryDialog.access$getTargetConfigAndType$p(this$0).getFirst();
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ Pair access$getTargetConfigAndType$p(ManualPathEntryDialog $this) {
        return $this.targetConfigAndType;
    }

    public static final /* synthetic */ void access$setPath$p(ManualPathEntryDialog $this, String string) {
        $this.path = string;
    }

    public static final /* synthetic */ Project access$getProject$p(ManualPathEntryDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ Platform access$getPlatform$p(ManualPathEntryDialog $this) {
        return $this.platform;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/ui/targetPathEditor/ManualPathEntryDialog$Companion;", "", "()V", "isAbsolutePath", "", "path", "", "platform", "Lcom/intellij/execution/Platform;", "isAbsoluteWindowsPath", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAbsolutePath(@NotNull String path2, @NotNull Platform platform) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            return switch (WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
                case 1 -> StringsKt.startsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null);
                case 2 -> this.isAbsoluteWindowsPath(path2);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final boolean isAbsoluteWindowsPath(String path2) {
            return OSAgnosticPathUtil.isAbsoluteDosPath((String)path2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Platform.values().length];
                try {
                    nArray[Platform.UNIX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Platform.WINDOWS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

