/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PoetryOutdatedVersion;
import com.jetbrains.python.sdk.poetry.PyPoetryPackageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "PoetryFileVisitor", "intellij.python.community.impl"})
public final class PoetryPackageVersionsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new PoetryFileVisitor(holder, session);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection$PoetryFileVisitor;", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "guessModule", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "visitFile", "", "file", "Lcom/intellij/psi/PsiFile;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPoetryPackageVersionsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoetryPackageVersionsInspection.kt\ncom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection$PoetryFileVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1#2:57\n1#2:74\n3792#3:58\n4307#3,2:59\n11653#3,9:64\n13579#3:73\n13580#3:75\n11662#3:76\n1360#4:61\n1446#4,2:62\n1448#4,3:77\n1855#4,2:80\n*S KotlinDebug\n*F\n+ 1 PoetryPackageVersionsInspection.kt\ncom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection$PoetryFileVisitor\n*L\n42#1:74\n39#1:58\n39#1:59,2\n42#1:64,9\n42#1:73\n42#1:75\n42#1:76\n41#1:61\n41#1:62,2\n41#1:77,3\n43#1:80,2\n*E\n"})
    public static final class PoetryFileVisitor
    extends PsiElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public PoetryFileVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        private final Module guessModule(PsiElement element) {
            Object object = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (object == null) {
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                Module[] it = ModuleManager.Companion.getInstance(project).getModules();
                boolean bl = false;
                object = it.length != 1 ? null : it[0];
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        public void visitFile(@NotNull PsiFile file) {
            void $this$forEach$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Module module = this.guessModule((PsiElement)file);
            if (module == null) {
                return;
            }
            Module module2 = module;
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(module2);
            if (sdk2 == null) {
                return;
            }
            Sdk sdk3 = sdk2;
            if (!PoetryKt.isPoetry(sdk3)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)file.getVirtualFile(), (Object)PoetryKt.getPyProjectToml(module2))) {
                return;
            }
            PsiElement[] psiElementArray = file.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"file.children");
            Object[] objectArray = psiElementArray;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                TomlTable tomlTable;
                PsiElement element = (PsiElement)element$iv$iv;
                boolean bl = false;
                Object[] objectArray2 = new String[]{"tool.poetry.dependencies", "tool.poetry.dev-dependencies"};
                if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray2), (tomlTable = element instanceof TomlTable ? (TomlTable)element : null) != null && (tomlTable = tomlTable.getHeader()) != null && (tomlTable = tomlTable.getKey()) != null ? tomlTable.getText() : null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl = false;
                PsiElement[] psiElementArray2 = it.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"it.children");
                Object[] $this$mapNotNull$iv = psiElementArray2;
                boolean $i$f$mapNotNull = false;
                Object[] objectArray3 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    TomlKeyValue it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl2 = false;
                    PsiElement line2 = (PsiElement)element$iv$iv2;
                    boolean bl3 = false;
                    if ((line2 instanceof TomlKeyValue ? (TomlKeyValue)line2 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String message;
                PoetryOutdatedVersion outdatedVersion;
                PoetryOutdatedVersion poetryOutdatedVersion;
                PyPoetryPackageManager bl;
                TomlKeyValue keyValue = (TomlKeyValue)element$iv;
                boolean bl5 = false;
                String packageName = keyValue.getKey().getText();
                PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk3);
                PyPoetryPackageManager pyPoetryPackageManager = bl = pyPackageManager instanceof PyPoetryPackageManager ? (PyPoetryPackageManager)pyPackageManager : null;
                if (bl != null) {
                    PyPoetryPackageManager it = bl;
                    boolean bl6 = false;
                    poetryOutdatedVersion = it.getOutdatedPackages().get(packageName);
                } else {
                    poetryOutdatedVersion = null;
                }
                if ((outdatedVersion = poetryOutdatedVersion) == null) continue;
                Object[] objectArray4 = new Object[]{packageName, outdatedVersion.getCurrentVersion(), outdatedVersion.getLatestVersion()};
                Intrinsics.checkNotNullExpressionValue((Object)PyBundle.message("python.sdk.inspection.message.version.outdated.latest", objectArray4), (String)"message(\"python.sdk.insp\u2026tedVersion.latestVersion)");
                this.holder.registerProblem((PsiElement)keyValue, message, ProblemHighlightType.WARNING, new LocalQuickFix[0]);
            }
        }
    }
}

