/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors.conda;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.readableFs.PathInfo;
import com.intellij.execution.target.readableFs.TargetConfigurationReadableFs;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.target.PathValidatorKt;
import com.jetbrains.python.sdk.add.target.ValidationRequest;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.PyCondaFlavorData;
import icons.PythonIcons;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public final class CondaEnvSdkFlavor
extends CPythonSdkFlavor<PyCondaFlavorData> {
    private CondaEnvSdkFlavor() {
    }

    public static CondaEnvSdkFlavor getInstance() {
        return (CondaEnvSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(CondaEnvSdkFlavor.class);
    }

    @Override
    public boolean providePyCharmHosted() {
        return false;
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    public boolean supportsEmptyData() {
        return false;
    }

    @Override
    @NotNull
    public Class<PyCondaFlavorData> getFlavorDataClass() {
        return PyCondaFlavorData.class;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        List<Path> list = Collections.emptyList();
        if (list == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public boolean sdkSeemsValid(@NotNull Sdk sdk2, @NotNull PyCondaFlavorData flavorData, @Nullable TargetEnvironmentConfiguration targetConfig) {
        if (sdk2 == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(1);
        }
        if (flavorData == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(2);
        }
        String condaPath = flavorData.getEnv().getFullCondaPathOnTarget();
        return CondaEnvSdkFlavor.isFileExecutable(condaPath, targetConfig);
    }

    @Override
    @NotNull
    public String getUniqueId() {
        return "Conda";
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(3);
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        return PythonSdkUtil.isConda(file.getPath());
    }

    @Nullable
    public static File getCondaEnvRoot(@NotNull String binaryPath) {
        File binary;
        File parent;
        if (binaryPath == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(4);
        }
        if ((parent = (binary = new File(binaryPath)).getParentFile()) == null) {
            return null;
        }
        File parent2 = parent.getParentFile();
        if (parent2 == null) {
            return null;
        }
        File parent3 = parent2.getParentFile();
        if (parent3 != null && "envs".equals(parent3.getName())) {
            return parent2;
        }
        if ("envs".equals(parent2.getName())) {
            return parent;
        }
        return null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Anaconda;
        if (icon == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Deprecated
    public static ValidationInfo validateCondaPath(@Nullable @SystemDependent String condaExecutable) {
        return CondaEnvSdkFlavor.validateCondaPath(condaExecutable, PathInfo.Companion.getLocalPathInfoProvider());
    }

    @Nullable
    public static ValidationInfo validateCondaPath(@Nullable @SystemDependent String condaExecutable, @Nullable TargetConfigurationReadableFs pathInfoProvider) {
        return PathValidatorKt.validateExecutableFile(new ValidationRequest(condaExecutable, PyBundle.message("python.add.sdk.conda.executable.path.is.empty", new Object[0]), pathInfoProvider, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/conda/CondaEnvSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/conda/CondaEnvSdkFlavor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sdkSeemsValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCondaEnvRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

