/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnixPythonSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    private static final Pattern PYTHON_3_RE = Pattern.compile("(python-?3\\.(\\d){1,2})|(python-?3)");
    private static final String[] NAMES = new String[]{"jython", "pypy"};

    private UnixPythonSdkFlavor() {
    }

    public static UnixPythonSdkFlavor getInstance() {
        return (UnixPythonSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(UnixPythonSdkFlavor.class);
    }

    @Override
    public boolean isApplicable() {
        return SystemInfo.isUnix && !SystemInfo.isMac;
    }

    @Override
    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        List list = ContainerUtil.map(UnixPythonSdkFlavor.getDefaultUnixPythons(null), x$0 -> Path.of(x$0, new String[0]));
        if (list == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static Set<String> getDefaultUnixPythons(@Nullable String rootPrefix) {
        HashSet<String> candidates = new HashSet<String>();
        UnixPythonSdkFlavor.collectUnixPythons((rootPrefix != null ? rootPrefix : "") + "/usr/bin", candidates);
        HashSet<String> hashSet = candidates;
        if (hashSet == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static void collectUnixPythons(String path2, Set<? super String> candidates) {
        VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(path2);
        if (rootDir != null) {
            VirtualFile[] suspects;
            if (rootDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootDir).markDirty();
            }
            rootDir.refresh(true, false);
            for (VirtualFile child : suspects = rootDir.getChildren()) {
                String childName;
                if (child.isDirectory() || !ArrayUtil.contains((String)(childName = StringUtil.toLowerCase((String)child.getName())), (String[])NAMES) && !PYTHON_3_RE.matcher(childName).matches()) continue;
                candidates.add(child.getPath());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/sdk/flavors/UnixPythonSdkFlavor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixPythons";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

