/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.EvictingQueue;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.readableFs.PathInfo;
import com.intellij.execution.target.readableFs.TargetConfigurationReadableFs;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.sdk.PyRemoteSdkAdditionalDataMarker;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonFlavorProvider;
import icons.PythonSdkIcons;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonSdkFlavor<D extends PyFlavorData> {
    public static final ExtensionPointName<PythonSdkFlavor<?>> EP_NAME = ExtensionPointName.create((String)"Pythonid.pythonSdkFlavor");
    private static final Collection<String> ourBuffer = Collections.synchronizedCollection(EvictingQueue.create((int)10));
    private static final Pattern VERSION_RE = Pattern.compile("(Python \\S+).*");
    private static final Logger LOG = Logger.getInstance(PythonSdkFlavor.class);

    public boolean providePyCharmHosted() {
        return true;
    }

    @NotNull
    public Class<D> getFlavorDataClass() {
        return this.getEmptyFlavorForBackwardCompatibility();
    }

    @NotNull
    private Class<D> getEmptyFlavorForBackwardCompatibility() {
        LOG.warn("getFlavorDataClass is not implemented, please implement it");
        return PyFlavorData.Empty.class;
    }

    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        List list = ContainerUtil.map(this.suggestHomePaths(module, context), x$0 -> Path.of(x$0, new String[0]));
        if (list == null) {
            PythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Deprecated
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        return Collections.emptyList();
    }

    public boolean isApplicable() {
        return false;
    }

    public boolean isPlatformIndependent() {
        return false;
    }

    @Nullable
    public String envPathParam() {
        return null;
    }

    public boolean supportsEmptyData() {
        return true;
    }

    public boolean sdkSeemsValid(@NotNull Sdk sdk2, @NotNull D flavorData, @Nullable TargetEnvironmentConfiguration targetConfig) {
        String path2;
        if (sdk2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(1);
        }
        if (flavorData == null) {
            PythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if ((path2 = sdk2.getHomePath()) == null) {
            LOG.warn("Sdk doesn't have homepath:" + sdk2.getName());
            return false;
        }
        return PythonSdkFlavor.isFileExecutable(path2, targetConfig);
    }

    protected static boolean isFileExecutable(@NotNull String fullPath, @Nullable TargetEnvironmentConfiguration targetEnvConfig) {
        boolean executable;
        if (fullPath == null) {
            PythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if (!(executable = PythonSdkFlavor.isFileExecutableImpl(fullPath, targetEnvConfig)) && !ourBuffer.contains(fullPath)) {
            ourBuffer.add(fullPath);
            Logger.getInstance(PythonSdkFlavor.class).warn(String.format("%s is not executable", fullPath));
        }
        return executable;
    }

    private static boolean isFileExecutableImpl(@NotNull String fullPath, @Nullable TargetEnvironmentConfiguration targetEnvConfig) {
        if (fullPath == null) {
            PythonSdkFlavor.$$$reportNull$$$0(4);
        }
        if (targetEnvConfig == null) {
            return Files.isExecutable(Path.of(fullPath, new String[0]));
        }
        if (targetEnvConfig instanceof TargetConfigurationReadableFs) {
            PathInfo fileInfo = ((TargetConfigurationReadableFs)targetEnvConfig).getPathInfo(fullPath);
            if (fileInfo instanceof PathInfo.Unknown) {
                return true;
            }
            return fileInfo instanceof PathInfo.RegularFile && ((PathInfo.RegularFile)fileInfo).getExecutable();
        }
        return true;
    }

    @NotNull
    public static List<PythonSdkFlavor<?>> getApplicableFlavors() {
        return PythonSdkFlavor.getApplicableFlavors(true);
    }

    @NotNull
    public static List<PythonSdkFlavor<?>> getApplicableFlavors(boolean addPlatformIndependent) {
        ArrayList result2 = new ArrayList();
        for (PythonSdkFlavor flavor : EP_NAME.getExtensionList()) {
            if (!flavor.isApplicable() && (!addPlatformIndependent || !flavor.isPlatformIndependent())) continue;
            result2.add(flavor);
        }
        result2.addAll(PythonSdkFlavor.getPlatformFlavorsFromExtensions(addPlatformIndependent));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            PythonSdkFlavor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static List<PythonSdkFlavor<?>> getPlatformFlavorsFromExtensions(boolean isIndependent) {
        ArrayList result2 = new ArrayList();
        for (PythonFlavorProvider provider : PythonFlavorProvider.EP_NAME.getExtensionList()) {
            PythonSdkFlavor flavor = provider.getFlavor(isIndependent);
            if (flavor == null) continue;
            result2.add(flavor);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            PythonSdkFlavor.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static List<PythonSdkFlavor<?>> getPlatformIndependentFlavors() {
        ArrayList result2 = new ArrayList();
        for (PythonSdkFlavor flavor : EP_NAME.getExtensionList()) {
            if (!flavor.isPlatformIndependent()) continue;
            result2.add(flavor);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            PythonSdkFlavor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static PythonSdkFlavor<?> getFlavor(@NotNull Sdk sdk2) {
        SdkAdditionalData data;
        if (sdk2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(8);
        }
        if ((data = sdk2.getSdkAdditionalData()) instanceof PythonSdkAdditionalData) {
            return ((PythonSdkAdditionalData)data).getFlavor();
        }
        if (data instanceof PyRemoteSdkAdditionalDataMarker) {
            return null;
        }
        return PythonSdkFlavor.getFlavor(sdk2.getHomePath());
    }

    @Deprecated
    @Nullable
    public static PythonSdkFlavor<?> getFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor<?> flavor : PythonSdkFlavor.getApplicableFlavors()) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static PythonSdkFlavor<?> getPlatformIndependentFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor<?> flavor : PythonSdkFlavor.getPlatformIndependentFlavors()) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        for (PythonSdkFlavor<?> flavor : PythonSdkFlavor.getPlatformFlavorsFromExtensions(true)) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    @Deprecated
    public boolean isValidSdkHome(@NotNull String path2) {
        File file;
        if (path2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(9);
        }
        return (file = new File(path2)).isFile() && this.isValidSdkPath(file);
    }

    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            PythonSdkFlavor.$$$reportNull$$$0(10);
        }
        return StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)file.getName())).contains("python");
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        if (sdkHome == null) {
            return null;
        }
        String runDirectory = new File(sdkHome).getParent();
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(runDirectory, new String[]{sdkHome, this.getVersionOption()}, 10000);
        return this.getVersionStringFromOutput(processOutput);
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull ProcessOutput processOutput) {
        if (processOutput == null) {
            PythonSdkFlavor.$$$reportNull$$$0(11);
        }
        if (processOutput.getExitCode() != 0) {
            String errors2 = processOutput.getStderr();
            if (StringUtil.isEmpty((String)errors2)) {
                errors2 = processOutput.getStdout();
            }
            LOG.warn("Couldn't get interpreter version: process exited with code " + processOutput.getExitCode() + "\n" + errors2);
            return null;
        }
        String result2 = this.getVersionStringFromOutput(processOutput.getStderr());
        if (result2 != null) {
            return result2;
        }
        return this.getVersionStringFromOutput(processOutput.getStdout());
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull String output2) {
        if (output2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(12);
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output2)), (Pattern)VERSION_RE);
    }

    @NotNull
    public String getVersionOption() {
        return "-V";
    }

    @NotNull
    public Collection<String> getExtraDebugOptions() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonSdkFlavor.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void initPythonPath(@NotNull GeneralCommandLine cmd, boolean passParentEnvs, @NotNull Collection<String> path2) {
        if (cmd == null) {
            PythonSdkFlavor.$$$reportNull$$$0(14);
        }
        if (path2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(15);
        }
        this.initPythonPath(path2, passParentEnvs, cmd.getEnvironment());
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public String getUniqueId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            PythonSdkFlavor.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(17);
        }
        LanguageLevel languageLevel = this.getLanguageLevelFromVersionString(sdk2.getVersionString());
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(18);
        }
        return languageLevel;
    }

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkFlavor.$$$reportNull$$$0(19);
        }
        LanguageLevel languageLevel = this.getLanguageLevelFromVersionString(this.getVersionString(sdkHome));
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(20);
        }
        return languageLevel;
    }

    @NotNull
    public LanguageLevel getLanguageLevelFromVersionString(@Nullable String version2) {
        String prefix = this.getName() + " ";
        if (version2 != null && version2.startsWith(prefix)) {
            LanguageLevel languageLevel = LanguageLevel.fromPythonVersion(version2.substring(prefix.length()));
            if (languageLevel == null) {
                PythonSdkFlavor.$$$reportNull$$$0(21);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(22);
        }
        return languageLevel;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = PythonSdkIcons.Python;
        if (icon == null) {
            PythonSdkFlavor.$$$reportNull$$$0(23);
        }
        return icon;
    }

    public void initPythonPath(@NotNull Collection<String> path2, boolean passParentEnvs, @NotNull Map<String, String> env) {
        if (path2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(24);
        }
        if (env == null) {
            PythonSdkFlavor.$$$reportNull$$$0(25);
        }
        PythonEnvUtil.initPythonPath(env, passParentEnvs, path2);
    }

    @Nullable
    public VirtualFile getSdkPath(@NotNull VirtualFile path2) {
        if (path2 == null) {
            PythonSdkFlavor.$$$reportNull$$$0(26);
        }
        return path2;
    }

    @Nullable
    public CommandLinePatcher commandLinePatcher() {
        return null;
    }

    public void dropCaches() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 8, 9, 10, 11, 12, 14, 15, 17, 19, 24, 25, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 1: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorData";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableFlavors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformFlavorsFromExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformIndependentFlavors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraDebugOptions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelFromVersionString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sdkSeemsValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFileExecutable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileExecutableImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFlavor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 8, 9, 10, 11, 12, 14, 15, 17, 19, 24, 25, 26 -> new IllegalArgumentException(string);
        };
    }

    public static final class UnknownFlavor
    extends PythonSdkFlavor<PyFlavorData.Empty> {
        public static final UnknownFlavor INSTANCE = new UnknownFlavor();

        private UnknownFlavor() {
        }

        @Override
        @NotNull
        public Class<PyFlavorData.Empty> getFlavorDataClass() {
            return PyFlavorData.Empty.class;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }
    }
}

