/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PySdkToInstallKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jf\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0007J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/sdk/configuration/PyProjectVirtualEnvConfiguration;", "", "()V", "createVirtualEnvSynchronously", "Lcom/intellij/openapi/projectRoots/Sdk;", "baseSdk", "existingSdks", "", "venvRoot", "", "projectBasePath", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "inheritSitePackages", "", "makeShared", "findPreferredVirtualEnvBaseSdk", "existingBaseSdks", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyProjectVirtualEnvConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyProjectVirtualEnvConfiguration.kt\ncom/jetbrains/python/sdk/configuration/PyProjectVirtualEnvConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class PyProjectVirtualEnvConfiguration {
    @NotNull
    public static final PyProjectVirtualEnvConfiguration INSTANCE = new PyProjectVirtualEnvConfiguration();

    private PyProjectVirtualEnvConfiguration() {
    }

    @RequiresEdt
    @Nullable
    public final Sdk createVirtualEnvSynchronously(@Nullable Sdk baseSdk, @NotNull List<? extends Sdk> existingSdks, @NotNull String venvRoot, @Nullable String projectBasePath, @Nullable Project project, @Nullable Module module, @NotNull UserDataHolder context, boolean inheritSitePackages, boolean makeShared) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)venvRoot, (String)"venvRoot");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Sdk installedSdk = PySdkToInstallKt.installSdkIfNeeded(baseSdk, module, existingSdks, context);
        if (installedSdk == null) {
            return null;
        }
        String string = projectBasePath;
        if (string == null) {
            Module module2 = module;
            string = module2 != null ? BasePySdkExtKt.getBasePath(module2) : null;
            if (string == null) {
                Project project2 = project;
                string = project2 != null ? project2.getBasePath() : null;
            }
        }
        String projectPath = string;
        String string2 = PySdkBundle.message("python.creating.venv.title", new Object[0]);
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(project, installedSdk, venvRoot, inheritSitePackages, string2){
            final /* synthetic */ Sdk $installedSdk;
            final /* synthetic */ String $venvRoot;
            final /* synthetic */ boolean $inheritSitePackages;
            {
                this.$installedSdk = $installedSdk;
                this.$venvRoot = $venvRoot;
                this.$inheritSitePackages = $inheritSitePackages;
                super($project, $super_call_param$1, false);
            }

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                Sdk sdk2;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                if (this.$installedSdk instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)this.$installedSdk))) {
                    Sdk sdk3 = ProjectJdkTable.getInstance().findJdk(this.$installedSdk.getName());
                    sdk2 = sdk3;
                    Intrinsics.checkNotNull((Object)sdk3);
                } else {
                    sdk2 = this.$installedSdk;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"if (installedSdk is Disp\u2026   installedSdk\n        }");
                Sdk sdk4 = sdk2;
                PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk4);
                Intrinsics.checkNotNullExpressionValue((Object)pyPackageManager, (String)"getInstance(sdk)");
                PyPackageManager packageManager = pyPackageManager;
                String string = packageManager.createVirtualEnv(this.$venvRoot, this.$inheritSitePackages);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageManager.createVir\u2026oot, inheritSitePackages)");
                return string;
            }
        };
        String associatedPath = !makeShared ? projectPath : null;
        Sdk sdk2 = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), existingSdks, installedSdk, associatedPath, null);
        if (sdk2 == null) {
            return null;
        }
        Sdk venvSdk = sdk2;
        if (!makeShared) {
            PySdkExtKt.associateWithModule(venvSdk, module, projectBasePath);
        }
        PySdkExtKt.excludeInnerVirtualEnv(project, venvSdk);
        PySdkSettings pySdkSettings = PySdkSettings.Companion.getInstance();
        String string3 = FileUtil.toSystemIndependentName((String)venvRoot);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(venvRoot)");
        pySdkSettings.onVirtualEnvCreated(installedSdk, string3, projectPath);
        return venvSdk;
    }

    public static /* synthetic */ Sdk createVirtualEnvSynchronously$default(PyProjectVirtualEnvConfiguration pyProjectVirtualEnvConfiguration, Sdk sdk2, List list, String string, String string2, Project project, Module module, UserDataHolder userDataHolder, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            userDataHolder = (UserDataHolder)new UserDataHolderBase();
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        return pyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously(sdk2, list, string, string2, project, module, userDataHolder, bl, bl2);
    }

    @Nullable
    public final Sdk findPreferredVirtualEnvBaseSdk(@NotNull List<? extends Sdk> existingBaseSdks) {
        Object v0;
        String preferredSdkPath;
        block2: {
            String string;
            Intrinsics.checkNotNullParameter(existingBaseSdks, (String)"existingBaseSdks");
            String p0 = string = PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBaseSdk();
            boolean bl = false;
            preferredSdkPath = FileUtil.exists((String)p0) ? string : null;
            Iterable iterable = existingBaseSdks;
            for (Object t : iterable) {
                Sdk it = (Sdk)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getHomePath(), (Object)preferredSdkPath)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Sdk detectedPreferredSdk = v0;
        Sdk sdk2 = detectedPreferredSdk;
        if (sdk2 == null) {
            sdk2 = preferredSdkPath != null ? (Sdk)new PyDetectedSdk(preferredSdkPath) : (Sdk)CollectionsKt.getOrNull(existingBaseSdks, (int)0);
        }
        return sdk2;
    }
}

