/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Output;
import com.intellij.execution.OutputListener;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.viewModel.extraction.ToolWindowContentExtractor;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PyRemoteSdkAdditionalDataMarker;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Obsolete
public class PythonTask {
    private static final long TIME_TO_WAIT_PROCESS_STOP = 2000L;
    private static final int TIMEOUT_TO_WAIT_FOR_TASK = 30000;
    @NotNull
    protected final Module myModule;
    @NotNull
    protected final Sdk mySdk;
    private String myWorkingDirectory;
    private String myRunnerScript;
    private HelperPackage myHelper;
    private List<String> myParameters;
    private final List<Integer> myPathParameterIndices;
    @NlsContexts.TabTitle
    private final String myRunTabTitle;
    private String myHelpId;
    private Runnable myAfterCompletion;

    public PythonTask(@NotNull Module module, @NlsContexts.TabTitle String runTabTitle) throws ExecutionException {
        if (module == null) {
            PythonTask.$$$reportNull$$$0(0);
        }
        this(module, runTabTitle, PythonTask.requirePythonSdk(module));
    }

    @NotNull
    protected static Sdk requirePythonSdk(@Nullable Module module) throws ExecutionException {
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
        if (sdk2 == null) {
            throw new ExecutionException(PyBundle.message("python.task.cannot.find.python.interpreter.for.selected.module", new Object[0]));
        }
        Sdk sdk3 = sdk2;
        if (sdk3 == null) {
            PythonTask.$$$reportNull$$$0(1);
        }
        return sdk3;
    }

    public PythonTask(@NotNull Module module, @NlsContexts.TabTitle String runTabTitle, @NotNull Sdk sdk2) {
        if (module == null) {
            PythonTask.$$$reportNull$$$0(2);
        }
        if (sdk2 == null) {
            PythonTask.$$$reportNull$$$0(3);
        }
        this.myHelper = null;
        this.myParameters = new ArrayList<String>();
        this.myPathParameterIndices = new ArrayList<Integer>();
        this.myModule = module;
        this.myRunTabTitle = runTabTitle;
        this.mySdk = sdk2;
    }

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public void setRunnerScript(String script) {
        this.myRunnerScript = script;
    }

    public void setHelper(HelperPackage helper) {
        this.myHelper = helper;
    }

    public final void addPathParameter(@NotNull Path path2) {
        if (path2 == null) {
            PythonTask.$$$reportNull$$$0(4);
        }
        this.myPathParameterIndices.add(this.myParameters.size());
        this.addParameter(path2.toString());
    }

    public final void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            PythonTask.$$$reportNull$$$0(5);
        }
        this.myParameters.add(parameter);
    }

    public void setParameters(List<String> parameters) {
        this.myParameters = parameters;
        this.myPathParameterIndices.clear();
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    public void setAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ProcessHandler createProcess(@Nullable Map<String, String> env) throws ExecutionException {
        GeneralCommandLine commandLine = this.createCommandLine();
        if (env != null) {
            commandLine.getEnvironment().putAll(env);
        }
        PydevConsoleRunnerUtil.setCorrectStdOutEncoding(commandLine);
        SdkAdditionalData additionalData = this.mySdk.getSdkAdditionalData();
        if (!(additionalData instanceof PyRemoteSdkAdditionalDataMarker)) return PythonTask.executeLegacyLocalProcess(commandLine);
        if (additionalData instanceof PyRemoteSdkAdditionalData) {
            return this.executeLegacyRemoteProcess(commandLine, (PyRemoteSdkAdditionalData)additionalData);
        }
        if (!(additionalData instanceof PyTargetAwareAdditionalData)) throw new IllegalArgumentException("Unknown additional data " + additionalData);
        return this.executeTargetBasedProcess((PyTargetAwareAdditionalData)additionalData);
    }

    @NotNull
    private ProcessHandler executeTargetBasedProcess(@NotNull PyTargetAwareAdditionalData data) throws ExecutionException {
        TargetEnvironmentRequest request;
        PythonScriptExecution execution;
        if (data == null) {
            PythonTask.$$$reportNull$$$0(6);
        }
        HelperPackage helper = this.myHelper;
        String script = this.myRunnerScript;
        assert (helper == null != (script == null)) : "Either script or helper must be set but not both";
        HashMap<Path, Function<TargetEnvironment, String>> uploadedPaths = new HashMap<Path, Function<TargetEnvironment, String>>();
        if (helper != null) {
            HelpersAwareTargetEnvironmentRequest helpersAwareRequest = PythonInterpreterTargetEnvironmentFactory.findPythonTargetInterpreter(this.mySdk, this.myModule.getProject());
            helpersAwareRequest.preparePyCharmHelpers();
            assert (helpersAwareRequest != null) : data.getClass() + " is not supported";
            execution = PythonScripts.prepareHelperScriptExecution(helper, helpersAwareRequest);
            request = helpersAwareRequest.getTargetEnvironmentRequest();
        } else {
            TargetEnvironmentConfiguration configuration = data.getTargetEnvironmentConfiguration();
            assert (configuration != null) : data.getClass() + " is not supported";
            request = configuration.createEnvironmentRequest(this.myModule.getProject());
            execution = new PythonScriptExecution();
            execution.setPythonScriptPath(TargetEnvironmentFunctions.constant((Object)script));
        }
        this.customizePythonExecution(request, execution, this.myModule);
        for (int i = 0; i < this.myParameters.size(); ++i) {
            String paramValue = this.myParameters.get(i);
            boolean isPath = this.myPathParameterIndices.contains(i);
            if (isPath) {
                execution.addParameter(PythonTask.addDirToUploadList(request, uploadedPaths, paramValue));
                continue;
            }
            execution.addParameter(paramValue);
        }
        String workDir = this.myWorkingDirectory;
        if (workDir != null) {
            execution.setWorkingDir(TargetEnvironmentFunctions.targetPath((Path)Path.of(workDir, new String[0])));
        }
        TargetEnvironment environment = request.prepareEnvironment(TargetProgressIndicator.EMPTY);
        this.setupPythonPath(request, execution);
        TargetedCommandLine commandLine = PythonScripts.buildTargetedCommandLine(execution, environment, this.mySdk, new ArrayList<String>());
        for (TargetEnvironment.UploadableVolume volume : environment.getUploadVolumes().values()) {
            try {
                volume.upload(".", TargetProgressIndicator.EMPTY);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        final Runnable downloadVolumesAfterProcess = () -> {
            environment.shutdown();
            for (Map.Entry localRemotePathMapping : uploadedPaths.entrySet()) {
                String targetPath = (String)((Function)localRemotePathMapping.getValue()).apply(environment);
                TargetEnvironment.DownloadRoot root = new TargetEnvironment.DownloadRoot((Path)localRemotePathMapping.getKey(), (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Persistent(targetPath));
                request.getDownloadVolumes().add(root);
            }
            try {
                TargetEnvironment newEnvironment = request.prepareEnvironment(TargetProgressIndicator.EMPTY);
                for (TargetEnvironment.DownloadableVolume volume : newEnvironment.getDownloadVolumes().values()) {
                    volume.download(".", (ProgressIndicator)new EmptyProgressIndicator());
                }
                newEnvironment.shutdown();
            }
            catch (ExecutionException | IOException ex) {
                throw new RuntimeException(ex);
            }
        };
        CapturingProcessHandler handler = new CapturingProcessHandler(environment.createProcess(commandLine, (ProgressIndicator)new EmptyProgressIndicator()), StandardCharsets.UTF_8, commandLine.getCommandPresentation(environment));
        handler.addProcessListener((ProcessListener)new OutputListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.getInstance().runProcessWithProgressSynchronously(downloadVolumesAfterProcess, "...", false, PythonTask.this.myModule.getProject());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/run/PythonTask$1", "processTerminated"));
            }
        });
        CapturingProcessHandler capturingProcessHandler = handler;
        if (capturingProcessHandler == null) {
            PythonTask.$$$reportNull$$$0(7);
        }
        return capturingProcessHandler;
    }

    protected void setupPythonPath(@NotNull TargetEnvironmentRequest request, @NotNull PythonExecution pythonExecution) {
        if (request == null) {
            PythonTask.$$$reportNull$$$0(8);
        }
        if (pythonExecution == null) {
            PythonTask.$$$reportNull$$$0(9);
        }
        PythonTask.setupPythonPath(this.myModule, this.mySdk, request, pythonExecution, true, true);
    }

    protected static void setupPythonPath(@NotNull Module module, @NotNull Sdk sdk2, @NotNull TargetEnvironmentRequest request, @NotNull PythonExecution pythonExecution, boolean addContent, boolean addSource) {
        if (module == null) {
            PythonTask.$$$reportNull$$$0(10);
        }
        if (sdk2 == null) {
            PythonTask.$$$reportNull$$$0(11);
        }
        if (request == null) {
            PythonTask.$$$reportNull$$$0(12);
        }
        if (pythonExecution == null) {
            PythonTask.$$$reportNull$$$0(13);
        }
        PythonCommandLineState.buildPythonPath(module.getProject(), module, pythonExecution, sdk2, null, false, addContent, addSource, false, request);
    }

    protected void customizePythonExecution(@NotNull TargetEnvironmentRequest request, @NotNull PythonExecution pythonExecution, @NotNull Module module) {
        if (request == null) {
            PythonTask.$$$reportNull$$$0(14);
        }
        if (pythonExecution == null) {
            PythonTask.$$$reportNull$$$0(15);
        }
        if (module == null) {
            PythonTask.$$$reportNull$$$0(16);
        }
    }

    @NotNull
    private static Function<TargetEnvironment, String> addDirToUploadList(@NotNull TargetEnvironmentRequest request, @NotNull @NotNull Map<@NotNull Path, @NotNull Function<TargetEnvironment, String>> uploadedPaths, @NotNull String dir) {
        if (request == null) {
            PythonTask.$$$reportNull$$$0(17);
        }
        if (uploadedPaths == null) {
            PythonTask.$$$reportNull$$$0(18);
        }
        if (dir == null) {
            PythonTask.$$$reportNull$$$0(19);
        }
        Path path2 = Path.of(dir, new String[0]);
        TargetEnvironment.UploadRoot uploadRoot = new TargetEnvironment.UploadRoot(path2, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(), true);
        Function pathFun = TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)uploadRoot);
        uploadedPaths.put(path2, pathFun);
        request.getUploadVolumes().add(uploadRoot);
        Function function = pathFun;
        if (function == null) {
            PythonTask.$$$reportNull$$$0(20);
        }
        return function;
    }

    @NotNull
    private static ProcessHandler executeLegacyLocalProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            PythonTask.$$$reportNull$$$0(21);
        }
        ProcessHandler handler = PythonProcessRunner.createProcessHandlingCtrlC(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)handler);
        ProcessHandler processHandler = handler;
        if (processHandler == null) {
            PythonTask.$$$reportNull$$$0(22);
        }
        return processHandler;
    }

    @NotNull
    private ProcessHandler executeLegacyRemoteProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkAdditionalData additionalData) throws ExecutionException {
        if (commandLine == null) {
            PythonTask.$$$reportNull$$$0(23);
        }
        if (additionalData == null) {
            PythonTask.$$$reportNull$$$0(24);
        }
        commandLine.putUserData(PyRemoteProcessStarter.RUN_AS_AUXILIARY_PROCESS, (Object)true);
        ProcessHandler processHandler = PyRemoteProcessStarter.startLegacyRemoteProcess(additionalData, commandLine, this.myModule.getProject(), null);
        if (processHandler == null) {
            PythonTask.$$$reportNull$$$0(25);
        }
        return processHandler;
    }

    public void run(@Nullable ConsoleView consoleView) throws ExecutionException {
        this.run(this.createCommandLine().getEnvironment(), consoleView);
    }

    public GeneralCommandLine createCommandLine() {
        String homePath2;
        GeneralCommandLine cmd = new GeneralCommandLine();
        if (this.myWorkingDirectory != null) {
            cmd.setWorkDirectory(this.myWorkingDirectory);
        }
        if ((homePath2 = this.mySdk.getHomePath()) != null) {
            homePath2 = FileUtil.toSystemDependentName((String)homePath2);
        }
        PythonCommandLineState.createStandardGroups(cmd);
        ParamsGroup scriptParams = cmd.getParametersList().getParamsGroup("Script");
        assert (scriptParams != null);
        Map env = cmd.getEnvironment();
        if (!SystemInfo.isWindows && !PythonSdkUtil.isRemote(this.mySdk)) {
            StringBuilder paramString;
            cmd.setExePath("bash");
            ParamsGroup bashParams = cmd.getParametersList().addParamsGroupAt(0, "Bash");
            bashParams.addParameter("-cl");
            NotNullFunction escaperFunction = StringUtil.escaper((boolean)false, (String)"|>$\"'& ");
            if (this.myHelper != null) {
                paramString = new StringBuilder((String)escaperFunction.fun((Object)homePath2) + " " + (String)escaperFunction.fun((Object)this.myHelper.asParamString()));
                this.myHelper.addToPythonPath(cmd.getEnvironment());
            } else {
                paramString = new StringBuilder((String)escaperFunction.fun((Object)homePath2) + " " + (String)escaperFunction.fun((Object)this.myRunnerScript));
            }
            for (String p : this.myParameters) {
                paramString.append(" ").append(p);
            }
            bashParams.addParameter(paramString.toString());
        } else {
            cmd.setExePath(homePath2);
            if (this.myHelper != null) {
                this.myHelper.addToGroup(scriptParams, cmd);
            } else {
                scriptParams.addParameter(this.myRunnerScript);
            }
            scriptParams.addParameters(ContainerUtil.filter(this.myParameters, o -> o != null));
        }
        PythonEnvUtil.setPythonUnbuffered(env);
        if (homePath2 != null) {
            PythonEnvUtil.resetHomePathChanges(homePath2, env);
        }
        List<String> pythonPath = this.setupPythonPath();
        PythonCommandLineState.initPythonPath(cmd, true, pythonPath, homePath2);
        return cmd;
    }

    protected List<String> setupPythonPath() {
        return this.setupPythonPath(true, true);
    }

    protected List<String> setupPythonPath(boolean addContent, boolean addSource) {
        ArrayList pythonPath = Lists.newArrayList(PythonCommandLineState.getAddedPaths(this.mySdk));
        pythonPath.addAll(PythonCommandLineState.collectPythonPath(this.myModule, addContent, addSource));
        return pythonPath;
    }

    public void run(@Nullable Map<String, String> env, @Nullable ConsoleView consoleView) throws ExecutionException {
        ProcessHandler process2 = this.createProcess(env);
        Project project = this.myModule.getProject();
        this.stopProcessWhenAppClosed(process2);
        process2.putUserData(ToolWindowContentExtractor.SYNC_TAB_TO_GUEST, (Object)true);
        new RunContentExecutor(project, process2).withFilter((Filter)new PythonTracebackFilter(project)).withConsole(consoleView).withTitle(this.myRunTabTitle).withRerun(() -> {
            try {
                process2.destroyProcess();
                if (process2.waitFor(2000L)) {
                    this.run(env, consoleView);
                } else {
                    Messages.showErrorDialog((String)PyBundle.message("unable.to.stop", new Object[0]), (String)this.myRunTabTitle);
                }
            }
            catch (ExecutionException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)this.myRunTabTitle);
            }
        }).withStop(() -> process2.destroyProcess(), () -> !process2.isProcessTerminated()).withAfterCompletion(this.myAfterCompletion).withHelpId(this.myHelpId).run();
    }

    private void stopProcessWhenAppClosed(final @NotNull ProcessHandler process2) {
        if (process2 == null) {
            PythonTask.$$$reportNull$$$0(26);
        }
        final Disposable disposable = Disposer.newDisposable();
        Disposable a = new Disposable(){

            public void dispose() {
                Disposer.dispose((Disposable)disposable);
            }
        };
        Disposable b = new Disposable(){

            public void dispose() {
                Disposer.dispose((Disposable)disposable);
            }
        };
        Disposer.register((Disposable)this.myModule, (Disposable)a);
        Disposer.register((Disposable)PythonPluginDisposable.getInstance(this.myModule.getProject()), (Disposable)b);
        Disposer.register((Disposable)disposable, (Disposable)a);
        Disposer.register((Disposable)disposable, (Disposable)b);
        process2.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)disposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/run/PythonTask$4", "processTerminated"));
            }
        }, disposable);
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                process2.destroyProcess();
            }
        });
    }

    @NotNull
    public final String runNoConsole() throws ExecutionException {
        Output output2;
        ProgressManager manager = ProgressManager.getInstance();
        if (SwingUtilities.isEventDispatchThread()) {
            assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "This method can't run under write action";
            output2 = (Output)manager.runProcessWithProgressSynchronously(() -> this.getOutputInternal(), this.myRunTabTitle, false, this.myModule.getProject());
        } else {
            output2 = this.getOutputInternal();
        }
        int exitCode = output2.getExitCode();
        if (exitCode == 0) {
            String string = output2.getStdout();
            if (string == null) {
                PythonTask.$$$reportNull$$$0(27);
            }
            return string;
        }
        throw new ExecutionException(PyBundle.message("dialog.message.error.on.python.side.exit.code.stderr.stdout", exitCode, output2.getStderr(), output2.getStdout()));
    }

    @NotNull
    private Output getOutputInternal() throws ExecutionException {
        assert (!SwingUtilities.isEventDispatchThread());
        ProcessHandler process2 = this.createProcess(new HashMap<String, String>());
        OutputListener listener2 = new OutputListener();
        process2.addProcessListener((ProcessListener)listener2);
        process2.startNotify();
        process2.waitFor(30000L);
        Output output2 = listener2.getOutput();
        if (output2 == null) {
            PythonTask.$$$reportNull$$$0(28);
        }
        return output2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 20, 22, 25, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 7: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonTask";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonExecution";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadedPaths";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requirePythonSdk";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "executeTargetBasedProcess";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addDirToUploadList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "executeLegacyLocalProcess";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "executeLegacyRemoteProcess";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "runNoConsole";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPathParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeTargetBasedProcess";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupPythonPath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "customizePythonExecution";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDirToUploadList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "executeLegacyLocalProcess";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "executeLegacyRemoteProcess";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "stopProcessWhenAppClosed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 20, 22, 25, 27, 28 -> new IllegalStateException(string);
        };
    }
}

