/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyPsiRefactoringUtil {
    public static <T extends PyElement> T addElementToStatementList(@NotNull T element, @NotNull PyStatementList statementList) {
        if (element == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (statementList == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(1);
        }
        PyStatement before = null;
        PyStatement after = null;
        for (PyStatement statement : statementList.getStatements()) {
            if (PyDependenciesComparator.depends(element, statement)) {
                after = statement;
                continue;
            }
            if (!PyDependenciesComparator.depends(statement, element)) continue;
            before = statement;
        }
        PsiElement result2 = after != null ? statementList.addAfter((PsiElement)element, (PsiElement)after) : (before != null ? statementList.addBefore((PsiElement)element, (PsiElement)before) : PyPsiRefactoringUtil.addElementToStatementList(element, statementList, true));
        PyElement resultCasted = (PyElement)result2;
        return (T)resultCasted;
    }

    @NotNull
    public static PsiElement addElementToStatementList(@NotNull PsiElement element, @NotNull PyStatementList statementList, boolean toTheBeginning) {
        PsiElement firstChild;
        PsiDocumentManager manager;
        Document document;
        PsiElement prevElem;
        if (element == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (statementList == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(3);
        }
        if ((prevElem = PyPsiUtils.getPrevNonWhitespaceSibling((PsiElement)statementList)) != null && PyUtil.onSameLine((PsiElement)statementList, prevElem) && (document = (manager = PsiDocumentManager.getInstance((Project)statementList.getProject())).getDocument(statementList.getContainingFile())) != null) {
            PyStatementListContainer container = (PyStatementListContainer)statementList.getParent();
            manager.doPostponedOperationsAndUnblockDocument(document);
            String indentation = "\n" + PyIndentUtil.getElementIndent((PsiElement)statementList);
            String text = statementList.getStatements().length == 0 ? indentation + "pass" : indentation;
            document.insertString(statementList.getTextRange().getStartOffset(), (CharSequence)text);
            manager.commitDocument(document);
            statementList = container.getStatementList();
        }
        if ((firstChild = statementList.getFirstChild()) == statementList.getLastChild() && firstChild instanceof PyPassStatement) {
            element = firstChild.replace(element);
        } else {
            PyStatement[] statements = statementList.getStatements();
            if (toTheBeginning && statements.length > 0) {
                PyExpression expression;
                PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)statementList, PyDocStringOwner.class);
                PyStatement anchor = statements[0];
                if (docStringOwner != null && anchor instanceof PyExpressionStatement && ((PyExpressionStatement)anchor).getExpression() == docStringOwner.getDocStringExpression()) {
                    PyStatement next = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, PyStatement.class);
                    if (next == null) {
                        PsiElement psiElement = statementList.addAfter(element, (PsiElement)anchor);
                        if (psiElement == null) {
                            PyPsiRefactoringUtil.$$$reportNull$$$0(4);
                        }
                        return psiElement;
                    }
                    anchor = next;
                }
                while (anchor instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)anchor).getExpression()) instanceof PyCallExpression) {
                    PyExpression callee = ((PyCallExpression)expression).getCallee();
                    if (!PyUtil.isSuperCall((PyCallExpression)expression) && (callee == null || !"__init__".equals(callee.getName()))) break;
                    PyStatement next = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, PyStatement.class);
                    if (next == null) {
                        PsiElement psiElement = statementList.addAfter(element, (PsiElement)anchor);
                        if (psiElement == null) {
                            PyPsiRefactoringUtil.$$$reportNull$$$0(5);
                        }
                        return psiElement;
                    }
                    anchor = next;
                }
                element = statementList.addBefore(element, (PsiElement)anchor);
            } else {
                element = statementList.add(element);
            }
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public static List<PyFunction> getAllSuperAbstractMethods(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.filter(PyPsiRefactoringUtil.getAllSuperMethods(cls, context), method -> PyPsiRefactoringUtil.isAbstractMethodForClass(method, cls, context));
        if (list == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean isAbstractMethodForClass(@NotNull PyFunction method, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        String methodName;
        if (method == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(10);
        }
        if (cls == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(12);
        }
        if ((methodName = method.getName()) == null || cls.findMethodByName(methodName, false, context) != null || cls.findClassAttribute(methodName, false, context) != null) {
            return false;
        }
        PyClass methodClass = method.getContainingClass();
        if (methodClass != null) {
            for (PyClass ancestor : cls.getAncestorClasses(context)) {
                if (ancestor.equals(methodClass)) break;
                if (ancestor.findClassAttribute(methodName, false, context) == null) continue;
                return false;
            }
        }
        return method.onlyRaisesNotImplementedError() || PyKnownDecoratorUtil.hasAbstractDecorator(method, context);
    }

    @NotNull
    public static List<PyFunction> getAllSuperMethods(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(14);
        }
        LinkedHashMap functions = Maps.newLinkedHashMap();
        for (PyClassLikeType type2 : pyClass.getAncestorTypes(context)) {
            if (type2 == null) continue;
            for (PyFunction function : PyTypeUtil.getMembersOfType(type2, PyFunction.class, false, context)) {
                String name2 = function.getName();
                if (name2 == null || functions.containsKey(name2) && (!PyiUtil.isOverload((PsiElement)functions.get(name2), context) || PyiUtil.isOverload(function, context))) continue;
                functions.put(name2, function);
            }
        }
        ArrayList arrayList = Lists.newArrayList(functions.values());
        if (arrayList == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public static boolean isValidQualifiedName(QualifiedName name2) {
        if (name2 == null) {
            return false;
        }
        List components = name2.getComponents();
        if (components.isEmpty()) {
            return false;
        }
        for (String s : components) {
            if (PyNames.isIdentifier(s) && !PyNames.isReserved(s)) continue;
            return false;
        }
        return true;
    }

    public static void insertImport(PsiElement anchor, Collection<? extends PsiNamedElement> elements) {
        for (PsiNamedElement psiNamedElement : elements) {
            PyPsiRefactoringUtil.insertImport(anchor, psiNamedElement);
        }
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element) {
        if (anchor == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(16);
        }
        if (element == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(17);
        }
        return PyPsiRefactoringUtil.insertImport(anchor, element, null);
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element, @Nullable String asName) {
        if (anchor == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(18);
        }
        if (element == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(19);
        }
        return PyPsiRefactoringUtil.insertImport(anchor, element, asName, PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT);
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element, @Nullable String asName, boolean preferFromImport) {
        String importedName;
        QualifiedName containingQName;
        boolean importingModuleOrPackage;
        PsiFile file;
        if (anchor == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (element == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(21);
        }
        if (PyBuiltinCache.getInstance((PsiElement)element).isBuiltin((PsiElement)element)) {
            return false;
        }
        Object elementSource = element instanceof PsiDirectory ? (PsiFileSystemItem)element : element.getContainingFile();
        if (elementSource == (file = anchor.getContainingFile()) || elementSource == file.getOriginalFile()) {
            return false;
        }
        QualifiedName qname = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, anchor);
        if (qname == null || !PyPsiRefactoringUtil.isValidQualifiedName(qname)) {
            return false;
        }
        boolean bl = importingModuleOrPackage = element instanceof PyFile || element instanceof PsiDirectory;
        if (importingModuleOrPackage) {
            containingQName = qname.removeLastComponent();
            importedName = qname.getLastComponent();
        } else if (PyUtil.isTopLevel((PsiElement)element) || element instanceof LightElement) {
            containingQName = qname;
            importedName = PyPsiRefactoringUtil.getOriginalName(element);
        } else {
            return false;
        }
        AddImportHelper.ImportPriority priority = AddImportHelper.getImportPriority(anchor, elementSource);
        if (preferFromImport && !containingQName.getComponents().isEmpty() || !importingModuleOrPackage) {
            return AddImportHelper.addOrUpdateFromImportStatement(file, containingQName.toString(), importedName, asName, priority, anchor);
        }
        return AddImportHelper.addImportStatement(file, containingQName.append(importedName).toString(), asName, priority, anchor);
    }

    @Nullable
    public static String getOriginalName(@NotNull PsiNamedElement element) {
        if (element == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (element instanceof PyFile) {
            VirtualFile virtualFile = PsiUtilBase.asVirtualFile((PsiElement)PyUtil.turnInitIntoDir((PsiElement)element));
            if (virtualFile != null) {
                return virtualFile.getNameWithoutExtension();
            }
            return null;
        }
        return element.getName();
    }

    @Nullable
    public static String getOriginalName(PyImportElement element) {
        QualifiedName qname = element.getImportedQName();
        if (qname != null && qname.getComponentCount() > 0) {
            return (String)qname.getComponents().get(0);
        }
        return null;
    }

    public static void addSuperClassExpressions(@NotNull Project project, @NotNull PyClass clazz, @Nullable Collection<String> paramExpressions, @Nullable Collection<Pair<String, String>> keywordArguments) {
        if (project == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(23);
        }
        if (clazz == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(24);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)clazz);
        PyArgumentList superClassExpressionList = clazz.getSuperClassExpressionList();
        boolean addExpression = false;
        if (superClassExpressionList == null) {
            superClassExpressionList = generator.createFromText(languageLevel, PyClass.class, "class foo():pass").getSuperClassExpressionList();
            assert (superClassExpressionList != null) : "expression not created";
            addExpression = true;
        }
        generator.createFromText(LanguageLevel.PYTHON34, PyClass.class, "class foo(object, metaclass=Foo): pass").getSuperClassExpressionList();
        if (paramExpressions != null) {
            for (String string : paramExpressions) {
                superClassExpressionList.addArgument(generator.createParameter(string));
            }
        }
        if (keywordArguments != null) {
            for (Pair pair : keywordArguments) {
                superClassExpressionList.addArgument(generator.createKeywordArgument(languageLevel, (String)pair.first, (String)pair.second));
            }
        }
        if (addExpression) {
            ASTNode classNameNode = clazz.getNameNode();
            PsiElement psiElement = classNameNode == null ? clazz.getFirstChild() : classNameNode.getPsi();
            clazz.addAfter((PsiElement)superClassExpressionList, psiElement);
        }
    }

    @Nullable
    public static PsiElement addClassAttributeIfNotExist(@NotNull PyClass aClass, @NotNull String attributeName, @NotNull String value) {
        if (aClass == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(25);
        }
        if (attributeName == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(26);
        }
        if (value == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(27);
        }
        if (aClass.findClassAttribute(attributeName, false, null) != null) {
            return null;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(aClass.getProject());
        String text = String.format("%s = %s", attributeName, value);
        LanguageLevel level = LanguageLevel.forElement((PsiElement)aClass);
        PyAssignmentStatement assignmentStatement = generator.createFromText(level, PyAssignmentStatement.class, text);
        return PyPsiRefactoringUtil.addElementToStatementList(assignmentStatement, aClass.getStatementList(), true);
    }

    public static boolean addMetaClassIfNotExist(@NotNull PyClass cls, @NotNull PyClass metaClass, @NotNull TypeEvalContext context) {
        String metaClassName;
        if (cls == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(28);
        }
        if (metaClass == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (context == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(30);
        }
        if ((metaClassName = metaClass.getName()) == null) {
            return false;
        }
        PyClassLikeType metaClassType = cls.getMetaClassType(false, context);
        if (metaClassType != null) {
            return false;
        }
        PyPsiRefactoringUtil.insertImport((PsiElement)cls, (PsiNamedElement)metaClass);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)cls);
        if (languageLevel.isPython2()) {
            PyPsiRefactoringUtil.addClassAttributeIfNotExist(cls, "__metaclass__", metaClassName);
        } else {
            List<Pair<String, String>> keywordArguments = Collections.singletonList(Pair.create((Object)"metaclass", (Object)metaClassName));
            PyPsiRefactoringUtil.addSuperClassExpressions(cls.getProject(), cls, null, keywordArguments);
        }
        return true;
    }

    public static void addSuperclasses(@NotNull Project project, @NotNull PyClass clazz, PyClass ... superClasses) {
        if (project == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(31);
        }
        if (clazz == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(32);
        }
        if (superClasses == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(33);
        }
        ArrayList<String> superClassNames = new ArrayList<String>();
        for (PyClass superClass : Collections2.filter(Arrays.asList(superClasses), NotNullPredicate.INSTANCE)) {
            if (superClass.getName() == null) continue;
            superClassNames.add(superClass.getName());
            PyPsiRefactoringUtil.insertImport((PsiElement)clazz, (PsiNamedElement)superClass);
        }
        PyPsiRefactoringUtil.addSuperClassExpressions(project, clazz, superClassNames, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementList";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyPsiRefactoringUtil";
                break;
            }
            case 7: 
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyPsiRefactoringUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addElementToStatementList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSuperAbstractMethods";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSuperMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElementToStatementList";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllSuperAbstractMethods";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractMethodForClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllSuperMethods";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertImport";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addSuperClassExpressions";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addClassAttributeIfNotExist";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addMetaClassIfNotExist";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addSuperclasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9, 15 -> new IllegalStateException(string);
        };
    }
}

