/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyStringLiteralUtil
extends PyStringLiteralCoreUtil {
    private static final Logger LOG = Logger.getInstance(PyStringLiteralUtil.class);

    private PyStringLiteralUtil() {
    }

    @NotNull
    public static String getStringValue(@NotNull String s) {
        if (s == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(0);
        }
        String string = PyStringLiteralUtil.getStringValueTextRange(s).substring(s);
        if (string == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static TextRange getStringValueTextRange(@NotNull String s) {
        Pair<String, String> quotes;
        if (s == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(2);
        }
        if ((quotes = PyStringLiteralUtil.getQuotes(s)) != null) {
            return TextRange.create((int)((String)quotes.getFirst()).length(), (int)(s.length() - ((String)quotes.getSecond()).length()));
        }
        return TextRange.allOf((String)s);
    }

    public static boolean isStringLiteralToken(@NotNull String text) {
        if (text == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(3);
        }
        PythonLexer lexer = new PythonLexer();
        lexer.start(text);
        return PyTokenTypes.STRING_NODES.contains(lexer.getTokenType()) && lexer.getTokenEnd() == lexer.getBufferEnd() || PyTokenTypes.FSTRING_START == lexer.getTokenType();
    }

    @NotNull
    public static TextRange getContentRange(@NotNull String text) {
        if (text == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(PyStringLiteralUtil.isStringLiteralToken(text), (Object)"Text of a single string literal node expected");
        int startOffset = PyStringLiteralUtil.getPrefixLength(text);
        int delimiterLength = 1;
        String afterPrefix = text.substring(startOffset);
        if (afterPrefix.startsWith("\"\"\"") || afterPrefix.startsWith("'''")) {
            delimiterLength = 3;
        }
        String delimiter = text.substring(startOffset, startOffset + delimiterLength);
        int endOffset = text.length();
        if (text.substring(startOffset += delimiterLength).endsWith(delimiter)) {
            endOffset -= delimiterLength;
        }
        return new TextRange(startOffset, endOffset);
    }

    public static int getPrefixLength(@NotNull String text) {
        if (text == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(5);
        }
        return PyStringLiteralUtil.getPrefixEndOffset(text, 0);
    }

    public static boolean isUnicodePrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(6);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'u', (int)0) >= 0;
    }

    public static boolean isBytesPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(7);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'b', (int)0) >= 0;
    }

    public static boolean isRawPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(8);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'r', (int)0) >= 0;
    }

    public static boolean isFormattedPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PyStringLiteralUtil.$$$reportNull$$$0(9);
        }
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'f', (int)0) >= 0;
    }

    public static char flipQuote(char quote) {
        return quote == '\"' ? (char)'\'' : '\"';
    }

    public static TextRange getTextRange(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            List<TextRange> ranges = ((PyStringLiteralExpression)element).getStringValueTextRanges();
            return ranges.get(0);
        }
        return new TextRange(0, element.getTextLength());
    }

    @Nullable
    public static String getText(@Nullable PyExpression ex) {
        if (ex == null) {
            return null;
        }
        return ex.getText();
    }

    @Nullable
    public static String getStringValue(@Nullable PsiElement o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression literalExpression = (PyStringLiteralExpression)o;
            return literalExpression.getStringValue();
        }
        return o.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyStringLiteralUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyStringLiteralUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueTextRange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralToken";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContentRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixLength";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnicodePrefix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBytesPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRawPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFormattedPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

