/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.projectView;

import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.projectView.PyFileNode;
import com.jetbrains.python.projectView.PyRemoteLibrariesNode;
import com.jetbrains.python.projectView.PySkeletonsNode;
import com.jetbrains.python.projectView.PyTypeShedNode;
import com.jetbrains.python.projectView.PyUserSkeletonsNode;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTreeStructureProvider
implements SelectableTreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
        if (parent == null) {
            PyTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children2 == null) {
            PyTreeStructureProvider.$$$reportNull$$$0(1);
        }
        Project project = parent.getProject();
        Sdk sdk2 = PyTreeStructureProvider.getPythonSdk(parent);
        if (sdk2 != null && project != null) {
            PyTypeShedNode typeShedNode;
            PyRemoteLibrariesNode remoteLibrariesNode;
            PyUserSkeletonsNode userSkeletonsNode;
            Collection<AbstractTreeNode<?>> newChildren = PyTreeStructureProvider.hideSkeletons(children2);
            PySkeletonsNode skeletonsNode = PySkeletonsNode.create(project, sdk2, settings);
            if (skeletonsNode != null) {
                newChildren.add((AbstractTreeNode<?>)skeletonsNode);
            }
            if ((userSkeletonsNode = PyUserSkeletonsNode.create(project, settings)) != null) {
                newChildren.add((AbstractTreeNode<?>)userSkeletonsNode);
            }
            if ((remoteLibrariesNode = PyRemoteLibrariesNode.create(project, sdk2, settings)) != null) {
                newChildren.add((AbstractTreeNode<?>)remoteLibrariesNode);
            }
            if ((typeShedNode = PyTypeShedNode.Companion.create(project, sdk2, settings)) != null) {
                newChildren.add((AbstractTreeNode<?>)typeShedNode);
            }
            Collection<AbstractTreeNode<?>> collection = newChildren;
            if (collection == null) {
                PyTreeStructureProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (settings != null && settings.isShowMembers()) {
            ArrayList newChildren = new ArrayList();
            for (AbstractTreeNode<?> child : children2) {
                PsiFile f;
                if (child instanceof PsiFileNode && (f = (PsiFile)((PsiFileNode)child).getValue()) instanceof PyFile) {
                    newChildren.add((AbstractTreeNode<?>)new PyFileNode(project, f, settings));
                    continue;
                }
                newChildren.add(child);
            }
            ArrayList arrayList = newChildren;
            if (arrayList == null) {
                PyTreeStructureProvider.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        Collection<AbstractTreeNode<?>> collection = children2;
        if (collection == null) {
            PyTreeStructureProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    private static Sdk getPythonSdk(@NotNull AbstractTreeNode node) {
        LibraryOrSdkOrderEntry entry;
        NamedLibraryElement value;
        if (node == null) {
            PyTreeStructureProvider.$$$reportNull$$$0(5);
        }
        if (node instanceof NamedLibraryElementNode && (value = (NamedLibraryElement)((NamedLibraryElementNode)node).getValue()) != null && (entry = value.getOrderEntry()) instanceof JdkOrderEntry) {
            SdkTypeId type2;
            Sdk sdk2 = ((JdkOrderEntry)entry).getJdk();
            SdkTypeId sdkTypeId = type2 = sdk2 == null ? null : sdk2.getSdkType();
            if (type2 instanceof PythonSdkType) {
                return sdk2;
            }
        }
        return null;
    }

    @NotNull
    private static Collection<AbstractTreeNode<?>> hideSkeletons(@NotNull Collection<AbstractTreeNode<?>> children2) {
        if (children2 == null) {
            PyTreeStructureProvider.$$$reportNull$$$0(6);
        }
        ArrayList newChildren = new ArrayList();
        for (AbstractTreeNode<?> child : children2) {
            if (child instanceof PsiDirectoryNode) {
                VirtualFile grandParent;
                VirtualFile dirParent;
                VirtualFile dir;
                PsiDirectory directory2 = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                if (directory2 == null || (dir = directory2.getVirtualFile()).equals(PyUserSkeletonsUtil.getUserSkeletonsDirectory())) continue;
                if (dir.getFileSystem() instanceof JarFileSystem) {
                    dir = ((JarFileSystem)dir.getFileSystem()).getLocalByEntry(dir);
                }
                if (dir == null || PyTypeShed.INSTANCE.isInside(dir) || (dirParent = dir.getParent()) != null && dirParent.getName().equals("python_stubs") || dirParent != null && dirParent.getName().equals("remote_sources") || dirParent != null && (grandParent = dirParent.getParent()) != null && grandParent.getName().equals("remote_sources")) continue;
            }
            newChildren.add(child);
        }
        ArrayList arrayList = newChildren;
        if (arrayList == null) {
            PyTreeStructureProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public PsiElement getTopLevelElement(PsiElement element) {
        PyPsiUtils.assertValid(element);
        Ref containingFileRef = Ref.create();
        ApplicationManager.getApplication().runReadAction(() -> containingFileRef.set((Object)element.getContainingFile()));
        PsiFile containingFile = (PsiFile)containingFileRef.get();
        if (!(containingFile instanceof PyFile)) {
            return null;
        }
        ArrayList<PyDocStringOwner> parents2 = new ArrayList<PyDocStringOwner>();
        PyDocStringOwner container = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class);
        while (container != null && !(container instanceof PyFile)) {
            parents2.add(0, container);
            container = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PyDocStringOwner.class);
        }
        for (PsiElement psiElement : parents2) {
            if (!(psiElement instanceof PyFunction)) continue;
            return psiElement;
        }
        if (parents2.size() > 0) {
            return (PsiElement)parents2.get(parents2.size() - 1);
        }
        return element.getContainingFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/projectView/PyTreeStructureProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/projectView/PyTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "hideSkeletons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPythonSdk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hideSkeletons";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

