/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.python.packaging.bridge.PythonPackageManagementServiceBridge;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerProvider;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/packaging/common/PackageManagerHolder;", "Lcom/intellij/openapi/Disposable;", "()V", "bridgeCache", "", "Ljava/util/UUID;", "Lcom/jetbrains/python/packaging/bridge/PythonPackageManagementServiceBridge;", "cache", "Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "bridgeForSdk", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "dispose", "", "forSdk", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/jetbrains/python/packaging/common/PackageManagerHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class PackageManagerHolder
implements Disposable {
    @NotNull
    private final Map<UUID, PythonPackageManager> cache = new LinkedHashMap();
    @NotNull
    private final Map<UUID, PythonPackageManagementServiceBridge> bridgeCache = new LinkedHashMap();

    @NotNull
    public final PythonPackageManager forSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        PythonPackageManager pythonPackageManager;
        PythonPackageManager manager;
        UUID cacheKey;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
            Intrinsics.checkNotNull((Object)sdkAdditionalData, (String)"null cannot be cast to non-null type com.jetbrains.python.sdk.PythonSdkAdditionalData");
            UUID uUID = ((PythonSdkAdditionalData)sdkAdditionalData).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"sdk.sdkAdditionalData as\u2026onSdkAdditionalData).uuid");
            cacheKey = uUID;
            if (this.cache.containsKey(cacheKey)) {
                PythonPackageManager pythonPackageManager2 = this.cache.get(cacheKey);
                Intrinsics.checkNotNull((Object)pythonPackageManager2);
                manager = pythonPackageManager2;
                if (Intrinsics.areEqual((Object)manager.getProject(), (Object)project)) {
                    return manager;
                }
            }
            for (PythonPackageManagerProvider it : (Iterable)PythonPackageManagerProvider.Companion.getEP_NAME().getExtensionList()) {
                boolean bl = false;
                pythonPackageManager = it.createPackageManagerForSdk(project, sdk2);
                if (pythonPackageManager == null) {
                    continue;
                }
                break block5;
            }
            pythonPackageManager = null;
        }
        if (pythonPackageManager == null) {
            throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
        }
        manager = pythonPackageManager;
        this.cache.put(cacheKey, manager);
        return manager;
    }

    @NotNull
    public final PythonPackageManagementServiceBridge bridgeForSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        PythonPackageManagementServiceBridge bridge;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        Intrinsics.checkNotNull((Object)sdkAdditionalData, (String)"null cannot be cast to non-null type com.jetbrains.python.sdk.PythonSdkAdditionalData");
        UUID uUID = ((PythonSdkAdditionalData)sdkAdditionalData).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"sdk.sdkAdditionalData as\u2026onSdkAdditionalData).uuid");
        UUID cacheKey = uUID;
        if (this.bridgeCache.containsKey(cacheKey)) {
            PythonPackageManagementServiceBridge pythonPackageManagementServiceBridge = bridge = this.bridgeCache.get(cacheKey);
            if (Intrinsics.areEqual((Object)(pythonPackageManagementServiceBridge != null ? pythonPackageManagementServiceBridge.getProject() : null), (Object)project)) {
                return bridge;
            }
        }
        bridge = new PythonPackageManagementServiceBridge(project, sdk2);
        Disposer.register((Disposable)this, (Disposable)bridge);
        this.bridgeCache.put(cacheKey, bridge);
        return bridge;
    }

    public void dispose() {
        this.cache.clear();
    }
}

