/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.NotNull;

public class TransformClassicClassQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.classic.class.transform", new Object[0]);
        if (string == null) {
            TransformClassicClassQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            TransformClassicClassQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            TransformClassicClassQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = descriptor2.getPsiElement();
        if ((psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyClass.class)) != null) {
            PyClass pyClass = (PyClass)psiElement;
            PyExpression[] superClassExpressions = pyClass.getSuperClassExpressions();
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            if (superClassExpressions.length == 0) {
                pyClass.replace((PsiElement)generator.createFromText(LanguageLevel.getDefault(), PyClass.class, "class " + pyClass.getName() + "(object):\n    " + pyClass.getStatementList().getText()));
            } else {
                StringBuilder stringBuilder = new StringBuilder("class ");
                stringBuilder.append(pyClass.getName()).append("(");
                for (PyExpression expression : superClassExpressions) {
                    stringBuilder.append(expression.getText()).append(", ");
                }
                stringBuilder.append("object").append(":\n    ");
                stringBuilder.append(pyClass.getStatementList().getText());
                pyClass.replace((PsiElement)generator.createFromText(LanguageLevel.getDefault(), PyClass.class, stringBuilder.toString()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/TransformClassicClassQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/TransformClassicClassQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

