/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.DFALimitExceededException;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeVariable;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyInspectionsUtil;
import com.jetbrains.python.inspections.quickfix.AddGlobalQuickFix;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyDelStatementNavigator;
import com.jetbrains.python.psi.impl.PyGlobalStatementNavigator;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnboundLocalVariableInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyUnboundLocalVariableInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyUnboundLocalVariableInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyUnboundLocalVariableInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        Set<ScopeOwner> LARGE_FUNCTIONS;

        Visitor(ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
            this.LARGE_FUNCTIONS = new HashSet<ScopeOwner>();
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            ScopeVariable variable;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (PyResolveUtil.allowForwardReferences(node)) {
                return;
            }
            if (node.getContainingFile() instanceof PyExpressionCodeFragment) {
                return;
            }
            if (PyGlobalStatementNavigator.getByArgument((PsiElement)node) != null) {
                return;
            }
            if (node.isQualified()) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class) != null) {
                return;
            }
            String name2 = node.getReferencedName();
            if (name2 == null) {
                return;
            }
            ScopeOwner owner = ScopeUtil.getDeclarationScopeOwner((PsiElement)node, name2);
            Set<ScopeOwner> largeFunctions = this.LARGE_FUNCTIONS;
            assert (largeFunctions != null);
            if (owner == null || largeFunctions.contains(owner)) {
                return;
            }
            boolean isNonLocal = false;
            ScopeOwner currentScopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
            if (currentScopeOwner != null) {
                isNonLocal = ControlFlowCache.getScope(currentScopeOwner).isNonlocal(name2);
            }
            if (owner != currentScopeOwner && !isNonLocal) {
                return;
            }
            Scope scope = ControlFlowCache.getScope(isNonLocal ? currentScopeOwner : owner);
            PyAugAssignmentStatement augAssignment = (PyAugAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyAugAssignmentStatement.class);
            PyElement anchor = augAssignment != null && name2.equals(augAssignment.getTarget().getName()) ? augAssignment : node;
            try {
                variable = scope.getDeclaredVariable((PsiElement)anchor, name2);
            }
            catch (DFALimitExceededException e) {
                largeFunctions.add(owner);
                this.registerLargeFunction(owner);
                return;
            }
            if (variable == null) {
                if (!Visitor.isFirstUnboundRead(node, owner)) {
                    return;
                }
                PsiPolyVariantReference ref = node.getReference(this.getResolveContext());
                PsiElement resolved = ref.resolve();
                boolean isBuiltin = PyBuiltinCache.getInstance((PsiElement)node).isBuiltin(resolved);
                if (owner instanceof PyClass && (isBuiltin || ScopeUtil.getDeclarationScopeOwner((PsiElement)owner, name2) != null)) {
                    return;
                }
                if (PyDelStatementNavigator.getDelStatementByTarget((PsiElement)node) != null) {
                    return;
                }
                if (Visitor.resolvedUnderWithStatement(node, resolved) || Visitor.resolvedUnderAssignmentExpressionAndCondition(node, resolved)) {
                    return;
                }
                if (PyInspectionsUtil.hasAnyInterruptedControlFlowPaths((PsiElement)node)) {
                    return;
                }
                if (owner instanceof PyFile) {
                    if (isBuiltin) {
                        return;
                    }
                    if (resolved != null && !PyUtil.inSameFile((PsiElement)node, resolved)) {
                        return;
                    }
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unbound.name.undefined", name2));
                } else if (scope.isGlobal(name2)) {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unbound.name.undefined", name2));
                } else if (isNonLocal) {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unbound.local.variable", name2));
                } else {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unbound.local.variable", node.getName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, new AddGlobalQuickFix());
                }
            }
        }

        private static boolean resolvedUnderWithStatement(@NotNull PyReferenceExpression node, @Nullable PsiElement resolved) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            return resolved != null && PyUtil.inSameFile((PsiElement)node, resolved) && PsiTreeUtil.getParentOfType((PsiElement)resolved, PyWithStatement.class, (boolean)true, (Class[])new Class[]{ScopeOwner.class}) != null;
        }

        private static boolean resolvedUnderAssignmentExpressionAndCondition(@NotNull PyReferenceExpression node, @Nullable PsiElement resolved) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            return resolved instanceof PyTargetExpression && PyUtil.inSameFile((PsiElement)node, resolved) && resolved.getParent() instanceof PyAssignmentExpression && PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)resolved.getParent(), PyComprehensionElement.class, (boolean)true, (Class[])new Class[]{PyConditionalStatementPart.class}), PyConditionalStatementPart.class) != null;
        }

        private static boolean isFirstUnboundRead(@NotNull PyReferenceExpression node, @NotNull ScopeOwner owner) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (owner == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            String nodeName = node.getReferencedName();
            Scope scope = ControlFlowCache.getScope(owner);
            ControlFlow flow = ControlFlowCache.getControlFlow(owner);
            Instruction[] instructions = flow.getInstructions();
            int num = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)node);
            if (num < 0) {
                return true;
            }
            Ref first = Ref.create((Object)true);
            ControlFlowUtil.iteratePrev((int)num, (Instruction[])instructions, instruction -> {
                if (instruction instanceof ReadWriteInstruction) {
                    ReadWriteInstruction rwInstruction = (ReadWriteInstruction)((Object)instruction);
                    String name2 = rwInstruction.getName();
                    PsiElement element = rwInstruction.getElement();
                    if (element != null && name2 != null && name2.equals(nodeName) && instruction.num() < num) {
                        try {
                            ReadWriteInstruction.ACCESS access;
                            if (scope.getDeclaredVariable(element, name2) == null && (access = rwInstruction.getAccess()).isReadAccess()) {
                                first.set((Object)false);
                                return ControlFlowUtil.Operation.BREAK;
                            }
                        }
                        catch (DFALimitExceededException e) {
                            first.set((Object)false);
                        }
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                }
                return ControlFlowUtil.Operation.NEXT;
            });
            return (Boolean)first.get();
        }

        @Override
        public void visitPyNonlocalStatement(@NotNull PyNonlocalStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            for (PyTargetExpression var : node.getVariables()) {
                String name2 = var.getName();
                ScopeOwner owner = ScopeUtil.getDeclarationScopeOwner(var, name2);
                if (owner != null && !(owner instanceof PyFile)) continue;
                this.registerProblem((PsiElement)var, PyPsiBundle.message("INSP.unbound.nonlocal.variable", name2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private void registerLargeFunction(ScopeOwner owner) {
            this.registerProblem((PsiElement)(owner instanceof PyFunction ? ((PyFunction)owner).getNameIdentifier() : owner), PyPsiBundle.message("INSP.unbound.function.too.large", owner.getName()), ProblemHighlightType.WEAK_WARNING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyUnboundLocalVariableInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolvedUnderWithStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolvedUnderAssignmentExpressionAndCondition";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFirstUnboundRead";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyNonlocalStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

