/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyTypedDictInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyTypedDictInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyTypedDictInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(session)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J#\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\b2\u0006\u0010%\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\b2\u0006\u0010%\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\b2\u0006\u0010%\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010%\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\b2\u0006\u0010%\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\b2\u0006\u0010%\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\b2\u0006\u0010%\u001a\u000204H\u0016\u00a8\u00065"}, d2={"Lcom/jetbrains/python/inspections/PyTypedDictInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "checkValidTotality", "", "totalityValue", "Lcom/jetbrains/python/psi/PyExpression;", "checkValueIsAType", "expression", "strType", "", "getIndexExpressionValueOptions", "", "indexExpression", "inspectUpdateSequenceArgument", "sequenceElements", "", "typedDictType", "Lcom/jetbrains/python/psi/types/PyTypedDictType;", "([Lcom/jetbrains/python/psi/PyExpression;Lcom/jetbrains/python/psi/types/PyTypedDictType;)V", "isValidSuperclass", "", "argument", "type", "Lcom/jetbrains/python/psi/types/PyType;", "matchTypedDictFieldTypeAndTotality", "expected", "Lcom/jetbrains/python/psi/types/PyTypedDictType$FieldTypeAndTotality;", "actual", "tryGetNameIdentifier", "Lcom/intellij/psi/PsiElement;", "element", "visitPyArgumentList", "node", "Lcom/jetbrains/python/psi/PyArgumentList;", "visitPyAssignmentStatement", "Lcom/jetbrains/python/psi/PyAssignmentStatement;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "visitPyDelStatement", "Lcom/jetbrains/python/psi/PyDelStatement;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitPySubscriptionExpression", "Lcom/jetbrains/python/psi/PySubscriptionExpression;", "visitPyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyTypedDictInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTypedDictInspection.kt\ncom/jetbrains/python/inspections/PyTypedDictInspection$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,433:1\n819#2:434\n847#2,2:435\n800#2,11:439\n1855#2:450\n1856#2:453\n766#2:458\n857#2,2:459\n1549#2:461\n1620#2,3:462\n1855#2,2:465\n1747#2,3:468\n1747#2,3:471\n2624#2,3:474\n1747#2,3:477\n13579#3,2:437\n13579#3:457\n13580#3:467\n13579#3,2:480\n215#4,2:451\n187#4,3:454\n*S KotlinDebug\n*F\n+ 1 PyTypedDictInspection.kt\ncom/jetbrains/python/inspections/PyTypedDictInspection$Visitor\n*L\n56#1:434\n56#1:435,2\n129#1:439,11\n130#1:450\n130#1:453\n259#1:458\n259#1:459,2\n259#1:461\n259#1:462,3\n260#1:465,2\n274#1:468,3\n278#1:471,3\n292#1:474,3\n359#1:477,3\n99#1:437,2\n251#1:457\n251#1:467\n384#1:480,2\n131#1:451,2\n207#1:454,3\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyType operandType = this.myTypeEvalContext.getType(node.getOperand());
            if (!(operandType instanceof PyTypedDictType) || ((PyTypedDictType)operandType).isInferred()) {
                return;
            }
            PyExpression indexExpression = node.getIndexExpression();
            List<String> indexExpressionValueOptions = this.getIndexExpressionValueOptions(indexExpression);
            Collection collection = indexExpressionValueOptions;
            if (collection == null || collection.isEmpty()) {
                if (!((PyTypedDictType)operandType).isDefinition()) {
                    Set<String> set = ((PyTypedDictType)operandType).getFields().keySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"operandType.fields.keys");
                    String keyList2 = CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)visitPySubscriptionExpression.keyList.1.INSTANCE, (int)31, null);
                    Object[] objectArray = new Object[]{keyList2};
                    this.registerProblem((PsiElement)indexExpression, PyPsiBundle.message("INSP.typeddict.typeddict.key.must.be.string.literal.expected.one", objectArray));
                }
                return;
            }
            Object[] $this$filterNot$iv = (Object[])indexExpressionValueOptions;
            boolean $i$f$filterNot = false;
            Object[] objectArray = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((Map)((PyTypedDictType)operandType).getFields()).containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonMatchingFields = (List)destination$iv$iv;
            if (!((Collection)nonMatchingFields).isEmpty()) {
                String string;
                PsiElement psiElement = (PsiElement)indexExpression;
                if (nonMatchingFields.size() == 1) {
                    $this$filterNot$iv = new Object[]{((PyTypedDictType)operandType).getName(), nonMatchingFields.get(0)};
                    string = PyPsiBundle.message("INSP.typeddict.typeddict.has.no.key", $this$filterNot$iv);
                } else {
                    String nonMatchingFieldList2 = CollectionsKt.joinToString$default((Iterable)nonMatchingFields, null, null, null, (int)0, null, (Function1)visitPySubscriptionExpression.nonMatchingFieldList.1.INSTANCE, (int)31, null);
                    Object[] objectArray2 = new Object[]{((PyTypedDictType)operandType).getName(), nonMatchingFieldList2};
                    string = PyPsiBundle.message("INSP.typeddict.typeddict.has.no.keys", objectArray2);
                }
                this.registerProblem(psiElement, string);
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression value = node.findAssignedValue();
            if (value instanceof PyCallExpression && ((PyCallExpression)value).getCallee() != null) {
                PyExpression typedDictName;
                PyExpression pyExpression = ((PyCallExpression)value).getCallee();
                Intrinsics.checkNotNull((Object)pyExpression);
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyTypedDictTypeProvider.Companion.isTypedDict(pyExpression, typeEvalContext) && (typedDictName = ((PyCallExpression)value).getArgument(0, "name", PyExpression.class)) instanceof PyStringLiteralExpression && !Intrinsics.areEqual((Object)node.getName(), (Object)((PyStringLiteralExpression)typedDictName).getStringValue())) {
                    this.registerProblem((PsiElement)typedDictName, PyPsiBundle.message("INSP.typeddict.first.argument.has.to.match.variable.name", new Object[0]));
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void visitPyArgumentList(@NotNull PyArgumentList node) {
            PyCallExpression callExpression;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getParent() instanceof PyClass) {
                PsiElement psiElement = node.getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyClass");
                PyClass pyClass = (PyClass)psiElement;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(pyClass, typeEvalContext)) {
                    PyExpression[] pyExpressionArray = node.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"node.arguments");
                    PyExpression[] arguments = pyExpressionArray;
                    int n = 0;
                    int n2 = arguments.length;
                    while (n < n2) {
                        PyExpression argument = arguments[n];
                        PyType type2 = this.myTypeEvalContext.getType(argument);
                        Intrinsics.checkNotNullExpressionValue((Object)argument, (String)"argument");
                        if (!this.isValidSuperclass(argument, type2)) {
                            this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.typeddict.typeddict.cannot.inherit.from.non.typeddict.base.class", new Object[0]));
                        }
                        if (argument instanceof PyKeywordArgument && Intrinsics.areEqual((Object)((PyKeywordArgument)argument).getKeyword(), (Object)"total") && ((PyKeywordArgument)argument).getValueExpression() != null) {
                            PyExpression pyExpression = ((PyKeywordArgument)argument).getValueExpression();
                            Intrinsics.checkNotNull((Object)pyExpression);
                            this.checkValidTotality(pyExpression);
                        }
                        ++n;
                    }
                    return;
                }
            }
            if (node.getCallExpression() == null) return;
            PyCallExpression pyCallExpression = callExpression = node.getCallExpression();
            Intrinsics.checkNotNull((Object)pyCallExpression);
            PyExpression callee = pyCallExpression.getCallee();
            if (callee == null) return;
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (!PyTypedDictTypeProvider.Companion.isTypedDict(callee, typeEvalContext)) return;
            PyExpression fields = callExpression.getArgument(1, "fields", PyExpression.class);
            if (!(fields instanceof PyDictLiteralExpression)) {
                return;
            }
            PyKeyValueExpression[] pyKeyValueExpressionArray = ((PyDictLiteralExpression)fields).getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyKeyValueExpressionArray, (String)"fields.elements");
            Object[] $this$forEach$iv = pyKeyValueExpressionArray;
            boolean $i$f$forEach = false;
            int n = 0;
            int n3 = $this$forEach$iv.length;
            while (true) {
                if (n >= n3) {
                    PyExpression totalityArgument = callExpression.getArgument(2, "total", PyExpression.class);
                    if (totalityArgument == null) return;
                    this.checkValidTotality(totalityArgument);
                    return;
                }
                Object element$iv = $this$forEach$iv[n];
                PyKeyValueExpression it = (PyKeyValueExpression)element$iv;
                boolean bl = false;
                if (it == null) {
                    return;
                }
                PyExpression pyExpression = it.getValue();
                this.checkValueIsAType(it.getValue(), pyExpression != null ? pyExpression.getText() : null);
                ++n;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isValidSuperclass(PyExpression argument, PyType type2) {
            if (argument instanceof PyKeywordArgument) return true;
            if (type2 instanceof PyTypedDictType) return true;
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (PyTypedDictTypeProvider.Companion.isTypedDict(argument, typeEvalContext)) return true;
            if (!(argument instanceof PySubscriptionExpression)) return false;
            PyType pyType = this.myTypeEvalContext.getType(((PySubscriptionExpression)argument).getOperand());
            PyClassLikeType pyClassLikeType = pyType instanceof PyClassLikeType ? (PyClassLikeType)pyType : null;
            if (!Intrinsics.areEqual((Object)"typing.Generic", (Object)(pyClassLikeType != null ? pyClassLikeType.getClassQName() : null))) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyClass(@NotNull PyClass node) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (!PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(node, typeEvalContext)) {
                return;
            }
            if (node.getMetaClassExpression() != null) {
                PyExpression pyExpression = node.getMetaClassExpression();
                Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyExpression");
                this.registerProblem(pyExpression.getParent(), PyPsiBundle.message("INSP.typeddict.specifying.metaclass.not.allowed.in.typeddict", new Object[0]));
            }
            Map ancestorsFields = new LinkedHashMap();
            List list = node.getAncestorTypes(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.getAncestorTypes(myTypeEvalContext)");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PyTypedDictType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List typedDictAncestors = (List)destination$iv$iv;
            Iterable $this$forEach$iv = typedDictAncestors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyTypedDictType typedDict = (PyTypedDictType)element$iv;
                boolean bl = false;
                Map $this$forEach$iv2 = typedDict.getFields();
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry field = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    String key = (String)field.getKey();
                    PyTypedDictType.FieldTypeAndTotality value = (PyTypedDictType.FieldTypeAndTotality)field.getValue();
                    if (ancestorsFields.containsKey(key)) {
                        Object v = ancestorsFields.get(key);
                        Intrinsics.checkNotNull(v);
                        if (!this.matchTypedDictFieldTypeAndTotality((PyTypedDictType.FieldTypeAndTotality)v, value)) {
                            Object[] objectArray = new Object[]{key};
                            this.registerProblem((PsiElement)node.getSuperClassExpressionList(), PyPsiBundle.message("INSP.typeddict.cannot.overwrite.typeddict.field.while.merging", objectArray));
                            continue;
                        }
                    }
                    ancestorsFields.put(key, value);
                }
            }
            PyStatement[] pyStatementArray = node.getStatementList().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)pyStatementArray, (String)"node.statementList.statements");
            PyStatement singleStatement = (PyStatement)ArraysKt.singleOrNull((Object[])pyStatementArray);
            if (singleStatement != null && singleStatement instanceof PyExpressionStatement && ((PyExpressionStatement)singleStatement).getExpression() instanceof PyNoneLiteralExpression) {
                PyExpression pyExpression = ((PyExpressionStatement)singleStatement).getExpression();
                Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyNoneLiteralExpression");
                if (((PyNoneLiteralExpression)pyExpression).isEllipsis()) {
                    this.registerProblem(this.tryGetNameIdentifier((PsiElement)singleStatement), PyPsiBundle.message("INSP.typeddict.invalid.statement.in.typeddict.definition.expected.field.name.field.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                    return;
                }
            }
            node.processClassLevelDeclarations((arg_0, arg_1) -> Visitor.visitPyClass$lambda$4(this, ancestorsFields, arg_0, arg_1));
        }

        @Override
        public void visitPyDelStatement(@NotNull PyDelStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression[] pyExpressionArray = node.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"node.targets");
            for (PyExpression target : pyExpressionArray) {
                PyExpression[] pyExpressionArray2 = new PyExpression[]{target};
                for (PyExpression expr : PyUtil.flattenedParensAndTuples(pyExpressionArray2)) {
                    String index;
                    PyType type2;
                    if (!(expr instanceof PySubscriptionExpression) || !((type2 = this.myTypeEvalContext.getType(((PySubscriptionExpression)expr).getOperand())) instanceof PyTypedDictType) || ((PyTypedDictType)type2).isInferred() || (index = PyEvaluator.evaluate(((PySubscriptionExpression)expr).getIndexExpression(), String.class)) == null || !((Map)((PyTypedDictType)type2).getFields()).containsKey(index)) continue;
                    PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)type2).getFields().get(index);
                    Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                    if (!fieldTypeAndTotality.isRequired()) continue;
                    Object[] objectArray = new Object[]{index, ((PyTypedDictType)type2).getName()};
                    this.registerProblem((PsiElement)((PySubscriptionExpression)expr).getIndexExpression(), PyPsiBundle.message("INSP.typeddict.key.cannot.be.deleted", objectArray));
                }
            }
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            String key;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression callee = node.getCallee();
            if (!(callee instanceof PyReferenceExpression) || ((PyReferenceExpression)callee).getQualifier() == null) {
                return;
            }
            PyExpression pyExpression = ((PyReferenceExpression)callee).getQualifier();
            Intrinsics.checkNotNull((Object)pyExpression);
            PyType nodeType = this.myTypeEvalContext.getType(pyExpression);
            if (!(nodeType instanceof PyTypedDictType) || ((PyTypedDictType)nodeType).isInferred()) {
                return;
            }
            PyExpression[] pyExpressionArray = node.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"node.arguments");
            PyExpression[] arguments = pyExpressionArray;
            if (Intrinsics.areEqual((Object)"update", (Object)((PyReferenceExpression)callee).getName())) {
                PyExpression[] pyExpressionArray2;
                if (arguments.length == 1 && arguments[0] instanceof PySequenceExpression) {
                    PyExpression pyExpression2 = arguments[0];
                    Intrinsics.checkNotNull((Object)pyExpression2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PySequenceExpression");
                    pyExpressionArray2 = ((PySequenceExpression)pyExpression2).getElements();
                } else {
                    pyExpressionArray2 = arguments;
                }
                Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray2, (String)"if (arguments.size == 1 \u2026).elements else arguments");
                this.inspectUpdateSequenceArgument(pyExpressionArray2, (PyTypedDictType)nodeType);
            }
            if (Intrinsics.areEqual((Object)"clear", (Object)((PyReferenceExpression)callee).getName()) || Intrinsics.areEqual((Object)"popitem", (Object)((PyReferenceExpression)callee).getName())) {
                boolean bl;
                block21: {
                    Map $this$any$iv = ((PyTypedDictType)nodeType).getFields();
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        objectArray = $this$any$iv.entrySet().iterator();
                        while (objectArray.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry it = element$iv = objectArray.next();
                            boolean bl2 = false;
                            if (!((PyTypedDictType.FieldTypeAndTotality)it.getValue()).isRequired()) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    ASTNode aSTNode = ((PyReferenceExpression)callee).getNameElement();
                    this.registerProblem((PsiElement)(aSTNode != null ? aSTNode.getPsi() : null), PyPsiBundle.message("INSP.typeddict.this.operation.might.break.typeddict.consistency", new Object[0]), Intrinsics.areEqual((Object)"clear", (Object)((PyReferenceExpression)callee).getName()) ? ProblemHighlightType.WARNING : ProblemHighlightType.WEAK_WARNING);
                }
            }
            if (Intrinsics.areEqual((Object)"pop", (Object)((PyReferenceExpression)callee).getName())) {
                String string = key = !(arguments.length == 0) ? PyEvaluator.evaluate(arguments[0], String.class) : null;
                if (key != null && ((Map)((PyTypedDictType)nodeType).getFields()).containsKey(key)) {
                    PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)nodeType).getFields().get(key);
                    Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                    if (fieldTypeAndTotality.isRequired()) {
                        ASTNode aSTNode = ((PyReferenceExpression)callee).getNameElement();
                        Object[] $i$f$any = new Object[]{key, ((PyTypedDictType)nodeType).getName()};
                        this.registerProblem((PsiElement)(aSTNode != null ? aSTNode.getPsi() : null), PyPsiBundle.message("INSP.typeddict.key.cannot.be.deleted", $i$f$any));
                    }
                }
            }
            if (Intrinsics.areEqual((Object)"setdefault", (Object)((PyReferenceExpression)callee).getName())) {
                String string = key = !(arguments.length == 0) ? PyEvaluator.evaluate(arguments[0], String.class) : null;
                if (key != null && ((Map)((PyTypedDictType)nodeType).getFields()).containsKey(key)) {
                    PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)nodeType).getFields().get(key);
                    Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                    if (!fieldTypeAndTotality.isRequired() && node.getArguments().length > 1) {
                        PyType valueType = this.myTypeEvalContext.getType(arguments[1]);
                        PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality2 = ((PyTypedDictType)nodeType).getFields().get(key);
                        Intrinsics.checkNotNull((Object)fieldTypeAndTotality2);
                        if (!PyTypeChecker.match(fieldTypeAndTotality2.getType(), valueType, this.myTypeEvalContext)) {
                            PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality3 = ((PyTypedDictType)nodeType).getFields().get(key);
                            Intrinsics.checkNotNull((Object)fieldTypeAndTotality3);
                            String string2 = PythonDocumentationProvider.getTypeName(fieldTypeAndTotality3.getType(), this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeName(nodeType.fie\u2026       myTypeEvalContext)");
                            String expectedTypeName = string2;
                            String string3 = PythonDocumentationProvider.getTypeName(valueType, this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTypeName(valueType, myTypeEvalContext)");
                            String actualTypeName = string3;
                            Object[] objectArray2 = new Object[]{expectedTypeName, actualTypeName};
                            this.registerProblem((PsiElement)arguments[1], PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", objectArray2));
                        }
                    }
                }
            }
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (PyTypedDictTypeProvider.Companion.isGetMethodToOverride(node, typeEvalContext)) {
                PyExpression pyExpression3 = node.getArgument(0, "key", PyExpression.class);
                if (pyExpression3 == null) {
                    return;
                }
                PyExpression keyArgument = pyExpression3;
                String key2 = PyEvaluator.evaluate(keyArgument, String.class);
                if (key2 == null) {
                    this.registerProblem((PsiElement)keyArgument, PyPsiBundle.message("INSP.typeddict.key.should.be.string", new Object[0]));
                    return;
                }
                if (!((PyTypedDictType)nodeType).getFields().containsKey(key2)) {
                    objectArray = new Object[]{((PyTypedDictType)nodeType).getName(), key2};
                    this.registerProblem((PsiElement)keyArgument, PyPsiBundle.message("INSP.typeddict.typeddict.has.no.key", objectArray));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List<Pair<PyExpression, PyExpression>> list = node.getTargetsToValuesMapping();
            Intrinsics.checkNotNullExpressionValue(list, (String)"node.targetsToValuesMapping");
            List<Pair<PyExpression, PyExpression>> targetsToValuesMapping = list;
            PyExpression[] pyExpressionArray = node.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"node.targets");
            Object[] $this$forEach$iv = pyExpressionArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Pair it;
                void $this$filterTo$iv$iv;
                String indexString;
                PyType targetType;
                PyExpression target = (PyExpression)element$iv;
                boolean bl = false;
                if (!(target instanceof PySubscriptionExpression) || !((targetType = this.myTypeEvalContext.getType(((PySubscriptionExpression)target).getOperand())) instanceof PyTypedDictType) || (indexString = PyEvaluator.evaluate(((PySubscriptionExpression)target).getIndexExpression(), String.class)) == null) continue;
                PyType expected = ((PyTypedDictType)targetType).getElementType(indexString);
                Iterable $this$filter$iv = targetsToValuesMapping;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Pair)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.first, (Object)target)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add((PyExpression)it.second);
                }
                List actualExpressions = (List)destination$iv$iv;
                Iterable $this$forEach$iv2 = actualExpressions;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String actualTypeName;
                    String expectedTypeName;
                    PyExpression actual = (PyExpression)element$iv2;
                    boolean bl4 = false;
                    PyType actualType = this.myTypeEvalContext.getType(actual);
                    if (PyTypeChecker.match(expected, actualType, this.myTypeEvalContext)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext), (String)"getTypeName(expected, myTypeEvalContext)");
                    Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(actualType, this.myTypeEvalContext), (String)"getTypeName(actualType, myTypeEvalContext)");
                    Object[] objectArray = new Object[]{expectedTypeName, actualTypeName};
                    this.registerProblem((PsiElement)actual, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", objectArray));
                }
            }
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)node), PyImportStatementBase.class) == null) {
                boolean isNotRequired;
                boolean isRequired;
                block21: {
                    boolean bl;
                    block20: {
                        Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(node, this.myTypeEvalContext);
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(node, myTypeEvalContext)");
                        Iterable $this$any$iv = collection;
                        boolean $i$f$any = false;
                        if (((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String qualifiedName = (String)element$iv;
                                boolean bl2 = false;
                                boolean bl3 = Intrinsics.areEqual((Object)"typing.Required", (Object)qualifiedName) || Intrinsics.areEqual((Object)"typing_extensions.Required", (Object)qualifiedName);
                                if (!bl3) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    isRequired = bl;
                    Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(node, this.myTypeEvalContext);
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(node, myTypeEvalContext)");
                    Iterable $this$any$iv = collection;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String qualifiedName = (String)element$iv;
                            boolean bl4 = false;
                            boolean bl5 = Intrinsics.areEqual((Object)"typing.NotRequired", (Object)qualifiedName) || Intrinsics.areEqual((Object)"typing_extensions.NotRequired", (Object)qualifiedName);
                            if (!bl5) continue;
                            v4 = true;
                            break block21;
                        }
                        v4 = isNotRequired = false;
                    }
                }
                if (isRequired || isNotRequired) {
                    Object[] objectArray;
                    PyClass classParent = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)node), PyClass.class);
                    PyCallExpression callParent = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)node), PyCallExpression.class);
                    if (classParent == null) {
                        if (callParent == null) {
                            Object element$iv;
                            element$iv = new Object[]{isRequired ? "Required" : "NotRequired"};
                            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.typeddict.required.notrequired.cannot.be.used.outside.typeddict.definition", (Object[])element$iv));
                        } else if (callParent.getCallee() != null) {
                            boolean bl;
                            block22: {
                                PyExpression pyExpression = callParent.getCallee();
                                Intrinsics.checkNotNull((Object)pyExpression);
                                Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(pyExpression, this.myTypeEvalContext);
                                Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(\u2026lee!!, myTypeEvalContext)");
                                Iterable $this$none$iv = collection;
                                boolean $i$f$none = false;
                                if (((Collection)$this$none$iv).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (Object element$iv : $this$none$iv) {
                                        String qualifiedName = (String)element$iv;
                                        boolean bl6 = false;
                                        if (!(Intrinsics.areEqual((Object)"typing.TypedDict", (Object)qualifiedName) || Intrinsics.areEqual((Object)"typing_extensions.TypedDict", (Object)qualifiedName))) continue;
                                        bl = false;
                                        break block22;
                                    }
                                    bl = true;
                                }
                            }
                            if (bl) {
                                objectArray = new Object[]{isRequired ? "Required" : "NotRequired"};
                                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.typeddict.required.notrequired.cannot.be.used.outside.typeddict.definition", objectArray));
                            }
                        }
                    } else {
                        TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                        if (!PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(classParent, typeEvalContext)) {
                            objectArray = new Object[]{isRequired ? "Required" : "NotRequired"};
                            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.typeddict.required.notrequired.cannot.be.used.outside.typeddict.definition", objectArray));
                        }
                    }
                    if (node.getParent() instanceof PySubscriptionExpression) {
                        PsiElement psiElement = node.getParent();
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PySubscriptionExpression");
                        if (((PySubscriptionExpression)psiElement).getIndexExpression() instanceof PyTupleExpression) {
                            PsiElement psiElement2 = node.getParent();
                            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PySubscriptionExpression");
                            objectArray = new Object[]{isRequired ? "Required" : "NotRequired"};
                            this.registerProblem((PsiElement)((PySubscriptionExpression)psiElement2).getIndexExpression(), PyPsiBundle.message("INSP.typeddict.required.notrequired.must.have.exactly.one.type.argument", objectArray));
                        }
                    }
                }
            }
        }

        private final List<String> getIndexExpressionValueOptions(PyExpression indexExpression) {
            if (indexExpression == null) {
                return null;
            }
            String indexExprValue = PyEvaluator.evaluate(indexExpression, String.class);
            if (indexExprValue == null) {
                List list;
                PyType pyType = this.myTypeEvalContext.getType(indexExpression);
                if (pyType == null) {
                    return null;
                }
                PyType type2 = pyType;
                List members2 = PyTypeUtil.toStream(type2).map(arg_0 -> Visitor.getIndexExpressionValueOptions$lambda$13(getIndexExpressionValueOptions.members.1.INSTANCE, arg_0)).toList();
                if (members2.contains(null)) {
                    list = null;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)members2, (String)"members");
                    list = CollectionsKt.filterNotNull((Iterable)members2);
                }
                return list;
            }
            return CollectionsKt.listOf((Object)indexExprValue);
        }

        private final void checkValueIsAType(PyExpression expression, String strType) {
            if (!((expression instanceof PyReferenceExpression || expression instanceof PySubscriptionExpression || expression instanceof PyNoneLiteralExpression || expression instanceof PyBinaryExpression || expression instanceof PyStringLiteralExpression) && strType != null)) {
                this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.value.must.be.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                return;
            }
            if (expression instanceof PySubscriptionExpression && ((PySubscriptionExpression)expression).getOperand() instanceof PyReferenceExpression) {
                if (((PySubscriptionExpression)expression).getIndexExpression() instanceof PySubscriptionExpression) {
                    PyExpression pyExpression = ((PySubscriptionExpression)expression).getIndexExpression();
                    Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PySubscriptionExpression");
                    PySubscriptionExpression indexExpression = (PySubscriptionExpression)pyExpression;
                    if (indexExpression.getOperand() instanceof PyReferenceExpression) {
                        PyExpression pyExpression2 = ((PySubscriptionExpression)expression).getOperand();
                        Intrinsics.checkNotNull((Object)pyExpression2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyReferenceExpression");
                        PyExpression pyExpression3 = (PyReferenceExpression)pyExpression2;
                        TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                        Boolean operandIsRequired = PyTypedDictTypeProvider.Companion.isRequired(pyExpression3, typeEvalContext);
                        PyExpression pyExpression4 = indexExpression.getOperand();
                        Intrinsics.checkNotNull((Object)pyExpression4, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyReferenceExpression");
                        PyExpression pyExpression5 = (PyReferenceExpression)pyExpression4;
                        TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
                        Boolean indexIsRequired = PyTypedDictTypeProvider.Companion.isRequired(pyExpression5, typeEvalContext2);
                        if (operandIsRequired != null && indexIsRequired != null && operandIsRequired ^ indexIsRequired) {
                            this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.cannot.be.required.and.not.required.at.the.same.time", new Object[0]));
                        }
                    }
                }
                return;
            }
            PyType type2 = (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(strType, (PsiElement)expression, this.myTypeEvalContext));
            if (type2 == null) {
                boolean bl;
                block10: {
                    Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(\u2026ssion, myTypeEvalContext)");
                    Iterable $this$any$iv = collection;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String qualifiedName = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)"typing.Any", (Object)qualifiedName)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.value.must.be.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                }
            }
        }

        private final PsiElement tryGetNameIdentifier(PsiElement element) {
            PsiElement psiElement;
            if (element instanceof PsiNameIdentifierOwner) {
                psiElement = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                if (psiElement == null) {
                    psiElement = element;
                }
            } else {
                psiElement = element;
            }
            return psiElement;
        }

        private final void checkValidTotality(PyExpression totalityValue) {
            Object[] objectArray;
            if (LanguageLevel.forElement(totalityValue.getOriginalElement()).isPy3K() && !(totalityValue instanceof PyBoolLiteralExpression) || !CollectionsKt.listOf((Object[])(objectArray = new String[]{"True", "False"})).contains(totalityValue.getText())) {
                this.registerProblem((PsiElement)totalityValue, PyPsiBundle.message("INSP.typeddict.total.value.must.be.true.or.false", new Object[0]));
            }
        }

        private final boolean matchTypedDictFieldTypeAndTotality(PyTypedDictType.FieldTypeAndTotality expected, PyTypedDictType.FieldTypeAndTotality actual) {
            return expected.isRequired() == actual.isRequired() && PyTypeChecker.match(expected.getType(), actual.getType(), this.myTypeEvalContext);
        }

        private final void inspectUpdateSequenceArgument(PyExpression[] sequenceElements, PyTypedDictType typedDictType) {
            PyExpression[] $this$forEach$iv = sequenceElements;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String actualTypeName;
                String expectedTypeName;
                Object[] objectArray;
                PyExpression element$iv;
                PyExpression it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                PsiElement key = null;
                String keyAsString = null;
                PyExpression value = null;
                if (it instanceof PyKeyValueExpression && ((PyKeyValueExpression)it).getKey() instanceof PyStringLiteralExpression) {
                    key = (PsiElement)((PyKeyValueExpression)it).getKey();
                    PyExpression pyExpression = ((PyKeyValueExpression)it).getKey();
                    Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                    keyAsString = ((PyStringLiteralExpression)pyExpression).getStringValue();
                    value = ((PyKeyValueExpression)it).getValue();
                } else if (it instanceof PyParenthesizedExpression) {
                    PyExpression expression = PyPsiUtils.flattenParens(it);
                    if (expression == null) continue;
                    if (expression instanceof PyTupleExpression && ((PyTupleExpression)expression).getElements().length == 2 && ((PyTupleExpression)expression).getElements()[0] instanceof PyStringLiteralExpression) {
                        key = (PsiElement)((PyTupleExpression)expression).getElements()[0];
                        PyExpression pyExpression = ((PyTupleExpression)expression).getElements()[0];
                        Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                        keyAsString = ((PyStringLiteralExpression)pyExpression).getStringValue();
                        value = ((PyTupleExpression)expression).getElements()[1];
                    }
                } else {
                    if (!(it instanceof PyKeywordArgument) || ((PyKeywordArgument)it).getValueExpression() == null) continue;
                    ASTNode aSTNode = ((PyKeywordArgument)it).getKeywordNode();
                    key = aSTNode != null ? aSTNode.getPsi() : null;
                    keyAsString = ((PyKeywordArgument)it).getKeyword();
                    value = ((PyKeywordArgument)it).getValueExpression();
                }
                LinkedHashMap<String, PyTypedDictType.FieldTypeAndTotality> fields = typedDictType.getFields();
                if (value == null) continue;
                if (keyAsString == null) {
                    objectArray = new Object[]{typedDictType.getName()};
                    this.registerProblem(key, PyPsiBundle.message("INSP.typeddict.cannot.add.non.string.key.to.typeddict", objectArray));
                    continue;
                }
                if (!fields.containsKey(keyAsString)) {
                    objectArray = new Object[]{typedDictType.getName(), keyAsString};
                    this.registerProblem(key, PyPsiBundle.message("INSP.typeddict.typeddict.cannot.have.key", objectArray));
                    continue;
                }
                PyType valueType = this.myTypeEvalContext.getType(value);
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = fields.get(keyAsString);
                if (PyTypeChecker.match(fieldTypeAndTotality != null ? fieldTypeAndTotality.getType() : null, valueType, this.myTypeEvalContext)) continue;
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality2 = fields.get(keyAsString);
                Intrinsics.checkNotNull((Object)fieldTypeAndTotality2);
                Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(fieldTypeAndTotality2.getType(), this.myTypeEvalContext), (String)"getTypeName(fields[keyAs\u2026.type, myTypeEvalContext)");
                Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(valueType, this.myTypeEvalContext), (String)"getTypeName(valueType, myTypeEvalContext)");
                Object[] objectArray2 = new Object[]{expectedTypeName, actualTypeName};
                this.registerProblem((PsiElement)value, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", objectArray2));
            }
        }

        private static final boolean visitPyClass$lambda$4(Visitor this$0, Map $ancestorsFields, PsiElement element, ResolveState resolveState) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$ancestorsFields, (String)"$ancestorsFields");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)resolveState, (String)"<anonymous parameter 1>");
            if (!(element instanceof PyTargetExpression)) {
                this$0.registerProblem(this$0.tryGetNameIdentifier(element), PyPsiBundle.message("INSP.typeddict.invalid.statement.in.typeddict.definition.expected.field.name.field.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                return true;
            }
            if (((PyTargetExpression)element).hasAssignedValue()) {
                this$0.registerProblem((PsiElement)((PyTargetExpression)element).findAssignedValue(), PyPsiBundle.message("INSP.typeddict.right.hand.side.values.are.not.supported.in.typeddict", new Object[0]));
                return true;
            }
            if ($ancestorsFields.containsKey(((PyTargetExpression)element).getName())) {
                this$0.registerProblem(element, PyPsiBundle.message("INSP.typeddict.cannot.overwrite.typeddict.field", new Object[0]));
                return true;
            }
            PyAnnotation pyAnnotation = ((PyTargetExpression)element).getAnnotation();
            this$0.checkValueIsAType(pyAnnotation != null ? pyAnnotation.getValue() : null, ((PyTargetExpression)element).getAnnotationValue());
            return true;
        }

        private static final String getIndexExpressionValueOptions$lambda$13(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }
    }
}

