/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyDataclassParameters;
import com.jetbrains.python.codeInsight.PyDataclassesKt;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/inspections/PyThirdPartyInspectionExtension;", "Lcom/jetbrains/python/inspections/PyInspectionExtension;", "()V", "ignoreMethodParameters", "", "function", "Lcom/jetbrains/python/psi/PyFunction;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "ignoreUnresolvedMember", "type", "Lcom/jetbrains/python/psi/types/PyType;", "name", "", "resolvesTo", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "qualifiedName", "resolveContext", "Lcom/jetbrains/python/psi/resolve/PyResolveContext;", "intellij.python.community.impl"})
public final class PyThirdPartyInspectionExtension
extends PyInspectionExtension {
    @Override
    public boolean ignoreMethodParameters(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyClass cls = function.getContainingClass();
        if (cls != null) {
            String interfaceQName = "zope.interface.interface.Interface";
            if (cls.isSubclass(interfaceQName, context)) {
                return true;
            }
            PyResolveContext pyResolveContext = PyResolveContext.defaultContext(context);
            Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(context)");
            PyResolveContext resolveContext = pyResolveContext;
            PyExpression[] pyExpressionArray = cls.getSuperClassExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"cls.superClassExpressions");
            for (PyExpression expression : pyExpressionArray) {
                Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"expression");
                if (!this.resolvesTo(expression, interfaceQName, resolveContext)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean ignoreUnresolvedMember(@NotNull PyType type2, @NotNull String name2, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)name2, (Object)"__attrs_attrs__")) return false;
        if (!(type2 instanceof PyClassType)) return false;
        PyClass pyClass = ((PyClassType)type2).getPyClass();
        Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"type.pyClass");
        Object object = PyDataclassesKt.parseDataclassParameters(pyClass, context);
        if ((object != null && (object = ((PyDataclassParameters)object).getType()) != null ? object.getAsPredefinedType() : null) != PyDataclassParameters.PredefinedType.ATTRS) return false;
        return true;
    }

    private final boolean resolvesTo(PyExpression expression, String qualifiedName, PyResolveContext resolveContext) {
        return ContainerUtil.exists((Iterable)PyUtil.multiResolveTopPriority((PsiElement)expression, resolveContext), arg_0 -> PyThirdPartyInspectionExtension.resolvesTo$lambda$0((Function1)new Function1<PsiElement, Boolean>(qualifiedName){
            final /* synthetic */ String $qualifiedName;
            {
                this.$qualifiedName = $qualifiedName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PsiElement it) {
                return it instanceof PyElement && Intrinsics.areEqual((Object)QualifiedNameFinder.getQualifiedName((PyElement)it), (Object)this.$qualifiedName);
            }
        }, arg_0));
    }

    private static final boolean resolvesTo$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

