/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyCodeStyleMainPanel;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final String SPACING_SETTINGS_PREVIEW = "def settings_preview(argument, key=value):\n    dict = {1:'a', 2:'b', 3:'c'}\n    x = dict[1]\n    expr = (1+2)*3 << 4**5 & 16\n    if expr == 0 or abs(expr) < 0: print('weird'); return\n    settings_preview(key=1)\n\nfoo =\\\n    bar\n\ndef no_params():\n    return globals()";
    private static final String BLANK_LINES_SETTINGS_PREVIEW = "import os\nclass C(object):\n    import sys\n    x = 1\n    def foo(self):\n        import platform\n        print(platform.processor())";
    private static final String WRAP_SETTINGS_PREVIEW = "from module import foo, bar, baz, quux\n\nlong_expression = component_one + component_two + component_three + component_four + component_five + component_six\n\ndef xyzzy(a1, a2, long_parameter_1, a3, a4, long_parameter_2):\n    pass\n\nxyzzy(1, 2, 'long_string_constant1', 3, 4, 'long_string_constant2')\n\nxyzzy(\n    'with',\n    'hanging',\n      'indent'\n)\nattrs = [e.attr for e in\n    items]\n\ningredients = [\n    'green',\n    'eggs',\n]\n\nif True: pass\n\ntry: pass\nfinally: pass\n";
    private static final String INDENT_SETTINGS_PREVIEW = "def foo():\n    print('bar')\n\ndef long_function_name(\n        var_one, var_two, var_three,\n        var_four):\n    print(var_one)";

    @NotNull
    public Language getLanguage() {
        PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        if (pythonLanguage == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return pythonLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            return SPACING_SETTINGS_PREVIEW;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            return BLANK_LINES_SETTINGS_PREVIEW;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return WRAP_SETTINGS_PREVIEW;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            return INDENT_SETTINGS_PREVIEW;
        }
        return "";
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_EMPTY_METHOD_PARENTHESES", "SPACE_WITHIN_BRACKETS", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA", "SPACE_BEFORE_SEMICOLON"});
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_BEFORE_LBRACKET", PyBundle.message("formatter.left.bracket", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AROUND_POWER_OPERATOR", PyBundle.message("formatter.around.power.operator", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AROUND_EQ_IN_NAMED_PARAMETER", PyBundle.message("formatter.around.eq.in.named.parameter", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT", PyBundle.message("formatter.around.eq.in.keyword.argument", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_WITHIN_BRACES", PyBundle.message("formatter.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_BEFORE_PY_COLON", ApplicationBundle.message((String)"checkbox.spaces.before.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AFTER_PY_COLON", ApplicationBundle.message((String)"checkbox.spaces.after.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_BEFORE_BACKSLASH", PyBundle.message("formatter.before.backslash", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_BEFORE_NUMBER_SIGN", PyBundle.message("formatter.before.hash", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AFTER_NUMBER_SIGN", PyBundle.message("formatter.after.hash", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.renameStandardOption("SPACE_AROUND_MULTIPLICATIVE_OPERATORS", PyBundle.message("formatter.around.multiplicative.operators", new Object[0]));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_AFTER_IMPORTS", "KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE"});
            consumer.renameStandardOption("BLANK_LINES_AFTER_IMPORTS", PyBundle.message("formatter.around.top.level.imports", new Object[0]));
            consumer.showCustomOption(PyCodeStyleSettings.class, "BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS", PyBundle.message("formatter.around.top.level.classes.and.function", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "BLANK_LINES_AFTER_LOCAL_IMPORTS", PyBundle.message("formatter.after.local.imports", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "BLANK_LINES_BEFORE_FIRST_METHOD", PyBundle.message("formatter.before.first.method", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "WRAP_LONG_LINES", "CALL_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_PARAMETERS", "METHOD_PARAMETERS_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS"});
            consumer.showCustomOption(PyCodeStyleSettings.class, "NEW_LINE_AFTER_COLON", PyBundle.message("formatter.single.clause.statements", new Object[0]), PyBundle.message("formatter.force.new.line.after.colon", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "NEW_LINE_AFTER_COLON_MULTI_CLAUSE", PyBundle.message("formatter.multi.clause.statements", new Object[0]), PyBundle.message("formatter.force.new.line.after.colon", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "ALIGN_COLLECTIONS_AND_COMPREHENSIONS", PyBundle.message("formatter.align.when.multiline", new Object[0]), PyBundle.message("formatter.collections.and.comprehensions", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "FROM_IMPORT_WRAPPING", PyBundle.message("formatter.from.import.statements", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(PyCodeStyleSettings.class, "ALIGN_MULTILINE_IMPORTS", PyBundle.message("formatter.align.when.multiline", new Object[0]), PyBundle.message("formatter.from.import.statements", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "FROM_IMPORT_NEW_LINE_AFTER_LEFT_PARENTHESIS", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0]), PyBundle.message("formatter.from.import.statements", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "FROM_IMPORT_NEW_LINE_BEFORE_RIGHT_PARENTHESIS", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]), PyBundle.message("formatter.from.import.statements", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "FROM_IMPORT_PARENTHESES_FORCE_IF_MULTILINE", PyBundle.message("formatter.from.import.statements.force.parentheses.if.multiline", new Object[0]), PyBundle.message("formatter.from.import.statements", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "FROM_IMPORT_TRAILING_COMMA_IF_MULTILINE", PyBundle.message("formatter.from.import.statements.force.comma.if.multline", new Object[0]), PyBundle.message("formatter.from.import.statements", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "DICT_WRAPPING", PyBundle.message("formatter.dictionary.literals", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(PyCodeStyleSettings.class, "DICT_NEW_LINE_AFTER_LEFT_BRACE", ApplicationBundle.message((String)"wrapping.new.line.after.lbrace", (Object[])new Object[0]), PyBundle.message("formatter.dictionary.literals", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "DICT_NEW_LINE_BEFORE_RIGHT_BRACE", ApplicationBundle.message((String)"wrapping.rbrace.on.new.line", (Object[])new Object[0]), PyBundle.message("formatter.dictionary.literals", new Object[0]), new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "HANG_CLOSING_BRACKETS", PyBundle.message("formatter.hang.closing.brackets", new Object[0]), null, new Object[0]);
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        indentOptions.INDENT_SIZE = 4;
        commonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = true;
        commonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = 1;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        commonSettings.METHOD_PARAMETERS_WRAP = 1;
        commonSettings.CALL_PARAMETERS_WRAP = 1;
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        return new PyCodeStyleSettings(settings);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (modelSettings == null) {
            PyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return new CodeStyleAbstractConfigurable(baseSettings, modelSettings, PyBundle.message("configurable.PyLanguageCodeStyleSettingsProvider.display.name", new Object[0])){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new PyCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.python";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/python/formatter/PyLanguageCodeStyleSettingsProvider$1", "createPanel"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

