/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.MemoryDumpHelper;
import com.jetbrains.performancePlugin.commands.MemoryDumpCommand;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0014\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/ConditionalMemoryDumpCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.performanceTesting"})
public final class ConditionalMemoryDumpCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "conditionalMemoryDumpCommand";
    @NotNull
    public static final String PREFIX = "%conditionalMemoryDumpCommand";
    @NotNull
    private static final Logger LOG;

    public ConditionalMemoryDumpCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        String string = this.extractCommandArgument(PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractCommandArgument(PREFIX)");
        int targetMessageCount = Integer.parseInt(string);
        Ref.IntRef currentMessageCount = new Ref.IntRef();
        LowMemoryWatcher.register(() -> ConditionalMemoryDumpCommand.doExecute$lambda$0(currentMessageCount, targetMessageCount), (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC, (Disposable)((Disposable)ApplicationManager.getApplication()));
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    protected String getName() {
        return NAME;
    }

    private static final void doExecute$lambda$0(Ref.IntRef $currentMessageCount, int $targetMessageCount) {
        Intrinsics.checkNotNullParameter((Object)$currentMessageCount, (String)"$currentMessageCount");
        int n = $currentMessageCount.element;
        $currentMessageCount.element = n + 1;
        if ($currentMessageCount.element == $targetMessageCount) {
            String string = MemoryDumpCommand.getMemoryDumpPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemoryDumpPath()");
            String memoryDumpPath = string;
            LOG.info("Dumping memory snapshot to: " + memoryDumpPath);
            MemoryDumpHelper.captureMemoryDump((String)memoryDumpPath);
        }
    }

    static {
        Logger logger = Logger.getInstance(ConditionalMemoryDumpCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(ConditionalM\u2026yDumpCommand::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/performancePlugin/commands/ConditionalMemoryDumpCommand$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NAME", "", "PREFIX", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

