/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.performancePlugin.commands.AbstractFileCommand;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/AddFileCommand;", "Lcom/jetbrains/performancePlugin/commands/AbstractFileCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
public final class AddFileCommand
extends AbstractFileCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PREFIX = "%addFile";

    public AddFileCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback, @NotNull PlaybackContext context) throws Exception {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList input = this.extractCommandList(PREFIX, ",");
        Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
        if (!this.isCommandParametersRight(input)) {
            callback.reject("Command %addFile should have 2 non empty parameters (1 - path to directory, 2 - file name) with delimiter ','.");
            return;
        }
        String[] stringArray = new String[]{input.get(1)};
        if (VirtualFileManager.getInstance().findFileByNioPath(Paths.get((String)input.get(0), stringArray)) != null) {
            stringArray = new String[]{input.get(1)};
            callback.reject("File by " + Paths.get((String)input.get(0), stringArray) + " path from parameters already exists.");
            return;
        }
        LOG.info("Add file " + input.get(1) + " " + input.get(0));
        Path path = Paths.get((String)input.get(0), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(input[0])");
        super.execute(path, callback, (Function1<? super VirtualFile, ? extends Object>)((Function1)new Function1<VirtualFile, Object>((ArrayList<String>)input){
            final /* synthetic */ ArrayList<String> $input;
            {
                this.$input = $input;
                super(1);
            }

            @NotNull
            public final Object invoke(@NotNull VirtualFile virtualFile) {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                VirtualFile virtualFile2 = virtualFile.createChildData(null, this.$input.get(1));
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile.createChildData(null, input[1])");
                return virtualFile2;
            }
        }));
    }

    static {
        Logger logger = Logger.getInstance(AddFileCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(AddFileCommand::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/performancePlugin/commands/AddFileCommand$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

