/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u00c2\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u0015\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\nH\u00c2\u0003JK\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/NullableEnumEventField;", "T", "", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "name", "", "enumClass", "Ljava/lang/Class;", "nullValue", "transform", "Lkotlin/Function1;", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "addData", "", "fuData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "value", "(Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;Ljava/lang/Enum;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
public final class NullableEnumEventField<T extends Enum<?>>
extends PrimitiveEventField<T> {
    @NotNull
    private final String name;
    @NotNull
    private final Class<T> enumClass;
    @Nullable
    private final String nullValue;
    @NotNull
    private final Function1<T, String> transform;

    public NullableEnumEventField(@NotNull String name, @NotNull Class<T> enumClass, @Nullable String nullValue, @NotNull Function1<? super T, String> transform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        this.name = name;
        this.enumClass = enumClass;
        this.nullValue = nullValue;
        this.transform = transform;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void addData(@NotNull FeatureUsageData fuData, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
        if (value == null) {
            if (this.nullValue != null) {
                fuData.addData(this.getName(), this.nullValue);
            }
        } else {
            fuData.addData(this.getName(), (String)this.transform.invoke(value));
        }
    }

    @Override
    @NotNull
    public List<String> getValidationRule() {
        Object[] objectArray = this.enumClass.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"enumClass.enumConstants");
        String enumValues = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"|", null, null, (int)0, null, this.transform, (int)30, null);
        if (this.nullValue != null) {
            return CollectionsKt.listOf((Object)("{enum:" + enumValues + "|" + this.nullValue + "}"));
        }
        return CollectionsKt.listOf((Object)("{enum:" + enumValues + "}"));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    private final Class<T> component2() {
        return this.enumClass;
    }

    private final String component3() {
        return this.nullValue;
    }

    private final Function1<T, String> component4() {
        return this.transform;
    }

    @NotNull
    public final NullableEnumEventField<T> copy(@NotNull String name, @NotNull Class<T> enumClass, @Nullable String nullValue, @NotNull Function1<? super T, String> transform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return new NullableEnumEventField<T>(name, enumClass, nullValue, transform);
    }

    public static /* synthetic */ NullableEnumEventField copy$default(NullableEnumEventField nullableEnumEventField, String string, Class clazz, String string2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = nullableEnumEventField.name;
        }
        if ((n & 2) != 0) {
            clazz = nullableEnumEventField.enumClass;
        }
        if ((n & 4) != 0) {
            string2 = nullableEnumEventField.nullValue;
        }
        if ((n & 8) != 0) {
            function1 = nullableEnumEventField.transform;
        }
        return nullableEnumEventField.copy(string, clazz, string2, function1);
    }

    @NotNull
    public String toString() {
        return "NullableEnumEventField(name=" + this.name + ", enumClass=" + this.enumClass + ", nullValue=" + this.nullValue + ", transform=" + this.transform + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.enumClass.hashCode();
        result = result * 31 + (this.nullValue == null ? 0 : this.nullValue.hashCode());
        result = result * 31 + this.transform.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NullableEnumEventField)) {
            return false;
        }
        NullableEnumEventField nullableEnumEventField = (NullableEnumEventField)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)nullableEnumEventField.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.enumClass, nullableEnumEventField.enumClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.nullValue, (Object)nullableEnumEventField.nullValue)) {
            return false;
        }
        return Intrinsics.areEqual(this.transform, nullableEnumEventField.transform);
    }
}

