/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.FileStateKt;
import com.intellij.settingsSync.SettingsProvider;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.plugins.SettingsSyncPluginsState;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001/B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J3\u0010\u000f\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u001dH\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\fH\u0002J-\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00112\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0011H\u0000\u00a2\u0006\u0002\b*J\u0016\u0010+\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/settingsSync/SettingsSnapshotZipSerializer;", "", "()V", "INFO", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "METAINFO", "PLUGINS", "json", "Lkotlinx/serialization/json/Json;", "deserializePlugins", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginsState;", "metaInfoFolder", "Ljava/nio/file/Path;", "deserializeSettingsProviders", "Lkotlin/Pair;", "", "", "containingFolder", "deserializeSettingsProviders$intellij_settingsSync", "extractFromZip", "Lcom/intellij/settingsSync/SettingsSnapshot;", "zipFile", "getContentForFileState", "", "fileState", "Lcom/intellij/settingsSync/FileState;", "parseMetaInfo", "Lcom/intellij/settingsSync/SettingsSnapshot$MetaInfo;", "path", "serialize", "", "snapshot", "zipCompressor", "Lcom/intellij/util/io/Compressor$Zip;", "serializeMetaInfo", "snapshotMetaInfo", "serializePlugins", "plugins", "serializeSettingsProviders", "settingsFromProviders", "serializeSettingsProviders$intellij_settingsSync", "serializeToStream", "stream", "Ljava/io/OutputStream;", "serializeToZip", "MetaInfo", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSnapshotZipSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSnapshotZipSerializer.kt\ncom/intellij/settingsSync/SettingsSnapshotZipSerializer\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n113#2:187\n96#3:188\n10#4:189\n*S KotlinDebug\n*F\n+ 1 SettingsSnapshotZipSerializer.kt\ncom/intellij/settingsSync/SettingsSnapshotZipSerializer\n*L\n87#1:187\n130#1:188\n30#1:189\n*E\n"})
public final class SettingsSnapshotZipSerializer {
    @NotNull
    public static final SettingsSnapshotZipSerializer INSTANCE = new SettingsSnapshotZipSerializer();
    @NotNull
    private static final String METAINFO = ".metainfo";
    @NotNull
    private static final String INFO = "info.json";
    @NotNull
    private static final String PLUGINS = "plugins.json";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Json json;

    private SettingsSnapshotZipSerializer() {
    }

    @NotNull
    public final Path serializeToZip(@NotNull SettingsSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        File file = FileUtil.createTempFile((String)"settings.sync.snapshot.zip", null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(SETTINGS_SYNC_SNAPSHOT_ZIP, null)");
        File file2 = file;
        this.serialize(snapshot, new Compressor.Zip(file2));
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
        return path;
    }

    public final void serializeToStream(@NotNull SettingsSnapshot snapshot, @NotNull OutputStream stream2) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)stream2, (String)"stream");
        this.serialize(snapshot, new Compressor.Zip(stream2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void serialize(SettingsSnapshot snapshot, Compressor.Zip zipCompressor) {
        Closeable closeable = (Closeable)zipCompressor;
        Throwable throwable = null;
        try {
            Compressor.Zip zip = (Compressor.Zip)closeable;
            boolean bl = false;
            zip.addFile(".metainfo/info.json", INSTANCE.serializeMetaInfo(snapshot.getMetaInfo()));
            if (snapshot.getPlugins() != null) {
                byte[] byArray = INSTANCE.serializePlugins(snapshot.getPlugins()).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                zip.addFile(".metainfo/plugins.json", byArray);
            }
            for (FileState fileState : snapshot.getFileStates()) {
                zip.addFile(fileState.getFile(), INSTANCE.getContentForFileState(fileState));
            }
            for (Map.Entry entry : INSTANCE.serializeSettingsProviders$intellij_settingsSync(snapshot.getSettingsFromProviders()).entrySet()) {
                String relativePath = (String)entry.getKey();
                String content = (String)entry.getValue();
                String string = ".metainfo/" + relativePath;
                byte[] byArray = content.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                zip.addFile(string, byArray);
            }
            for (FileState fileState : snapshot.getAdditionalFiles()) {
                zip.addFile(".metainfo/" + fileState.getFile(), INSTANCE.getContentForFileState(fileState));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Map<String, String> serializeSettingsProviders$intellij_settingsSync(@NotNull Map<String, ? extends Object> settingsFromProviders) {
        Intrinsics.checkNotNullParameter(settingsFromProviders, (String)"settingsFromProviders");
        Map pathsAndContents = new LinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry : settingsFromProviders.entrySet()) {
            Object state;
            String id = entry.getKey();
            SettingsProvider<Object> provider = SettingsSyncIdeMediatorImpl.Companion.findProviderById$intellij_settingsSync(id, state = entry.getValue());
            if (provider == null) continue;
            try {
                String string = provider.serialize(state);
                pathsAndContents.put(id + "/" + provider.getFileName(), string);
            }
            catch (Exception e) {
                LOG.error("Could not serialize provider '" + id + "' with " + state, (Throwable)e);
            }
        }
        return pathsAndContents;
    }

    private final byte[] getContentForFileState(FileState fileState) {
        byte[] byArray;
        if (fileState instanceof FileState.Modified) {
            byArray = ((FileState.Modified)fileState).getContent();
        } else {
            String string = "DELETED";
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        }
        return byArray;
    }

    private final String serializePlugins(SettingsSyncPluginsState plugins) {
        StringFormat $this$encodeToString$iv = (StringFormat)json;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)SettingsSyncPluginsState.Companion.serializer(), (Object)plugins);
    }

    @NotNull
    public final SettingsSnapshot extractFromZip(@NotNull Path zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Path tempDir = FileUtil.createTempDirectory((String)"settings.sync.updates", null).toPath();
        new Decompressor.Zip(zipFile).extract(tempDir);
        Intrinsics.checkNotNullExpressionValue((Object)tempDir, (String)"tempDir");
        Path path = tempDir.resolve(METAINFO);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        Path metaInfoFolder = path;
        SettingsSnapshot.MetaInfo metaInfo = this.parseMetaInfo(metaInfoFolder);
        Set fileStates2 = Files.walk(tempDir, new FileVisitOption[0]).filter(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$1((Function1)new Function1<Path, Boolean>(metaInfoFolder){
            final /* synthetic */ Path $metaInfoFolder;
            {
                this.$metaInfoFolder = $metaInfoFolder;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return PathKt.isFile((Path)it) && !PathKt.isAncestor((Path)this.$metaInfoFolder, (Path)it);
            }
        }, arg_0)).map(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$2((Function1)new Function1<Path, FileState>(tempDir){
            final /* synthetic */ Path $tempDir;
            {
                this.$tempDir = $tempDir;
                super(1);
            }

            public final FileState invoke(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Path path = this.$tempDir;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDir");
                return FileStateKt.getFileStateFromFileWithDeletedMarker(it, path);
            }
        }, arg_0)).collect(Collectors.toSet());
        Pair<Map<String, Object>, Set<Path>> pair = this.deserializeSettingsProviders$intellij_settingsSync(metaInfoFolder);
        Map settingsFromProviders = (Map)pair.component1();
        Set filesFromProviders = (Set)pair.component2();
        Set additionalFiles2 = Files.walk(metaInfoFolder, new FileVisitOption[0]).filter(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$3((Function1)new Function1<Path, Boolean>((Set<? extends Path>)filesFromProviders){
            final /* synthetic */ Set<Path> $filesFromProviders;
            {
                this.$filesFromProviders = $filesFromProviders;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return PathKt.isFile((Path)it) && !Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)"info.json") && !Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)"plugins.json") && !this.$filesFromProviders.contains(it);
            }
        }, arg_0)).map(arg_0 -> SettingsSnapshotZipSerializer.extractFromZip$lambda$4((Function1)new Function1<Path, FileState>(metaInfoFolder){
            final /* synthetic */ Path $metaInfoFolder;
            {
                this.$metaInfoFolder = $metaInfoFolder;
                super(1);
            }

            public final FileState invoke(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return FileStateKt.getFileStateFromFileWithDeletedMarker(it, this.$metaInfoFolder);
            }
        }, arg_0)).collect(Collectors.toSet());
        SettingsSyncPluginsState plugins = this.deserializePlugins(metaInfoFolder);
        Intrinsics.checkNotNullExpressionValue(fileStates2, (String)"fileStates");
        Intrinsics.checkNotNullExpressionValue(additionalFiles2, (String)"additionalFiles");
        return new SettingsSnapshot(metaInfo, fileStates2, plugins, settingsFromProviders, additionalFiles2);
    }

    @NotNull
    public final Pair<Map<String, Object>, Set<Path>> deserializeSettingsProviders$intellij_settingsSync(@NotNull Path containingFolder) {
        Intrinsics.checkNotNullParameter((Object)containingFolder, (String)"containingFolder");
        Map settingsFromProviders = new LinkedHashMap();
        Set filesFromProviders = new LinkedHashSet();
        SettingsProvider.Companion.getSETTINGS_PROVIDER_EP().forEachExtensionSafe(arg_0 -> SettingsSnapshotZipSerializer.deserializeSettingsProviders$lambda$5(containingFolder, settingsFromProviders, filesFromProviders, arg_0));
        return TuplesKt.to((Object)settingsFromProviders, (Object)filesFromProviders);
    }

    /*
     * WARNING - void declaration
     */
    private final SettingsSyncPluginsState deserializePlugins(Path metaInfoFolder) {
        Path path = metaInfoFolder.resolve(PLUGINS);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        Path pluginsFile = path;
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(pluginsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                void this_$iv;
                Json json2 = json;
                String string$iv = PathKt.readText((Path)pluginsFile);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (SettingsSyncPluginsState)this_$iv.decodeFromString((DeserializationStrategy)SettingsSyncPluginsState.Companion.serializer(), string$iv);
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to read " + pluginsFile, e);
        }
        return new SettingsSyncPluginsState(MapsKt.emptyMap());
    }

    private final byte[] serializeMetaInfo(SettingsSnapshot.MetaInfo snapshotMetaInfo) {
        String string;
        String string2;
        MetaInfo metaInfo;
        String formattedDate = DateTimeFormatter.ISO_INSTANT.format(snapshotMetaInfo.getDateCreated());
        MetaInfo $this$serializeMetaInfo_u24lambda_u246 = metaInfo = new MetaInfo();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)formattedDate, (String)"formattedDate");
        $this$serializeMetaInfo_u24lambda_u246.setDate(formattedDate);
        SettingsSnapshot.AppInfo appInfo = snapshotMetaInfo.getAppInfo();
        $this$serializeMetaInfo_u24lambda_u246.setApplicationId(String.valueOf(appInfo != null ? appInfo.getApplicationId() : null));
        SettingsSnapshot.AppInfo appInfo2 = snapshotMetaInfo.getAppInfo();
        String string3 = string2 = appInfo2 != null && (appInfo2 = appInfo2.getBuildNumber()) != null ? appInfo2.asString() : null;
        if (string3 == null) {
            string = "";
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"snapshotMetaInfo.appInfo\u2026ldNumber?.asString() ?:\"\"");
            string = string2;
        }
        $this$serializeMetaInfo_u24lambda_u246.setBuildNumber(string);
        SettingsSnapshot.AppInfo appInfo3 = snapshotMetaInfo.getAppInfo();
        $this$serializeMetaInfo_u24lambda_u246.setUserName(String.valueOf(appInfo3 != null ? appInfo3.getUserName() : null));
        SettingsSnapshot.AppInfo appInfo4 = snapshotMetaInfo.getAppInfo();
        $this$serializeMetaInfo_u24lambda_u246.setHostName(String.valueOf(appInfo4 != null ? appInfo4.getHostName() : null));
        SettingsSnapshot.AppInfo appInfo5 = snapshotMetaInfo.getAppInfo();
        $this$serializeMetaInfo_u24lambda_u246.setConfigFolder(String.valueOf(appInfo5 != null ? appInfo5.getConfigFolder() : null));
        $this$serializeMetaInfo_u24lambda_u246.setDeleted(snapshotMetaInfo.isDeleted());
        MetaInfo metaInfo2 = metaInfo;
        byte[] byArray = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)metaInfo2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ObjectMapper().writerWit\u2026iteValueAsBytes(metaInfo)");
        return byArray;
    }

    private final SettingsSnapshot.MetaInfo parseMetaInfo(Path path) {
        try {
            Path path2 = path.resolve(INFO);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
            Path infoFile = path2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(infoFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                MetaInfo metaInfo = (MetaInfo)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(PathKt.readText((Path)infoFile), MetaInfo.class);
                Instant date = DateTimeFormatter.ISO_INSTANT.parse((CharSequence)metaInfo.getDate(), Instant::from);
                UUID uUID = UUID.fromString(metaInfo.getApplicationId());
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(metaInfo.applicationId)");
                SettingsSnapshot.AppInfo appInfo = new SettingsSnapshot.AppInfo(uUID, BuildNumber.fromString((String)metaInfo.getBuildNumber()), metaInfo.getUserName(), metaInfo.getHostName(), metaInfo.getConfigFolder());
                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"date");
                return new SettingsSnapshot.MetaInfo(date, appInfo, metaInfo.isDeleted());
            }
            LOG.warn("Timestamp file doesn't exist");
        }
        catch (Throwable e) {
            LOG.error("Couldn't read .metainfo from settings.sync.snapshot.zip", e);
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return new SettingsSnapshot.MetaInfo(instant, null, false, 4, null);
    }

    private static final boolean extractFromZip$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final FileState extractFromZip$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileState)$tmp0.invoke(p0);
    }

    private static final boolean extractFromZip$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final FileState extractFromZip$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileState)$tmp0.invoke(p0);
    }

    private static final void deserializeSettingsProviders$lambda$5(Path $containingFolder, Map $settingsFromProviders, Set $filesFromProviders, SettingsProvider it) {
        Intrinsics.checkNotNullParameter((Object)$containingFolder, (String)"$containingFolder");
        Intrinsics.checkNotNullParameter((Object)$settingsFromProviders, (String)"$settingsFromProviders");
        Intrinsics.checkNotNullParameter((Object)$filesFromProviders, (String)"$filesFromProviders");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path file = $containingFolder.resolve(it.getId()).resolve(it.getFileName());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object state = it.deserialize(PathKt.readText((Path)file));
            $settingsFromProviders.put(it.getId(), state);
            $filesFromProviders.add(file);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSnapshotZipSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/settingsSync/SettingsSnapshotZipSerializer$MetaInfo;", "", "()V", "applicationId", "", "getApplicationId", "()Ljava/lang/String;", "setApplicationId", "(Ljava/lang/String;)V", "buildNumber", "getBuildNumber", "setBuildNumber", "configFolder", "getConfigFolder", "setConfigFolder", "date", "getDate", "setDate", "hostName", "getHostName", "setHostName", "isDeleted", "", "()Z", "setDeleted", "(Z)V", "userName", "getUserName", "setUserName", "intellij.settingsSync"})
    private static final class MetaInfo {
        public String date;
        public String applicationId;
        @NotNull
        private String buildNumber = "";
        @NotNull
        private String userName = "";
        @NotNull
        private String hostName = "";
        @NotNull
        private String configFolder = "";
        private boolean isDeleted;

        @NotNull
        public final String getDate() {
            String string = this.date;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"date");
            return null;
        }

        public final void setDate(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.date = string;
        }

        @NotNull
        public final String getApplicationId() {
            String string = this.applicationId;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
            return null;
        }

        public final void setApplicationId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.applicationId = string;
        }

        @NotNull
        public final String getBuildNumber() {
            return this.buildNumber;
        }

        public final void setBuildNumber(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.buildNumber = string;
        }

        @NotNull
        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.userName = string;
        }

        @NotNull
        public final String getHostName() {
            return this.hostName;
        }

        public final void setHostName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.hostName = string;
        }

        @NotNull
        public final String getConfigFolder() {
            return this.configFolder;
        }

        public final void setConfigFolder(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.configFolder = string;
        }

        public final boolean isDeleted() {
            return this.isDeleted;
        }

        public final void setDeleted(boolean bl) {
            this.isDeleted = bl;
        }
    }
}

