/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.AttributeFinder;
import org.intellij.plugins.relaxNG.model.descriptors.ChildElementFinder;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DPattern;

public class CompositeDescriptor
extends RngElementDescriptor {
    private final DElementPattern[] myPatterns;

    CompositeDescriptor(RngNsDescriptor nsDescriptor, DElementPattern pattern2, List<DElementPattern> patterns) {
        super(nsDescriptor, pattern2);
        this.myPatterns = ContainerUtil.reverse(patterns).toArray(new DElementPattern[patterns.size()]);
    }

    @Override
    protected XmlElementDescriptor findElementDescriptor(XmlTag childTag) {
        ArrayList<DElementPattern> patterns = new ArrayList<DElementPattern>();
        for (DElementPattern pattern2 : this.myPatterns) {
            patterns.addAll(ChildElementFinder.find(2, pattern2));
        }
        XmlElementDescriptor d = this.myNsDescriptor.findDescriptor(childTag, patterns);
        if (d != null) {
            return d;
        }
        return NULL;
    }

    @Override
    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        LinkedHashSet<XmlElementDescriptor> descriptors = new LinkedHashSet<XmlElementDescriptor>(Arrays.asList(super.getElementsDescriptors(context)));
        for (DElementPattern pattern2 : this.myPatterns) {
            List<DElementPattern> list = ChildElementFinder.find(2, pattern2);
            descriptors.addAll(Arrays.asList(this.myNsDescriptor.convertElementDescriptors(list)));
        }
        return descriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    @Override
    protected XmlAttributeDescriptor getAttributeDescriptor(String namespace, String localName) {
        QName qname = new QName(namespace, localName);
        return this.computeAttributeDescriptor(AttributeFinder.find(qname, (DPattern[])this.myPatterns));
    }

    @Override
    protected XmlAttributeDescriptor[] collectAttributeDescriptors(@Nullable XmlTag context) {
        return this.computeAttributeDescriptors(AttributeFinder.find(this.myPatterns));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompositeDescriptor that = (CompositeDescriptor)o;
        return Arrays.equals(this.myPatterns, that.myPatterns);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myPatterns);
        return result2;
    }

    public DElementPattern[] getElementPatterns() {
        return this.myPatterns;
    }
}

