/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.relaxng.output.common.XmlWriter;
import com.thaiopensource.relaxng.output.xsd.AbstractElementTypeSelector;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeComplexContentExtension;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeSelector;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeSimpleContentExtension;
import com.thaiopensource.relaxng.output.xsd.Guide;
import com.thaiopensource.relaxng.output.xsd.NamespaceManager;
import com.thaiopensource.relaxng.output.xsd.PrefixManager;
import com.thaiopensource.relaxng.output.xsd.basic.AbstractAttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.AbstractSchemaVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Annotated;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Comment;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeAllowedContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeNotAllowedContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.Facet;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Occurs;
import com.thaiopensource.relaxng.output.xsd.basic.OptionalAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.RootDeclaration;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaWalker;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeList;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Structure;
import com.thaiopensource.relaxng.output.xsd.basic.StructureVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class BasicOutput {
    private final XmlWriter xw;
    private final Schema schema;
    private final SimpleTypeOutput simpleTypeOutput = new SimpleTypeOutput();
    private final ComplexTypeOutput complexTypeOutput = new ComplexTypeOutput();
    private final AttributeUseOutput attributeUseOutput = new AttributeUseOutput();
    private final AttributeUseVisitor attributeWildcardOutput = new AttributeWildcardOutput();
    private final ParticleOutput particleOutput = new ParticleOutput();
    private final ParticleVisitor globalElementOutput = new GlobalElementOutput();
    private final GlobalAttributeOutput globalAttributeOutput = new GlobalAttributeOutput();
    private final SchemaVisitor schemaOutput = new SchemaOutput();
    private final StructureVisitor movedStructureOutput = new MovedStructureOutput();
    private final SimpleTypeVisitor simpleTypeNamer = new SimpleTypeNamer();
    private final NamespaceManager nsm;
    private final PrefixManager pm;
    private final String targetNamespace;
    private final OutputDirectory od;
    private final String sourceUri;
    private final ComplexTypeSelector complexTypeSelector;
    private final AbstractElementTypeSelector abstractElementTypeSelector;
    private final Set globalElementsDefined;
    private final Set globalAttributesDefined;
    private final String xsPrefix;
    private final Options options;
    private static final int NORMAL_CONTEXT = 0;
    private static final int COMPLEX_TYPE_CONTEXT = 1;
    private static final int NAMED_GROUP_CONTEXT = 2;

    static void output(Schema schema, Guide guide, PrefixManager prefixManager, OutputDirectory outputDirectory, Options options, ErrorReporter errorReporter) throws IOException {
        NamespaceManager namespaceManager = new NamespaceManager(schema, guide, prefixManager);
        ComplexTypeSelector complexTypeSelector = new ComplexTypeSelector(schema);
        AbstractElementTypeSelector abstractElementTypeSelector = new AbstractElementTypeSelector(schema, namespaceManager, complexTypeSelector);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        try {
            Iterator iterator = schema.getSubSchemas().iterator();
            while (iterator.hasNext()) {
                new BasicOutput((Schema)iterator.next(), errorReporter, outputDirectory, options, namespaceManager, prefixManager, complexTypeSelector, abstractElementTypeSelector, hashSet, hashSet2).output();
            }
        }
        catch (XmlWriter.WrappedException wrappedException) {
            throw wrappedException.getIOException();
        }
    }

    private BasicOutput(Schema schema, ErrorReporter errorReporter, OutputDirectory outputDirectory, Options options, NamespaceManager namespaceManager, PrefixManager prefixManager, ComplexTypeSelector complexTypeSelector, AbstractElementTypeSelector abstractElementTypeSelector, Set set, Set set2) throws IOException {
        this.schema = schema;
        this.nsm = namespaceManager;
        this.pm = prefixManager;
        this.complexTypeSelector = complexTypeSelector;
        this.abstractElementTypeSelector = abstractElementTypeSelector;
        this.globalElementsDefined = set;
        this.globalAttributesDefined = set2;
        this.sourceUri = schema.getUri();
        this.od = outputDirectory;
        this.targetNamespace = namespaceManager.getTargetNamespace(schema.getUri());
        this.xsPrefix = prefixManager.getPrefix("http://www.w3.org/2001/XMLSchema");
        this.options = options;
        OutputDirectory.Stream stream = outputDirectory.open(schema.getUri(), schema.getEncoding());
        this.xw = new XmlWriter(stream.getWriter(), stream.getEncoding(), stream.getCharRepertoire(), outputDirectory.getLineSeparator(), outputDirectory.getIndent(), new String[0]);
    }

    private String topLevelPrefix(String string2) {
        if (!this.nsm.isTargetNamespace(string2)) {
            return null;
        }
        if (string2.equals("")) {
            return "";
        }
        return this.pm.getPrefix(string2);
    }

    private void output() {
        Object object;
        Object object2;
        Object object3;
        this.outputCommentList(this.schema.getLeadingComments());
        this.xw.startElement(this.xs("schema"));
        this.xw.attribute("xmlns:" + this.xsPrefix, "http://www.w3.org/2001/XMLSchema");
        this.xw.attribute("elementFormDefault", "qualified");
        if (!this.targetNamespace.equals("")) {
            this.xw.attribute("targetNamespace", this.targetNamespace);
        }
        Iterator iterator = this.nsm.getTargetNamespaces().iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            if (((String)object3).equals("") || ((String)(object2 = this.pm.getPrefix((String)object3))).equals("xml")) continue;
            this.xw.attribute("xmlns:" + this.pm.getPrefix((String)object3), (String)object3);
        }
        object3 = this.nsm.effectiveIncludes(this.schema.getUri()).iterator();
        while (object3.hasNext()) {
            this.outputInclude((String)object3.next());
        }
        object2 = new Vector();
        object2.addAll(this.nsm.getTargetNamespaces());
        Collections.sort(object2);
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            object = (String)iterator2.next();
            if (((String)object).equals(this.targetNamespace)) continue;
            this.outputImport((String)object, this.nsm.getRootSchema((String)object));
        }
        this.schema.accept(this.schemaOutput);
        if (this.nsm.getRootSchema(this.targetNamespace).equals(this.sourceUri)) {
            object = this.nsm.getMovedStructures(this.targetNamespace).iterator();
            while (object.hasNext()) {
                ((Structure)object.next()).accept(this.movedStructureOutput);
            }
            this.outputOther();
        }
        this.xw.endElement();
        this.outputCommentList(this.schema.getTrailingComments());
        this.xw.close();
    }

    private String xs(String string2) {
        return this.xsPrefix + ":" + string2;
    }

    private boolean namespaceIsLocal(String string2) {
        return string2.equals(this.targetNamespace) || string2.equals("");
    }

    private void outputAttributeUse(AttributeUse attributeUse) {
        attributeUse.accept(this.attributeUseOutput);
        attributeUse.accept(this.attributeWildcardOutput);
    }

    private void namespaceAttribute(Wildcard wildcard) {
        if (wildcard.isPositive()) {
            StringBuffer stringBuffer = new StringBuffer();
            Vector vector = new Vector(wildcard.getNamespaces());
            Collections.sort(vector);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String string2;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                if ((string2 = (String)iterator.next()).equals("")) {
                    stringBuffer.append("##local");
                    continue;
                }
                if (string2.equals(this.targetNamespace)) {
                    stringBuffer.append("##targetNamespace");
                    continue;
                }
                stringBuffer.append(string2);
            }
            this.xw.attribute("namespace", stringBuffer.toString());
        } else if (this.targetNamespace.equals(NamespaceManager.otherNamespace(wildcard))) {
            this.xw.attribute("namespace", "##other");
        }
    }

    private String qualifyRef(String string2, String string3) {
        return this.qualifyName(this.nsm.getTargetNamespace(string2), string3);
    }

    private String qualifyName(Name name) {
        return this.qualifyName(name.getNamespaceUri(), name.getLocalName());
    }

    private String qualifyName(String string2, String string3) {
        if (string2.equals("")) {
            return string3;
        }
        return this.pm.getPrefix(string2) + ":" + string3;
    }

    private void outputOther() {
        String string2 = this.nsm.getOtherElementName(this.targetNamespace);
        if (string2 != null) {
            this.xw.startElement(this.xs("group"));
            this.xw.attribute("name", string2);
            this.xw.startElement(this.xs("sequence"));
            this.xw.startElement(this.xs("any"));
            this.xw.attribute("namespace", "##other");
            this.xw.attribute("processContents", this.options.anyProcessContents);
            this.xw.endElement();
            this.xw.endElement();
            this.xw.endElement();
        }
        if ((string2 = this.nsm.getOtherAttributeName(this.targetNamespace)) != null) {
            this.xw.startElement(this.xs("attributeGroup"));
            this.xw.attribute("name", string2);
            this.xw.startElement(this.xs("anyAttribute"));
            this.xw.attribute("namespace", "##other");
            this.xw.attribute("processContents", this.options.anyAttributeProcessContents);
            this.xw.endElement();
            this.xw.endElement();
        }
    }

    private void outputInclude(String string2) {
        this.xw.startElement(this.xs("include"));
        this.xw.attribute("schemaLocation", this.od.reference(this.sourceUri, string2));
        this.xw.endElement();
    }

    private void outputImport(String string2, String string3) {
        this.xw.startElement(this.xs("import"));
        if (!string2.equals("")) {
            this.xw.attribute("namespace", string2);
        }
        this.xw.attribute("schemaLocation", this.od.reference(this.sourceUri, string3));
        this.xw.endElement();
    }

    private void outputComplexTypeComplexContent(ComplexTypeComplexContentExtension complexTypeComplexContentExtension, String string2, Annotated annotated) {
        String string3 = complexTypeComplexContentExtension.getBase();
        if (string3 != null) {
            string3 = this.qualifyRef(this.schema.getGroup(string3).getParentSchema().getUri(), string3);
            if (string2 == null && complexTypeComplexContentExtension.getParticle() == null && !complexTypeComplexContentExtension.isMixed() && complexTypeComplexContentExtension.getAttributeUses().equals(AttributeGroup.EMPTY)) {
                this.xw.attribute("type", string3);
                if (annotated != null) {
                    this.outputAnnotation(annotated);
                }
                return;
            }
        }
        if (string2 == null && annotated != null) {
            this.outputAnnotation(annotated);
        }
        this.xw.startElement(this.xs("complexType"));
        if (string2 != null) {
            this.xw.attribute("name", string2);
        }
        if (complexTypeComplexContentExtension.isMixed()) {
            this.xw.attribute("mixed", "true");
        }
        if (string2 != null && annotated != null) {
            this.outputAnnotation(annotated);
        }
        if (string3 != null) {
            this.xw.startElement(this.xs("complexContent"));
            this.xw.startElement(this.xs("extension"));
            this.xw.attribute("base", string3);
        }
        if (complexTypeComplexContentExtension.getParticle() != null) {
            this.particleOutput.context = 1;
            complexTypeComplexContentExtension.getParticle().accept(this.particleOutput);
        }
        this.outputAttributeUse(complexTypeComplexContentExtension.getAttributeUses());
        if (string3 != null) {
            this.xw.endElement();
            this.xw.endElement();
        }
        this.xw.endElement();
    }

    private void outputComplexTypeSimpleContent(ComplexTypeSimpleContentExtension complexTypeSimpleContentExtension, String string2, Annotated annotated) {
        String string3 = complexTypeSimpleContentExtension.getBase();
        AttributeUse attributeUse = complexTypeSimpleContentExtension.getAttributeUses();
        if (string3 != null) {
            string3 = this.qualifyRef(this.schema.getSimpleType(string3).getParentSchema().getUri(), string3);
            if (string2 == null && attributeUse.equals(AttributeGroup.EMPTY)) {
                this.xw.attribute("type", string3);
                if (annotated != null) {
                    this.outputAnnotation(annotated);
                }
                return;
            }
        } else if (attributeUse.equals(AttributeGroup.EMPTY)) {
            this.simpleTypeOutput.outputWrap(complexTypeSimpleContentExtension.getSimpleType(), annotated);
            return;
        }
        if (string2 == null && annotated != null) {
            this.outputAnnotation(annotated);
        }
        this.xw.startElement(this.xs("complexType"));
        if (string2 != null) {
            this.xw.attribute("name", string2);
        }
        if (string2 != null && annotated != null) {
            this.outputAnnotation(annotated);
        }
        this.xw.startElement(this.xs("simpleContent"));
        if (string3 == null) {
            string3 = (String)complexTypeSimpleContentExtension.getSimpleType().accept(this.simpleTypeNamer);
        }
        if (string3 != null) {
            this.xw.startElement(this.xs("extension"));
            this.xw.attribute("base", string3);
        } else {
            this.xw.startElement(this.xs("restriction"));
            this.xw.attribute("base", this.xs("anyType"));
            this.simpleTypeOutput.outputWrap(complexTypeSimpleContentExtension.getSimpleType(), null);
        }
        this.outputAttributeUse(attributeUse);
        this.xw.endElement();
        this.xw.endElement();
        this.xw.endElement();
    }

    private void outputComplexType(Name name, ComplexType complexType, Annotated annotated) {
        Name name2 = this.nsm.getSubstitutionGroup(name);
        if (name2 != null) {
            this.xw.attribute("substitutionGroup", this.qualifyName(name2));
            if (complexType != null && complexType.equals(this.abstractElementTypeSelector.getAbstractElementType(name2))) {
                complexType = null;
            }
        }
        if (complexType != null) {
            if (complexType instanceof ComplexTypeNotAllowedContent) {
                this.xw.attribute("abstract", "true");
                this.outputAnnotation(annotated);
            } else {
                this.complexTypeOutput.parent = annotated;
                complexType.accept(this.complexTypeOutput);
            }
        } else {
            this.outputAnnotation(annotated);
        }
    }

    private void outputAnnotation(Annotated annotated) {
        Annotation annotation = annotated.getAnnotation();
        if (annotation == null) {
            return;
        }
        this.xw.startElement(this.xs("annotation"));
        String string2 = annotation.getDocumentation();
        if (string2 != null) {
            this.xw.startElement(this.xs("documentation"));
            this.xw.text(string2);
            this.xw.endElement();
        }
        this.xw.endElement();
    }

    private void outputCommentList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.xw.comment(((Comment)iterator.next()).getContent());
        }
    }

    class MovedStructureOutput
    implements StructureVisitor {
        MovedStructureOutput() {
        }

        public Object visitElement(Element element) {
            if (!BasicOutput.this.nsm.isGlobal(element)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("group"));
                BasicOutput.this.xw.attribute("name", BasicOutput.this.nsm.getProxyName(element));
                BasicOutput.this.particleOutput.context = 2;
                BasicOutput.this.particleOutput.visitElement(element);
                BasicOutput.this.xw.endElement();
            }
            BasicOutput.this.globalElementOutput.visitElement(element);
            return null;
        }

        public Object visitAttribute(Attribute attribute) {
            if (!BasicOutput.this.nsm.isGlobal(attribute)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
                BasicOutput.this.xw.attribute("name", BasicOutput.this.nsm.getProxyName(attribute));
                BasicOutput.this.attributeUseOutput.visitAttribute(attribute);
                BasicOutput.this.xw.endElement();
            }
            BasicOutput.this.globalAttributeOutput.visitAttribute(attribute);
            return null;
        }
    }

    class SchemaOutput
    extends AbstractSchemaVisitor {
        SchemaOutput() {
        }

        public void visitGroup(GroupDefinition groupDefinition) {
            Particle particle = groupDefinition.getParticle();
            ComplexTypeComplexContentExtension complexTypeComplexContentExtension = BasicOutput.this.complexTypeSelector.createComplexTypeForGroup(groupDefinition.getName(), BasicOutput.this.nsm);
            if (complexTypeComplexContentExtension != null) {
                GroupDefinition groupDefinition2 = this.tryAbstractElement(groupDefinition) ? null : groupDefinition;
                BasicOutput.this.outputComplexTypeComplexContent(complexTypeComplexContentExtension, groupDefinition.getName(), groupDefinition2);
            } else if (!(BasicOutput.this.nsm.isGroupDefinitionOmitted(groupDefinition) || this.tryAbstractElement(groupDefinition) || this.tryElementChoiceSameType(groupDefinition))) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("group"));
                BasicOutput.this.xw.attribute("name", groupDefinition.getName());
                BasicOutput.this.outputAnnotation(groupDefinition);
                BasicOutput.this.particleOutput.context = 2;
                particle.accept(BasicOutput.this.particleOutput);
                BasicOutput.this.xw.endElement();
            }
            particle.accept(BasicOutput.this.globalElementOutput);
        }

        private boolean tryAbstractElement(GroupDefinition groupDefinition) {
            Name name = BasicOutput.this.nsm.getGroupDefinitionAbstractElementName(groupDefinition);
            if (name == null) {
                return false;
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
            BasicOutput.this.xw.attribute("name", name.getLocalName());
            BasicOutput.this.xw.attribute("abstract", "true");
            BasicOutput.this.outputComplexType(name, BasicOutput.this.abstractElementTypeSelector.getAbstractElementType(name), groupDefinition);
            BasicOutput.this.xw.endElement();
            return true;
        }

        private boolean tryElementChoiceSameType(GroupDefinition groupDefinition) {
            Object object;
            Particle particle = groupDefinition.getParticle();
            if (!(particle instanceof ParticleChoice)) {
                return false;
            }
            List list = ((ParticleChoice)particle).getChildren();
            if (list.size() <= 1) {
                return false;
            }
            Iterator iterator = list.iterator();
            Particle particle2 = (Particle)iterator.next();
            if (!(particle2 instanceof Element)) {
                return false;
            }
            if (!((Element)particle2).getName().getNamespaceUri().equals(BasicOutput.this.targetNamespace)) {
                return false;
            }
            ComplexType complexType = ((Element)particle2).getComplexType();
            do {
                if (!((object = (Particle)iterator.next()) instanceof Element)) {
                    return false;
                }
                if (!((Element)object).getComplexType().equals(complexType)) {
                    return false;
                }
                if (((Element)object).getName().getNamespaceUri().equals(BasicOutput.this.targetNamespace)) continue;
                return false;
            } while (iterator.hasNext());
            if (complexType instanceof ComplexTypeComplexContent) {
                object = BasicOutput.this.complexTypeSelector.transformComplexContent((ComplexTypeComplexContent)complexType);
                if (((ComplexTypeComplexContentExtension)object).getBase() != null && ((ComplexTypeComplexContent)object).getParticle() == null && !((ComplexTypeComplexContent)object).isMixed() && ((ComplexTypeAllowedContent)object).getAttributeUses().equals(AttributeGroup.EMPTY)) {
                    return false;
                }
                BasicOutput.this.outputComplexTypeComplexContent((ComplexTypeComplexContentExtension)object, groupDefinition.getName(), null);
            } else {
                object = BasicOutput.this.complexTypeSelector.transformSimpleContent((ComplexTypeSimpleContent)complexType);
                if (((ComplexTypeAllowedContent)object).getAttributeUses().equals(AttributeGroup.EMPTY) && (((ComplexTypeSimpleContentExtension)object).getBase() != null || ((ComplexTypeSimpleContent)object).getSimpleType().accept(BasicOutput.this.simpleTypeNamer) != null)) {
                    return false;
                }
                BasicOutput.this.outputComplexTypeSimpleContent((ComplexTypeSimpleContentExtension)object, groupDefinition.getName(), null);
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("group"));
            BasicOutput.this.xw.attribute("name", groupDefinition.getName());
            BasicOutput.this.outputAnnotation(groupDefinition);
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("choice"));
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (Element)iterator.next();
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
                if (BasicOutput.this.nsm.isGlobal((Element)object)) {
                    BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(((Element)object).getName()));
                } else {
                    BasicOutput.this.xw.attribute("name", ((Element)object).getName().getLocalName());
                    BasicOutput.this.xw.attribute("type", groupDefinition.getName());
                    BasicOutput.this.outputAnnotation((Annotated)object);
                }
                BasicOutput.this.xw.endElement();
            }
            BasicOutput.this.xw.endElement();
            BasicOutput.this.xw.endElement();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (Element)iterator.next();
                if (!BasicOutput.this.nsm.isGlobal((Element)object) || BasicOutput.this.globalElementsDefined.contains(((Element)object).getName())) continue;
                BasicOutput.this.globalElementsDefined.add(((Element)object).getName());
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
                BasicOutput.this.xw.attribute("name", ((Element)object).getName().getLocalName());
                BasicOutput.this.xw.attribute("type", groupDefinition.getName());
                BasicOutput.this.outputAnnotation((Annotated)object);
                BasicOutput.this.xw.endElement();
            }
            return true;
        }

        public void visitSimpleType(SimpleTypeDefinition simpleTypeDefinition) {
            ComplexTypeSimpleContentExtension complexTypeSimpleContentExtension = BasicOutput.this.complexTypeSelector.createComplexTypeForSimpleType(simpleTypeDefinition.getName());
            if (complexTypeSimpleContentExtension != null) {
                BasicOutput.this.outputComplexTypeSimpleContent(complexTypeSimpleContentExtension, simpleTypeDefinition.getName(), simpleTypeDefinition);
            } else {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("simpleType"));
                BasicOutput.this.xw.attribute("name", simpleTypeDefinition.getName());
                BasicOutput.this.outputAnnotation(simpleTypeDefinition);
                simpleTypeDefinition.getSimpleType().accept(BasicOutput.this.simpleTypeOutput);
                BasicOutput.this.xw.endElement();
            }
        }

        public void visitAttributeGroup(AttributeGroupDefinition attributeGroupDefinition) {
            if (BasicOutput.this.complexTypeSelector.isComplexType(attributeGroupDefinition.getName())) {
                return;
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
            BasicOutput.this.xw.attribute("name", attributeGroupDefinition.getName());
            BasicOutput.this.outputAnnotation(attributeGroupDefinition);
            BasicOutput.this.outputAttributeUse(attributeGroupDefinition.getAttributeUses());
            BasicOutput.this.xw.endElement();
            attributeGroupDefinition.getAttributeUses().accept(BasicOutput.this.globalAttributeOutput);
        }

        public void visitRoot(RootDeclaration rootDeclaration) {
            rootDeclaration.getParticle().accept(BasicOutput.this.globalElementOutput);
        }

        public void visitComment(Comment comment) {
            BasicOutput.this.xw.comment(comment.getContent());
        }
    }

    class GlobalAttributeOutput
    extends AbstractAttributeUseVisitor {
        GlobalAttributeOutput() {
        }

        public Object visitAttributeGroup(AttributeGroup attributeGroup) {
            Iterator iterator = attributeGroup.getChildren().iterator();
            while (iterator.hasNext()) {
                ((AttributeUse)iterator.next()).accept(this);
            }
            return null;
        }

        public Object visitAttribute(Attribute attribute) {
            Name name = attribute.getName();
            if (BasicOutput.this.nsm.isGlobal(attribute) && name.getNamespaceUri().equals(BasicOutput.this.targetNamespace) && !BasicOutput.this.globalAttributesDefined.contains(name)) {
                BasicOutput.this.globalAttributesDefined.add(name);
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attribute"));
                BasicOutput.this.xw.attribute("name", name.getLocalName());
                if (attribute.getType() != null) {
                    BasicOutput.this.simpleTypeOutput.outputWrap(attribute.getType(), attribute);
                }
                BasicOutput.this.xw.endElement();
            }
            return null;
        }

        public Object visitOptionalAttribute(OptionalAttribute optionalAttribute) {
            return optionalAttribute.getAttribute().accept(this);
        }

        public Object visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            return null;
        }

        public Object visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            return null;
        }
    }

    class GlobalElementOutput
    implements ParticleVisitor,
    ComplexTypeVisitor {
        GlobalElementOutput() {
        }

        public Object visitElement(Element element) {
            Name name = element.getName();
            if (BasicOutput.this.nsm.isGlobal(element) && name.getNamespaceUri().equals(BasicOutput.this.targetNamespace) && !BasicOutput.this.globalElementsDefined.contains(name)) {
                BasicOutput.this.globalElementsDefined.add(name);
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
                BasicOutput.this.xw.attribute("name", name.getLocalName());
                BasicOutput.this.outputComplexType(name, element.getComplexType(), element);
                BasicOutput.this.xw.endElement();
            }
            return element.getComplexType().accept(this);
        }

        public Object visitRepeat(ParticleRepeat particleRepeat) {
            return particleRepeat.getChild().accept(this);
        }

        void visitList(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((Particle)iterator.next()).accept(this);
            }
        }

        public Object visitSequence(ParticleSequence particleSequence) {
            this.visitList(particleSequence.getChildren());
            return null;
        }

        public Object visitChoice(ParticleChoice particleChoice) {
            this.visitList(particleChoice.getChildren());
            return null;
        }

        public Object visitAll(ParticleAll particleAll) {
            this.visitList(particleAll.getChildren());
            return null;
        }

        public Object visitGroupRef(GroupRef groupRef) {
            return null;
        }

        public Object visitWildcardElement(WildcardElement wildcardElement) {
            return null;
        }

        public Object visitComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
            if (complexTypeComplexContent.getParticle() == null) {
                return null;
            }
            return complexTypeComplexContent.getParticle().accept(this);
        }

        public Object visitSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
            return null;
        }

        public Object visitNotAllowedContent(ComplexTypeNotAllowedContent complexTypeNotAllowedContent) {
            return null;
        }
    }

    class AttributeWildcardOutput
    extends SchemaWalker {
        AttributeWildcardOutput() {
        }

        public Object visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            String string2 = NamespaceManager.otherNamespace(wildcardAttribute.getWildcard());
            if (string2 != null && !string2.equals(BasicOutput.this.targetNamespace)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(string2, BasicOutput.this.nsm.getOtherAttributeName(string2)));
                BasicOutput.this.xw.endElement();
            } else {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("anyAttribute"));
                BasicOutput.this.namespaceAttribute(wildcardAttribute.getWildcard());
                BasicOutput.this.xw.attribute("processContents", ((BasicOutput)BasicOutput.this).options.anyAttributeProcessContents);
                BasicOutput.this.xw.endElement();
            }
            return null;
        }
    }

    class AttributeUseOutput
    extends SchemaWalker {
        boolean isOptional = false;
        String defaultValue = null;

        AttributeUseOutput() {
        }

        public Object visitOptionalAttribute(OptionalAttribute optionalAttribute) {
            this.isOptional = true;
            this.defaultValue = optionalAttribute.getDefaultValue();
            optionalAttribute.getAttribute().accept(this);
            this.isOptional = false;
            this.defaultValue = null;
            return null;
        }

        public Object visitAttribute(Attribute attribute) {
            if (BasicOutput.this.nsm.isGlobal(attribute)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attribute"));
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(attribute.getName()));
                if (!this.isOptional) {
                    BasicOutput.this.xw.attribute("use", "required");
                } else if (this.defaultValue != null) {
                    BasicOutput.this.xw.attribute("default", this.defaultValue);
                }
                BasicOutput.this.xw.endElement();
            } else if (BasicOutput.this.namespaceIsLocal(attribute.getName().getNamespaceUri())) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attribute"));
                BasicOutput.this.xw.attribute("name", attribute.getName().getLocalName());
                if (!this.isOptional) {
                    BasicOutput.this.xw.attribute("use", "required");
                } else if (this.defaultValue != null) {
                    BasicOutput.this.xw.attribute("default", this.defaultValue);
                }
                if (!attribute.getName().getNamespaceUri().equals("")) {
                    BasicOutput.this.xw.attribute("form", "qualified");
                }
                if (attribute.getType() != null) {
                    BasicOutput.this.simpleTypeOutput.outputWrap(attribute.getType(), attribute);
                } else {
                    BasicOutput.this.outputAnnotation(attribute);
                }
                BasicOutput.this.xw.endElement();
            } else {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(attribute.getName().getNamespaceUri(), BasicOutput.this.nsm.getProxyName(attribute)));
                BasicOutput.this.xw.endElement();
            }
            return null;
        }

        public Object visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
            String string2 = attributeGroupRef.getName();
            BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyRef(BasicOutput.this.schema.getAttributeGroup(string2).getParentSchema().getUri(), string2));
            BasicOutput.this.xw.endElement();
            return null;
        }
    }

    class ComplexTypeOutput
    implements ComplexTypeVisitor {
        Annotated parent;

        ComplexTypeOutput() {
        }

        public Object visitComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
            BasicOutput.this.outputComplexTypeComplexContent(BasicOutput.this.complexTypeSelector.transformComplexContent(complexTypeComplexContent), null, this.parent);
            return null;
        }

        public Object visitSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
            BasicOutput.this.outputComplexTypeSimpleContent(BasicOutput.this.complexTypeSelector.transformSimpleContent(complexTypeSimpleContent), null, this.parent);
            return null;
        }

        public Object visitNotAllowedContent(ComplexTypeNotAllowedContent complexTypeNotAllowedContent) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("complexType"));
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("choice"));
            BasicOutput.this.xw.endElement();
            BasicOutput.this.xw.endElement();
            return null;
        }
    }

    class ParticleOutput
    implements ParticleVisitor {
        private Occurs occ = Occurs.EXACTLY_ONE;
        private int context = 0;

        ParticleOutput() {
        }

        private boolean startWrapperForElement() {
            boolean bl = this.context >= 1;
            this.context = 0;
            if (bl) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("sequence"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
            this.outputOccurAttributes();
            return bl;
        }

        private boolean startWrapperForAny() {
            boolean bl = this.context >= 1;
            this.context = 0;
            if (bl) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("sequence"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("any"));
            this.outputOccurAttributes();
            return bl;
        }

        private boolean startWrapperForGroupRef() {
            boolean bl = this.context == 2;
            this.context = 0;
            if (bl) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("sequence"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("group"));
            this.outputOccurAttributes();
            return bl;
        }

        private boolean startWrapperForGroup(String string2) {
            boolean bl = this.context == 2 && !this.occ.equals(Occurs.EXACTLY_ONE);
            this.context = 0;
            if (bl) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("sequence"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs(string2));
            this.outputOccurAttributes();
            return bl;
        }

        private void endWrapper(boolean bl) {
            BasicOutput.this.xw.endElement();
            if (bl) {
                BasicOutput.this.xw.endElement();
            }
        }

        public Object visitElement(Element element) {
            boolean bl;
            if (BasicOutput.this.nsm.isGlobal(element)) {
                bl = this.startWrapperForElement();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(element.getName()));
            } else if (!BasicOutput.this.namespaceIsLocal(element.getName().getNamespaceUri())) {
                bl = this.startWrapperForGroupRef();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(element.getName().getNamespaceUri(), BasicOutput.this.nsm.getProxyName(element)));
            } else {
                bl = this.startWrapperForElement();
                BasicOutput.this.xw.attribute("name", element.getName().getLocalName());
                if (!element.getName().getNamespaceUri().equals(BasicOutput.this.targetNamespace)) {
                    BasicOutput.this.xw.attribute("form", "unqualified");
                }
                ((BasicOutput)BasicOutput.this).complexTypeOutput.parent = element;
                element.getComplexType().accept(BasicOutput.this.complexTypeOutput);
            }
            this.endWrapper(bl);
            return null;
        }

        public Object visitWildcardElement(WildcardElement wildcardElement) {
            boolean bl;
            String string2 = NamespaceManager.otherNamespace(wildcardElement.getWildcard());
            if (string2 != null && !string2.equals(BasicOutput.this.targetNamespace)) {
                bl = this.startWrapperForGroupRef();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(string2, BasicOutput.this.nsm.getOtherElementName(string2)));
            } else {
                bl = this.startWrapperForAny();
                BasicOutput.this.namespaceAttribute(wildcardElement.getWildcard());
                BasicOutput.this.xw.attribute("processContents", ((BasicOutput)BasicOutput.this).options.anyProcessContents);
                BasicOutput.this.outputAnnotation(wildcardElement);
            }
            this.endWrapper(bl);
            return null;
        }

        public Object visitRepeat(ParticleRepeat particleRepeat) {
            this.occ = Occurs.multiply(this.occ, particleRepeat.getOccurs());
            particleRepeat.getChild().accept(this);
            return null;
        }

        public Object visitSequence(ParticleSequence particleSequence) {
            boolean bl = this.startWrapperForGroup("sequence");
            BasicOutput.this.outputAnnotation(particleSequence);
            this.outputParticles(particleSequence.getChildren());
            this.endWrapper(bl);
            return null;
        }

        public Object visitChoice(ParticleChoice particleChoice) {
            boolean bl = this.startWrapperForGroup("choice");
            BasicOutput.this.outputAnnotation(particleChoice);
            this.outputParticles(particleChoice.getChildren());
            this.endWrapper(bl);
            return null;
        }

        public Object visitAll(ParticleAll particleAll) {
            boolean bl = this.startWrapperForGroup("all");
            BasicOutput.this.outputAnnotation(particleAll);
            this.outputParticles(particleAll.getChildren());
            this.endWrapper(bl);
            return null;
        }

        private void outputParticles(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((Particle)iterator.next()).accept(this);
            }
        }

        public Object visitGroupRef(GroupRef groupRef) {
            boolean bl;
            String string2 = groupRef.getName();
            GroupDefinition groupDefinition = BasicOutput.this.schema.getGroup(string2);
            Name name = BasicOutput.this.nsm.getElementNameForGroupRef(groupDefinition);
            if (name != null) {
                bl = this.startWrapperForElement();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(name));
            } else {
                bl = this.startWrapperForGroupRef();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyRef(groupDefinition.getParentSchema().getUri(), string2));
            }
            BasicOutput.this.outputAnnotation(groupRef);
            this.endWrapper(bl);
            return null;
        }

        void outputOccurAttributes() {
            if (this.occ.getMin() != 1) {
                BasicOutput.this.xw.attribute("minOccurs", Integer.toString(this.occ.getMin()));
            }
            if (this.occ.getMax() != 1) {
                BasicOutput.this.xw.attribute("maxOccurs", this.occ.getMax() == Integer.MAX_VALUE ? "unbounded" : Integer.toString(this.occ.getMax()));
            }
            this.occ = Occurs.EXACTLY_ONE;
        }
    }

    class SimpleTypeNamer
    implements SimpleTypeVisitor {
        SimpleTypeNamer() {
        }

        public Object visitRestriction(SimpleTypeRestriction simpleTypeRestriction) {
            if (simpleTypeRestriction.getFacets().size() > 0) {
                return null;
            }
            if (simpleTypeRestriction.getAnnotation() != null) {
                return null;
            }
            return BasicOutput.this.xs(simpleTypeRestriction.getName());
        }

        public Object visitRef(SimpleTypeRef simpleTypeRef) {
            if (simpleTypeRef.getAnnotation() != null) {
                return null;
            }
            return BasicOutput.this.qualifyRef(BasicOutput.this.schema.getSimpleType(simpleTypeRef.getName()).getParentSchema().getUri(), simpleTypeRef.getName());
        }

        public Object visitList(SimpleTypeList simpleTypeList) {
            return null;
        }

        public Object visitUnion(SimpleTypeUnion simpleTypeUnion) {
            return null;
        }
    }

    class SimpleTypeOutput
    implements SimpleTypeVisitor {
        SimpleTypeOutput() {
        }

        public Object visitRestriction(SimpleTypeRestriction simpleTypeRestriction) {
            Object object;
            boolean bl = false;
            Iterator iterator = simpleTypeRestriction.getFacets().iterator();
            while (iterator.hasNext()) {
                if (!((Facet)iterator.next()).getName().equals("pattern")) continue;
                if (!bl) {
                    bl = true;
                    continue;
                }
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("restriction"));
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("simpleType"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("restriction"));
            BasicOutput.this.xw.attribute("base", BasicOutput.this.xs(simpleTypeRestriction.getName()));
            bl = false;
            Iterator iterator2 = simpleTypeRestriction.getFacets().iterator();
            while (iterator2.hasNext()) {
                object = (Facet)iterator2.next();
                if (((Facet)object).getName().equals("pattern")) {
                    if (bl) continue;
                    bl = true;
                    this.outputFacet((Facet)object);
                    continue;
                }
                this.outputFacet((Facet)object);
            }
            BasicOutput.this.xw.endElement();
            bl = false;
            object = simpleTypeRestriction.getFacets().iterator();
            while (object.hasNext()) {
                Facet facet = (Facet)object.next();
                if (!facet.getName().equals("pattern")) continue;
                if (!bl) {
                    bl = true;
                    continue;
                }
                BasicOutput.this.xw.endElement();
                this.outputFacet(facet);
                BasicOutput.this.xw.endElement();
            }
            return null;
        }

        private void outputFacet(Facet facet) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs(facet.getName()));
            BasicOutput.this.xw.attribute("value", facet.getValue());
            String string2 = facet.getPrefix();
            if (string2 != null && !string2.equals(BasicOutput.this.topLevelPrefix(facet.getNamespace()))) {
                BasicOutput.this.xw.attribute(string2.equals("") ? "xmlns" : "xmlns:" + string2, facet.getNamespace());
            }
            BasicOutput.this.outputAnnotation(facet);
            BasicOutput.this.xw.endElement();
        }

        public Object visitRef(SimpleTypeRef simpleTypeRef) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("restriction"));
            BasicOutput.this.xw.attribute("base", BasicOutput.this.qualifyRef(BasicOutput.this.schema.getSimpleType(simpleTypeRef.getName()).getParentSchema().getUri(), simpleTypeRef.getName()));
            BasicOutput.this.xw.endElement();
            return null;
        }

        public Object visitUnion(SimpleTypeUnion simpleTypeUnion) {
            Object object;
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("union"));
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = simpleTypeUnion.getChildren().iterator();
            while (iterator.hasNext()) {
                object = (String)((SimpleType)iterator.next()).accept(BasicOutput.this.simpleTypeNamer);
                if (object == null) continue;
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append((String)object);
            }
            if (stringBuffer.length() != 0) {
                BasicOutput.this.xw.attribute("memberTypes", stringBuffer.toString());
            }
            BasicOutput.this.outputAnnotation(simpleTypeUnion);
            object = simpleTypeUnion.getChildren().iterator();
            while (object.hasNext()) {
                SimpleType simpleType = (SimpleType)object.next();
                if (simpleType.accept(BasicOutput.this.simpleTypeNamer) != null) continue;
                this.outputWrap(simpleType, null);
            }
            BasicOutput.this.xw.endElement();
            return null;
        }

        public Object visitList(SimpleTypeList simpleTypeList) {
            Occurs occurs = simpleTypeList.getOccurs();
            if (!occurs.equals(Occurs.ZERO_OR_MORE)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("restriction"));
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("simpleType"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("list"));
            this.outputWrap(simpleTypeList.getItemType(), "itemType", simpleTypeList);
            BasicOutput.this.xw.endElement();
            if (!occurs.equals(Occurs.ZERO_OR_MORE)) {
                BasicOutput.this.xw.endElement();
                if (occurs.getMin() == occurs.getMax()) {
                    BasicOutput.this.xw.startElement(BasicOutput.this.xs("length"));
                    BasicOutput.this.xw.attribute("value", Integer.toString(occurs.getMin()));
                    BasicOutput.this.xw.endElement();
                } else {
                    if (occurs.getMin() != 0) {
                        BasicOutput.this.xw.startElement(BasicOutput.this.xs("minLength"));
                        BasicOutput.this.xw.attribute("value", Integer.toString(occurs.getMin()));
                        BasicOutput.this.xw.endElement();
                    }
                    if (occurs.getMax() != Integer.MAX_VALUE) {
                        BasicOutput.this.xw.startElement(BasicOutput.this.xs("maxLength"));
                        BasicOutput.this.xw.attribute("value", Integer.toString(occurs.getMax()));
                        BasicOutput.this.xw.endElement();
                    }
                }
                BasicOutput.this.xw.endElement();
            }
            return null;
        }

        void outputWrap(SimpleType simpleType, Annotated annotated) {
            this.outputWrap(simpleType, "type", annotated);
        }

        void outputWrap(SimpleType simpleType, String string2, Annotated annotated) {
            String string3 = (String)simpleType.accept(BasicOutput.this.simpleTypeNamer);
            if (string3 != null) {
                BasicOutput.this.xw.attribute(string2, string3);
                if (annotated != null) {
                    BasicOutput.this.outputAnnotation(annotated);
                }
            } else {
                if (annotated != null) {
                    BasicOutput.this.outputAnnotation(annotated);
                }
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("simpleType"));
                simpleType.accept(this);
                BasicOutput.this.xw.endElement();
            }
        }
    }

    static class Options {
        String anyProcessContents = "skip";
        String anyAttributeProcessContents = "skip";

        Options() {
        }
    }
}

