/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.VcsStatusMerger;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH$J\"\u0010\n\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u001c\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/impl/VcsChangesMerger;", "Lcom/intellij/vcs/log/impl/VcsStatusMerger;", "Lcom/intellij/openapi/vcs/changes/Change;", "()V", "createChange", "type", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "beforePath", "Lcom/intellij/openapi/vcs/FilePath;", "afterPath", "createStatus", "path", "", "secondPath", "getFirstPath", "info", "getSecondPath", "getType", "merge", "changesToParents", "", "intellij.platform.vcs.log.impl"})
public abstract class VcsChangesMerger
extends VcsStatusMerger<Change> {
    @Override
    @NotNull
    protected Change createStatus(@NotNull Change.Type type2, @NotNull CharSequence path2, @Nullable CharSequence secondPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                return this.createChange(type2, null, VcsUtil.getFilePath(((Object)path2).toString()));
            }
            case 2: {
                return this.createChange(type2, VcsUtil.getFilePath(((Object)path2).toString()), null);
            }
            case 3: {
                return this.createChange(type2, VcsUtil.getFilePath(((Object)path2).toString()), VcsUtil.getFilePath(String.valueOf(secondPath)));
            }
            case 4: {
                return this.createChange(type2, VcsUtil.getFilePath(((Object)path2).toString()), VcsUtil.getFilePath(((Object)path2).toString()));
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    protected abstract Change createChange(@NotNull Change.Type var1, @Nullable FilePath var2, @Nullable FilePath var3);

    @NotNull
    public final Change merge(@NotNull FilePath path2, @NotNull List<? extends Change> changesToParents) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(changesToParents, (String)"changesToParents");
        String string2 = path2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path.path");
        return new MergedChange.SimpleMergedChange(this.merge(string2, changesToParents), changesToParents);
    }

    @Override
    @NotNull
    protected CharSequence getFirstPath(@NotNull Change info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return switch (WhenMappings.$EnumSwitchMapping$0[info.getType().ordinal()]) {
            case 1, 4 -> {
                ContentRevision v0 = info.getAfterRevision();
                Intrinsics.checkNotNull((Object)v0);
                String v1 = v0.getFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"info.afterRevision!!.file.path");
                yield v1;
            }
            case 2, 3 -> {
                ContentRevision v3 = info.getBeforeRevision();
                Intrinsics.checkNotNull((Object)v3);
                String v4 = v3.getFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"info.beforeRevision!!.file.path");
                yield v4;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @Nullable
    protected CharSequence getSecondPath(@NotNull Change info) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (WhenMappings.$EnumSwitchMapping$0[info.getType().ordinal()] == 3) {
            ContentRevision contentRevision = info.getAfterRevision();
            Intrinsics.checkNotNull((Object)contentRevision);
            charSequence = contentRevision.getFile().getPath();
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    @Override
    @NotNull
    protected Change.Type getType(@NotNull Change info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Change.Type type2 = info.getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type2), (String)"info.type");
        return type2;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Change.Type.values().length];
            try {
                nArray[Change.Type.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.MOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.MODIFICATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

