/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IdleVcsLogIndexer;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.PhmVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.SqliteVcsLogStorageBackendKt;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogWriter;
import com.intellij.vcs.log.impl.HeavyAwareListener;
import com.intellij.vcs.log.impl.VcsIndexableLogProvider;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.statistics.VcsLogIndexCollector;
import com.intellij.vcs.log.util.IntCollectionUtil;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.StorageId;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.sqlite.AlreadyClosedException;

public final class VcsLogPersistentIndex
implements VcsLogModifiableIndex,
Disposable {
    static final Logger LOG = Logger.getInstance(VcsLogPersistentIndex.class);
    static final int VERSION = 18;
    public static final VcsLogProgress.ProgressKey INDEXING = new VcsLogProgress.ProgressKey("index");
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogErrorHandler myErrorHandler;
    @NotNull
    private final VcsLogProgress myProgress;
    @NotNull
    private final Map<VirtualFile, VcsLogIndexer> myIndexers;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogBigRepositoriesList myBigRepositoriesList;
    @NotNull
    private final VcsLogIndexCollector myIndexCollector;
    @NotNull
    private final CheckedDisposable myDisposableFlag;
    @NotNull
    private final VcsLogStorageBackend myBackend;
    @NotNull
    private final IndexDataGetter myDataGetter;
    @NotNull
    private final SingleTaskController<IndexingRequest, Void> mySingleTaskController;
    @NotNull
    private final MyHeavyAwareListener myHeavyAwareListener;
    @NotNull
    private final AtomicReference<Boolean> myPostponedIndex;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myNumberOfTasks;
    @NotNull
    private final Map<VirtualFile, AtomicLong> myIndexingTime;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myIndexingLimit;
    @NotNull
    private final Map<VirtualFile, ConcurrentIntObjectMap<Integer>> myIndexingErrors;
    @NotNull
    private final List<VcsLogIndex.IndexingFinishedListener> myListeners;
    @NotNull
    private Map<VirtualFile, IntSet> myCommitsToIndex;
    @NotNull
    private final IdleVcsLogIndexer myIdleIndexer;

    private VcsLogPersistentIndex(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull Map<VirtualFile, VcsLogIndexer> indexers, @NotNull LinkedHashSet<VirtualFile> roots, @NotNull VcsLogStorage storage, @NotNull VcsLogStorageBackend backend, @NotNull VcsLogProgress progress, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable disposableParent) {
        if (project2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(0);
        }
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(1);
        }
        if (indexers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(3);
        }
        if (storage == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(4);
        }
        if (backend == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(6);
        }
        if (errorHandler2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(7);
        }
        if (disposableParent == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(8);
        }
        this.myDisposableFlag = Disposer.newCheckedDisposable();
        this.myPostponedIndex = new AtomicReference<Object>(null);
        this.myNumberOfTasks = new HashMap<VirtualFile, AtomicInteger>();
        this.myIndexingTime = new HashMap<VirtualFile, AtomicLong>();
        this.myIndexingLimit = new HashMap<VirtualFile, AtomicInteger>();
        this.myIndexingErrors = new HashMap<VirtualFile, ConcurrentIntObjectMap<Integer>>();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCommitsToIndex = new HashMap<VirtualFile, IntSet>();
        this.myStorage = storage;
        this.myProject = project2;
        this.myProgress = progress;
        this.myErrorHandler = errorHandler2;
        this.myBigRepositoriesList = VcsLogBigRepositoriesList.getInstance();
        this.myIndexCollector = VcsLogIndexCollector.getInstance(this.myProject);
        this.myIndexers = indexers;
        this.myRoots = roots;
        this.myBackend = backend;
        this.myDataGetter = new IndexDataGetter(this.myProject, ContainerUtil.filter(providers, root -> this.myRoots.contains(root)), this.myBackend, this.myStorage, this.myErrorHandler);
        for (VirtualFile root2 : this.myRoots) {
            this.myNumberOfTasks.put(root2, new AtomicInteger());
            this.myIndexingTime.put(root2, new AtomicLong());
            this.myIndexingLimit.put(root2, new AtomicInteger(VcsLogPersistentIndex.getIndexingLimit()));
            this.myIndexingErrors.put(root2, (ConcurrentIntObjectMap<Integer>)ConcurrentCollectionFactory.createConcurrentIntObjectMap());
        }
        this.mySingleTaskController = new MySingleTaskController(this);
        this.myHeavyAwareListener = new MyHeavyAwareListener(100);
        this.myHeavyAwareListener.start();
        this.myIdleIndexer = new IdleVcsLogIndexer(project2, this, this);
        this.myIdleIndexer.start();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myDisposableFlag);
    }

    private static int getIndexingLimit() {
        int limitValue = Registry.intValue((String)"vcs.log.index.limit.minutes");
        if (limitValue < 0) {
            return -1;
        }
        return Math.max(1, limitValue);
    }

    @Override
    public void scheduleIndex(boolean full) {
        if (this.myHeavyAwareListener.isHeavy()) {
            LOG.debug("Indexing is postponed due to heavy activity");
            this.myPostponedIndex.updateAndGet(oldFull -> {
                if (oldFull == null) {
                    return full;
                }
                return oldFull != false || full;
            });
        } else {
            this.doScheduleIndex(full);
        }
    }

    private void doScheduleIndex(boolean full) {
        this.doScheduleIndex(full, request -> this.mySingleTaskController.request((IndexingRequest[])new IndexingRequest[]{request}));
    }

    @TestOnly
    void indexNow(boolean full) {
        this.doScheduleIndex(full, request -> request.run(this.myProgress.createProgressIndicator(INDEXING)));
    }

    private synchronized void doScheduleIndex(boolean full, @NotNull java.util.function.Consumer<? super IndexingRequest> requestConsumer) {
        boolean isFull;
        if (requestConsumer == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(9);
        }
        if (this.myDisposableFlag.isDisposed()) {
            return;
        }
        if (this.myCommitsToIndex.isEmpty()) {
            return;
        }
        if (this.myBackend.isFresh() && !full) {
            return;
        }
        Map<VirtualFile, IntSet> commitsToIndex = this.myCommitsToIndex;
        this.myCommitsToIndex = new HashMap<VirtualFile, IntSet>();
        boolean bl = isFull = full && this.myBackend.isFresh();
        if (isFull) {
            LOG.debug("Index storage for project " + this.myProject.getName() + " is fresh, scheduling full reindex");
        }
        for (VirtualFile root : commitsToIndex.keySet()) {
            IntSet commits2 = commitsToIndex.get(root);
            if (commits2.isEmpty()) continue;
            if (this.myBigRepositoriesList.isBig(root)) {
                this.myCommitsToIndex.put(root, commits2);
                LOG.info("Indexing repository " + root.getName() + " is skipped");
                continue;
            }
            requestConsumer.accept(new IndexingRequest(root, this.myBackend.getPathsEncoder(), commits2, isFull));
        }
        if (isFull) {
            this.myIndexCollector.reportFreshIndex();
            this.myBackend.setFresh(false);
        }
    }

    private void storeDetail(@NotNull VcsLogIndexer.CompressedDetails detail, @NotNull VcsLogWriter mutator) {
        if (detail == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(10);
        }
        if (mutator == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(11);
        }
        try {
            mutator.putCommit(this.myStorage.getCommitIndex((Hash)detail.getId(), detail.getRoot()), detail);
        }
        catch (IOException | UncheckedIOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
        }
    }

    @Override
    public void markCorrupted() {
        this.myBackend.markCorrupted();
    }

    @Override
    public boolean isIndexed(int commit2) {
        try {
            return this.myBackend.containsCommit(commit2);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
            return false;
        }
    }

    @Override
    public synchronized boolean isIndexed(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(12);
        }
        return this.isIndexingEnabled(root) && !this.myCommitsToIndex.containsKey(root) && this.myNumberOfTasks.get(root).get() == 0;
    }

    @Override
    public boolean isIndexingEnabled(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(13);
        }
        return this.myRoots.contains(root) && !this.myBigRepositoriesList.isBig(root);
    }

    @Override
    public synchronized void markForIndexing(int index, @NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(14);
        }
        if (this.isIndexed(index) || !this.myRoots.contains(root)) {
            return;
        }
        IntCollectionUtil.add(this.myCommitsToIndex, root, index);
    }

    private synchronized void markForIndexing(@NotNull IntSet commits2, @NotNull VirtualFile root) {
        if (commits2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(15);
        }
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(16);
        }
        IntSet commitsToIndex = this.myCommitsToIndex.computeIfAbsent(root, __ -> new IntOpenHashSet());
        commitsToIndex.addAll((IntCollection)commits2);
    }

    @Override
    @NotNull
    public IndexDataGetter getDataGetter() {
        IndexDataGetter indexDataGetter = this.myDataGetter;
        if (indexDataGetter == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(17);
        }
        return indexDataGetter;
    }

    @Override
    public void addListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(18);
        }
        this.myListeners.add(l);
    }

    @Override
    public void removeListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(19);
        }
        this.myListeners.remove(l);
    }

    @NotNull
    public StorageId getIndexStorageId() {
        StorageId storageId = this.myBackend.getStorageId();
        if (storageId == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(20);
        }
        return storageId;
    }

    public void dispose() {
        this.myPostponedIndex.set(null);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getIndexingRoots() {
        Set<VirtualFile> set = this.myRoots;
        if (set == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    private static Map<VirtualFile, VcsLogIndexer> getAvailableIndexers(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(22);
        }
        LinkedHashMap<VirtualFile, VcsLogIndexer> indexers = new LinkedHashMap<VirtualFile, VcsLogIndexer>();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry2 : providers.entrySet()) {
            VirtualFile root = entry2.getKey();
            VcsLogProvider provider = entry2.getValue();
            if (!VcsLogProperties.SUPPORTS_INDEXING.getOrDefault(provider).booleanValue() || !(provider instanceof VcsIndexableLogProvider)) continue;
            indexers.put(root, ((VcsIndexableLogProvider)((Object)provider)).getIndexer());
        }
        LinkedHashMap<VirtualFile, VcsLogIndexer> linkedHashMap = indexers;
        if (linkedHashMap == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(23);
        }
        return linkedHashMap;
    }

    @NotNull
    public static Set<VirtualFile> getRootsForIndexing(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(24);
        }
        Set<VirtualFile> set = VcsLogPersistentIndex.getAvailableIndexers(providers).keySet();
        if (set == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(25);
        }
        return set;
    }

    @Nullable
    public static VcsLogPersistentIndex create(@NotNull Project project2, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogProgress progress, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable disposableParent) {
        if (project2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(26);
        }
        if (storage == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(27);
        }
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(28);
        }
        if (progress == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(29);
        }
        if (errorHandler2 == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(30);
        }
        if (disposableParent == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(31);
        }
        Map<VirtualFile, VcsLogIndexer> indexers = VcsLogPersistentIndex.getAvailableIndexers(providers);
        LinkedHashSet<VirtualFile> roots = new LinkedHashSet<VirtualFile>(indexers.keySet());
        String logId = PersistentUtil.calcLogId(project2, providers);
        VcsLogStorageBackend backend = storage instanceof VcsLogStorageBackend ? (VcsLogStorageBackend)((Object)storage) : PhmVcsLogStorageBackend.create(project2, storage, roots, logId, errorHandler2, disposableParent);
        if (backend == null) {
            return null;
        }
        return new VcsLogPersistentIndex(project2, providers, indexers, roots, storage, backend, progress, errorHandler2, disposableParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 20, 21, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 22: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backend";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 8: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGetter";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexStorageId";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingRoots";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIndexers";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsForIndexing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doScheduleIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "storeDetail";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIndexed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isIndexingEnabled";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "markForIndexing";
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIndexers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRootsForIndexing";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 17, 20, 21, 23, 25 -> new IllegalStateException(string2);
        };
    }

    private class MySingleTaskController
    extends SingleTaskController<IndexingRequest, Void> {
        private static final int LOW_PRIORITY = 1;

        MySingleTaskController(Disposable parent) {
            if (parent == null) {
                MySingleTaskController.$$$reportNull$$$0(0);
            }
            super("index", parent, (? super Result unused) -> {});
        }

        @Override
        protected int disposeLongTimeout() {
            if (SqliteVcsLogStorageBackendKt.isSqliteBackend(VcsLogPersistentIndex.this.myBackend)) {
                return 5000;
            }
            return super.disposeLongTimeout();
        }

        @Override
        @NotNull
        protected SingleTaskController.SingleTask startNewBackgroundTask() {
            ProgressIndicator indicator = VcsLogPersistentIndex.this.myProgress.createProgressIndicator(true, INDEXING);
            java.util.function.Consumer<ProgressIndicator> task2 = progressIndicator -> {
                int previousPriority = this.setMinimumPriority();
                try {
                    IndexingRequest request;
                    while ((request = (IndexingRequest)this.popRequest()) != null) {
                        try {
                            request.run((ProgressIndicator)progressIndicator);
                            progressIndicator.checkCanceled();
                        }
                        catch (ProcessCanceledException reThrown) {
                            throw reThrown;
                        }
                        catch (Throwable t) {
                            indicator.checkCanceled();
                            request.processException(t);
                        }
                    }
                }
                finally {
                    this.taskCompleted(null);
                    this.resetPriority(previousPriority);
                }
            };
            Future<?> future2 = AppExecutorUtil.getAppExecutorService().submit(() -> ProgressManager.getInstance().runProcess(() -> task2.accept(indicator), indicator));
            return new SingleTaskController.SingleTaskImpl(future2, indicator);
        }

        public void resetPriority(int previousPriority) {
            if (Thread.currentThread().getPriority() == 1) {
                Thread.currentThread().setPriority(previousPriority);
            }
        }

        public int setMinimumPriority() {
            int previousPriority = Thread.currentThread().getPriority();
            try {
                Thread.currentThread().setPriority(1);
            }
            catch (SecurityException e) {
                LOG.debug("Could not set indexing thread priority", (Throwable)e);
            }
            return previousPriority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController", "<init>"));
        }
    }

    private final class MyHeavyAwareListener
    extends HeavyAwareListener {
        private MyHeavyAwareListener(int delay) {
            super(VcsLogPersistentIndex.this.myProject, delay, VcsLogPersistentIndex.this);
        }

        @Override
        public void heavyActivityEnded() {
            Boolean indexRequest = VcsLogPersistentIndex.this.myPostponedIndex.getAndSet(null);
            if (indexRequest == null) {
                return;
            }
            VcsLogPersistentIndex.this.doScheduleIndex(indexRequest);
        }

        @Override
        public void heavyActivityStarted() {
            VcsLogPersistentIndex.this.mySingleTaskController.cancelCurrentTask();
        }
    }

    private final class IndexingRequest {
        private static final int BATCH_SIZE = 20000;
        private static final int LOGGED_ERRORS_COUNT = 5;
        private static final int STOPPING_ERROR_COUNT = 30;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final IntSet myCommits;
        @NotNull
        private final VcsLogIndexer.PathsEncoder myPathsEncoder;
        private final boolean myFull;
        private final int myFlushedCommitsNumber;
        @NotNull
        private final AtomicInteger myNewIndexedCommits;
        @NotNull
        private final AtomicInteger myOldCommits;
        private volatile long myStartTime;
        private Span mySpan;
        private Scope myScope;

        IndexingRequest(@NotNull VirtualFile root, @NotNull VcsLogIndexer.PathsEncoder encoder, IntSet commits2, boolean full) {
            if (root == null) {
                IndexingRequest.$$$reportNull$$$0(0);
            }
            if (encoder == null) {
                IndexingRequest.$$$reportNull$$$0(1);
            }
            if (commits2 == null) {
                IndexingRequest.$$$reportNull$$$0(2);
            }
            this.myFlushedCommitsNumber = SqliteVcsLogStorageBackendKt.isSqliteBackend(VcsLogPersistentIndex.this.myBackend) ? 5000 : 15000;
            this.myNewIndexedCommits = new AtomicInteger();
            this.myOldCommits = new AtomicInteger();
            this.myRoot = root;
            this.myPathsEncoder = encoder;
            this.myCommits = commits2;
            this.myFull = full;
            VcsLogPersistentIndex.this.myNumberOfTasks.get(root).incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(3);
            }
            if (VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot)) {
                LOG.info("Indexing repository " + this.myRoot.getName() + " is skipped");
                this.markCommits();
                VcsLogPersistentIndex.this.myNumberOfTasks.get(this.myRoot).decrementAndGet();
                return;
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            this.mySpan = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogData.Indexing.getName()).startSpan();
            this.myScope = this.mySpan.makeCurrent();
            this.myStartTime = IndexingRequest.getCurrentTimeMillis();
            LOG.info("Indexing " + (String)(this.myFull ? "full repository" : this.myCommits.size() + " commits") + " in " + this.myRoot.getName());
            VcsLogStorageBackend indexStorageBackend = Objects.requireNonNull(VcsLogPersistentIndex.this.myBackend);
            VcsLogWriter mutator = indexStorageBackend.createWriter();
            boolean performCommit = false;
            try {
                if (this.myFull) {
                    this.indexAll(indicator, mutator);
                } else {
                    IntStream commits2 = this.myCommits.intStream().filter(c -> {
                        if (VcsLogPersistentIndex.this.isIndexed(c)) {
                            this.myOldCommits.incrementAndGet();
                            return false;
                        }
                        return true;
                    });
                    this.indexOneByOne(commits2, indicator, mutator);
                }
                performCommit = true;
            }
            catch (AlreadyClosedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (ProcessCanceledException e) {
                performCommit = true;
                this.scheduleReindex();
                throw e;
            }
            catch (VcsException e) {
                if (indicator.isCanceled()) {
                    performCommit = true;
                    this.scheduleReindex();
                    throw new ProcessCanceledException();
                }
                this.processException(e);
                this.scheduleReindex();
            }
            finally {
                try {
                    mutator.close(performCommit);
                }
                catch (ProcessCanceledException | AlreadyClosedException e) {
                }
                catch (Exception e) {
                    VcsLogPersistentIndex.this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
                }
                VcsLogPersistentIndex.this.myNumberOfTasks.get(this.myRoot).decrementAndGet();
                VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot).updateAndGet(t -> t + (IndexingRequest.getCurrentTimeMillis() - this.myStartTime));
                if (VcsLogPersistentIndex.this.isIndexed(this.myRoot)) {
                    long time = VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot).getAndSet(0L);
                    VcsLogPersistentIndex.this.myIndexCollector.reportIndexingTime(time);
                    VcsLogPersistentIndex.this.myListeners.forEach(listener2 -> listener2.indexingFinished(this.myRoot));
                }
                this.report();
            }
        }

        private void processException(@NotNull Throwable e) {
            if (e == null) {
                IndexingRequest.$$$reportNull$$$0(4);
            }
            int errorHash = ThrowableInterner.computeTraceHashCode((Throwable)e);
            int errors = (Integer)VcsLogPersistentIndex.this.myIndexingErrors.get(this.myRoot).cacheOrGet(errorHash, (Object)0);
            VcsLogPersistentIndex.this.myIndexingErrors.get(this.myRoot).put(errorHash, (Object)(errors + 1));
            if (errors <= 5) {
                LOG.error("Error while indexing " + this.myRoot.getName(), e);
            } else if (errors >= 30) {
                VcsLogPersistentIndex.this.myBigRepositoriesList.addRepository(this.myRoot);
                LOG.error("Stopping indexing of " + this.myRoot.getName() + " due to the large amount of exceptions.", e);
            }
        }

        private static long getCurrentTimeMillis() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        }

        private void report() {
            String formattedTime = StopWatch.formatTime(IndexingRequest.getCurrentTimeMillis() - this.myStartTime);
            this.mySpan.setAttribute("numberOfCommits-" + this.myRoot.getName(), (long)this.myNewIndexedCommits.get());
            this.mySpan.setAttribute("rootName", this.myRoot.getName());
            if (this.myFull) {
                LOG.info(formattedTime + " for indexing " + this.myNewIndexedCommits + " commits in " + this.myRoot.getName());
            } else {
                int leftCommits = this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get();
                Object leftCommitsMessage = leftCommits > 0 ? ". " + leftCommits + " commits left" : "";
                this.mySpan.setAttribute("totalCommits", (long)this.myCommits.size());
                this.mySpan.setAttribute("commitsLeft", (long)leftCommits);
                LOG.info(formattedTime + " for indexing " + this.myNewIndexedCommits + " new commits out of " + this.myCommits.size() + " in " + this.myRoot.getName() + (String)leftCommitsMessage);
            }
            this.mySpan.end();
            this.myScope.close();
        }

        private void scheduleReindex() {
            int unindexedCommits = this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get();
            if (VcsLogPersistentIndex.this.mySingleTaskController.isClosed()) {
                LOG.debug("Reindexing of " + this.myRoot.getName() + " is not scheduled since dispose has already started. " + unindexedCommits + " unindexed commits left.");
                return;
            }
            LOG.debug("Schedule reindexing of " + unindexedCommits + " commits in " + this.myRoot.getName());
            this.markCommits();
            VcsLogPersistentIndex.this.scheduleIndex(false);
        }

        private void markCommits() {
            if (!VcsLogPersistentIndex.this.myRoots.contains(this.myRoot)) {
                return;
            }
            try {
                IntSet missingCommits = VcsLogPersistentIndex.this.myBackend.collectMissingCommits(this.myCommits);
                VcsLogPersistentIndex.this.markForIndexing(missingCommits, this.myRoot);
            }
            catch (IOException e) {
                VcsLogPersistentIndex.this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
            }
        }

        private void indexOneByOne(@NotNull IntStream commits2, @NotNull ProgressIndicator indicator, @NotNull VcsLogWriter mutator) throws VcsException {
            if (commits2 == null) {
                IndexingRequest.$$$reportNull$$$0(5);
            }
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(6);
            }
            if (mutator == null) {
                IndexingRequest.$$$reportNull$$$0(7);
            }
            IntCollectionUtil.processBatches(commits2, 20000, (ThrowableConsumer<? super IntSet, ? extends VcsException>)((ThrowableConsumer)batch -> {
                indicator.checkCanceled();
                Map<@NotNull Integer, @NotNull CommitId> ids = VcsLogPersistentIndex.this.myStorage.getCommitIds((Collection<Integer>)batch);
                List hashes2 = ContainerUtil.map(ids.values(), value2 -> value2.getHash().asString());
                VcsLogPersistentIndex.this.myIndexers.get(this.myRoot).readFullDetails(this.myRoot, hashes2, this.myPathsEncoder, (Consumer<? super VcsLogIndexer.CompressedDetails>)((Consumer)detail -> {
                    indicator.checkCanceled();
                    VcsLogPersistentIndex.this.storeDetail((VcsLogIndexer.CompressedDetails)detail, mutator);
                    if (this.myNewIndexedCommits.incrementAndGet() % this.myFlushedCommitsNumber == 0) {
                        mutator.flush();
                    }
                    this.checkShouldCancel(indicator);
                }));
            }));
        }

        private void indexAll(@NotNull ProgressIndicator indicator, @NotNull VcsLogWriter mutator) throws VcsException {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(8);
            }
            if (mutator == null) {
                IndexingRequest.$$$reportNull$$$0(9);
            }
            VcsLogPersistentIndex.this.myIndexers.get(this.myRoot).readAllFullDetails(this.myRoot, this.myPathsEncoder, (Consumer<? super VcsLogIndexer.CompressedDetails>)((Consumer)details -> {
                indicator.checkCanceled();
                VcsLogPersistentIndex.this.storeDetail((VcsLogIndexer.CompressedDetails)details, mutator);
                if (this.myNewIndexedCommits.incrementAndGet() % this.myFlushedCommitsNumber == 0) {
                    mutator.flush();
                }
                this.checkShouldCancel(indicator);
            }));
        }

        private void checkShouldCancel(@NotNull ProgressIndicator indicator) {
            boolean isOvertime;
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(10);
            }
            long time = VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot).get() + (IndexingRequest.getCurrentTimeMillis() - this.myStartTime);
            int limit = VcsLogPersistentIndex.this.myIndexingLimit.get(this.myRoot).get();
            boolean isBigRoot = VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot);
            boolean bl = isOvertime = !VcsLogPersistentIndex.this.myIdleIndexer.isEnabled() && limit > 0 && time >= Math.max((long)limit, 1L) * 60L * 1000L && !isBigRoot;
            if (isOvertime || isBigRoot && !indicator.isCanceled()) {
                this.mySpan.setAttribute("cancelled", true);
                LOG.warn("Indexing " + this.myRoot.getName() + " was cancelled after " + StopWatch.formatTime(time));
                if (!isBigRoot) {
                    VcsLogPersistentIndex.this.myBigRepositoriesList.addRepository(this.myRoot);
                }
                if (isOvertime) {
                    VcsLogPersistentIndex.this.myIndexingLimit.get(this.myRoot).compareAndSet(limit, Math.max(limit + VcsLogPersistentIndex.getIndexingLimit(), (int)((time / (long)(VcsLogPersistentIndex.getIndexingLimit() * 60000) + 1L) * (long)VcsLogPersistentIndex.getIndexingLimit())));
                }
                indicator.cancel();
            }
        }

        public String toString() {
            return "IndexingRequest of " + this.myCommits.size() + " commits in " + this.myRoot.getName() + (this.myFull ? " (full)" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "encoder";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 3: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mutator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processException";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOneByOne";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexAll";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkShouldCancel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

