/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleTaskController<Request, Result>
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(SingleTaskController.class);
    @NotNull
    @NonNls
    private final String myName;
    @NotNull
    private final java.util.function.Consumer<? super Result> myResultHandler;
    @NotNull
    private final Object LOCK;
    @NotNull
    private List<Request> myAwaitingRequests;
    @Nullable
    private SingleTask myRunningTask;
    private boolean myIsClosed;

    public SingleTaskController(@NotNull @NonNls String name, @NotNull Disposable parent, @NotNull java.util.function.Consumer<? super Result> handler2) {
        if (name == null) {
            SingleTaskController.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            SingleTaskController.$$$reportNull$$$0(1);
        }
        if (handler2 == null) {
            SingleTaskController.$$$reportNull$$$0(2);
        }
        this.LOCK = new Object();
        this.myIsClosed = false;
        this.myName = name;
        this.myResultHandler = handler2;
        this.myAwaitingRequests = new LinkedList<Request>();
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @Deprecated
    public SingleTaskController(@NotNull @NonNls String name, @NotNull Consumer<? super Result> handler2, @NotNull Disposable parent) {
        if (name == null) {
            SingleTaskController.$$$reportNull$$$0(3);
        }
        if (handler2 == null) {
            SingleTaskController.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            SingleTaskController.$$$reportNull$$$0(5);
        }
        this(name, parent, (? super Result result2) -> handler2.consume(result2));
    }

    public final void request(Request ... requests) {
        if (requests == null) {
            SingleTaskController.$$$reportNull$$$0(6);
        }
        this.request(Arrays.asList(requests));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(@NotNull List<Request> requestList) {
        if (requestList == null) {
            SingleTaskController.$$$reportNull$$$0(7);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsClosed) {
                return;
            }
            this.myAwaitingRequests.addAll(requestList);
            this.debug("Added requests: " + requestList);
            if (this.myRunningTask != null && this.cancelRunningTasks(requestList)) {
                this.cancelTask(this.myRunningTask);
            }
            if (this.myRunningTask == null) {
                this.myRunningTask = this.startNewBackgroundTask();
                this.debug("Started a new bg task " + this.myRunningTask);
            }
        }
    }

    protected boolean cancelRunningTasks(@NotNull List<Request> requests) {
        if (requests == null) {
            SingleTaskController.$$$reportNull$$$0(8);
        }
        return false;
    }

    private void debug(@NotNull String message2) {
        if (message2 == null) {
            SingleTaskController.$$$reportNull$$$0(9);
        }
        LOG.debug(this.formMessage(message2));
    }

    @NotNull
    private String formMessage(@NotNull String message2) {
        if (message2 == null) {
            SingleTaskController.$$$reportNull$$$0(10);
        }
        String string2 = "[" + this.myName + "] " + message2;
        if (string2 == null) {
            SingleTaskController.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private void cancelTask(@NotNull SingleTask t) {
        if (t == null) {
            SingleTaskController.$$$reportNull$$$0(12);
        }
        if (t.isRunning()) {
            t.cancel();
            this.debug("Canceled task " + this.myRunningTask);
        }
    }

    @NotNull
    protected abstract SingleTask startNewBackgroundTask();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<Request> popRequests() {
        Object object = this.LOCK;
        // MONITORENTER : object
        List<Request> requests = this.myAwaitingRequests;
        this.myAwaitingRequests = new LinkedList<Request>();
        this.debug("Popped requests: " + requests);
        List<Request> list = requests;
        // MONITOREXIT : object
        if (list != null) return list;
        SingleTaskController.$$$reportNull$$$0(13);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<Request> peekRequests() {
        Object object = this.LOCK;
        // MONITORENTER : object
        ArrayList<Request> requests = new ArrayList<Request>(this.myAwaitingRequests);
        this.debug("Peeked requests: " + requests);
        ArrayList<Request> arrayList = requests;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        SingleTaskController.$$$reportNull$$$0(14);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRequests(@NotNull List<Request> requests) {
        if (requests == null) {
            SingleTaskController.$$$reportNull$$$0(15);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myAwaitingRequests.removeAll(requests);
            this.debug("Removed requests: " + requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Request popRequest() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                return null;
            }
            Request request = this.myAwaitingRequests.remove(0);
            this.debug("Popped request: " + request);
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void taskCompleted(@Nullable Result result2) {
        if (result2 != null) {
            this.myResultHandler.accept(result2);
            this.debug("Handled result: " + result2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                this.myRunningTask = null;
                this.debug("No more requests");
            } else {
                this.myRunningTask = this.startNewBackgroundTask();
                this.debug("Restarted a bg task " + this.myRunningTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCurrentTask() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myRunningTask != null) {
                this.myRunningTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQueue() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsClosed) {
                return;
            }
            this.myIsClosed = true;
            if (this.myRunningTask != null) {
                this.myRunningTask.cancel();
            }
            this.myAwaitingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myIsClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        block9: {
            SingleTask task2 = null;
            Object object = this.LOCK;
            synchronized (object) {
                this.closeQueue();
                if (this.myRunningTask != null) {
                    task2 = this.myRunningTask;
                    this.myRunningTask = null;
                }
            }
            if (task2 != null) {
                boolean longTimeOut = !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode();
                try {
                    int timeout = longTimeOut ? this.disposeLongTimeout() : 20;
                    task2.waitFor(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException e) {
                    if (!(e.getCause() instanceof ProcessCanceledException)) {
                        LOG.debug((Throwable)e);
                    }
                }
                catch (TimeoutException e) {
                    if (!longTimeOut) break block9;
                    LOG.warn(this.formMessage("Wait time out "), (Throwable)e);
                }
            }
        }
    }

    protected int disposeLongTimeout() {
        return 1000;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestList";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/SingleTaskController";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/SingleTaskController";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "formMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "popRequests";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "peekRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cancelRunningTasks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formMessage";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeRequests";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 11, 13, 14 -> new IllegalStateException(string2);
        };
    }

    public static interface SingleTask {
        public void waitFor(long var1, @NotNull TimeUnit var3) throws InterruptedException, ExecutionException, TimeoutException;

        public void cancel();

        public boolean isRunning();
    }

    public static class SingleTaskImpl
    implements SingleTask {
        @NotNull
        private final Future<?> myFuture;
        @NotNull
        private final ProgressIndicator myIndicator;

        public SingleTaskImpl(@NotNull Future<?> future2, @NotNull ProgressIndicator indicator) {
            if (future2 == null) {
                SingleTaskImpl.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                SingleTaskImpl.$$$reportNull$$$0(1);
            }
            this.myFuture = future2;
            this.myIndicator = indicator;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void waitFor(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            void unit;
            if (timeUnit == null) {
                SingleTaskImpl.$$$reportNull$$$0(2);
            }
            this.myFuture.get(timeout, (TimeUnit)unit);
        }

        @Override
        public void cancel() {
            this.myIndicator.cancel();
        }

        @Override
        public boolean isRunning() {
            return this.myIndicator.isRunning();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/SingleTaskController$SingleTaskImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "waitFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

