/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.xml.ui.ComboControl;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;

public class ComboTableCellEditor
extends DefaultCellEditor {
    private final boolean myNullable;
    private final Factory<? extends List<Pair<String, Icon>>> myDataFactory;
    private Map<String, Icon> myData;
    private static final Pair<String, Icon> EMPTY = Pair.create((Object)" ", null);

    public ComboTableCellEditor(Factory<? extends List<Pair<String, Icon>>> dataFactory, boolean nullable) {
        super(new JComboBox());
        this.myDataFactory = dataFactory;
        this.myNullable = nullable;
        this.setClickCountToStart(2);
        JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.setBorder(null);
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        ComboControl.initComboBox(comboBox, (Condition<? super String>)((Condition)object -> this.myData != null && this.myData.containsKey(object) || this.myNullable && Strings.areSameInstance((String)((String)ComboTableCellEditor.EMPTY.first), (String)object)));
    }

    public ComboTableCellEditor(Class<? extends Enum> anEnum, boolean nullable) {
        this(ComboControl.createEnumFactory(anEnum), nullable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Object getCellEditorValue() {
        @Nls Pair cellEditorValue = (Pair)super.getCellEditorValue();
        return EMPTY == cellEditorValue || null == cellEditorValue ? null : cellEditorValue.first;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column) {
        List list = (List)this.myDataFactory.create();
        this.myData = new HashMap<String, Icon>();
        JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.removeAllItems();
        if (this.myNullable) {
            comboBox.addItem(EMPTY);
        }
        for (Pair pair : list) {
            this.myData.put((String)pair.first, (Icon)pair.second);
            comboBox.addItem(pair);
        }
        Pair pair = Pair.create((Object)value2, (Object)this.myData.get(value2));
        comboBox.setEditable(true);
        super.getTableCellEditorComponent(table, pair, isSelected, row2, column);
        comboBox.setEditable(false);
        return comboBox;
    }
}

