/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.spellchecker.DictionaryLevel;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.quickfixes.ChangeTo;
import com.intellij.spellchecker.quickfixes.RenameTo;
import com.intellij.spellchecker.quickfixes.SaveTo;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.tokenizer.CommentTokenizer;
import com.intellij.spellchecker.tokenizer.CustomFileTypeTokenizer;
import com.intellij.spellchecker.tokenizer.PsiIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.util.KeyedLazyInstance;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellcheckingStrategy {
    protected final Tokenizer<PsiComment> myCommentTokenizer = new CommentTokenizer();
    public static final ExtensionPointName<KeyedLazyInstance<SpellcheckingStrategy>> EP_NAME = new ExtensionPointName("com.intellij.spellchecker.support");
    public static final Tokenizer EMPTY_TOKENIZER = new Tokenizer(){

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        public String toString() {
            return "EMPTY_TOKENIZER";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final Tokenizer<PsiElement> TEXT_TOKENIZER = new TokenizerBase<PsiElement>(PlainTextSplitter.getInstance());
    private static final SpellCheckerQuickFix[] BATCH_FIXES = new SpellCheckerQuickFix[]{SaveTo.getSaveToLevelFix(DictionaryLevel.APP), SaveTo.getSaveToLevelFix(DictionaryLevel.PROJECT)};

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (SpellcheckingStrategy.isInjectedLanguageFragment(element)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            PsiIdentifierOwnerTokenizer psiIdentifierOwnerTokenizer = PsiIdentifierOwnerTokenizer.INSTANCE;
            if (psiIdentifierOwnerTokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return psiIdentifierOwnerTokenizer;
        }
        if (element instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment((PsiElement)element)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    SpellcheckingStrategy.$$$reportNull$$$0(3);
                }
                return tokenizer;
            }
            if (element.getTextOffset() == 0 && element.getText().startsWith("#!")) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    SpellcheckingStrategy.$$$reportNull$$$0(4);
                }
                return tokenizer;
            }
            Tokenizer<PsiComment> tokenizer = this.myCommentTokenizer;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(5);
            }
            return tokenizer;
        }
        if (element instanceof PsiPlainText) {
            FileType fileType;
            PsiFile file = element.getContainingFile();
            FileType fileType2 = fileType = file == null ? null : file.getFileType();
            if (fileType instanceof CustomSyntaxTableFileType) {
                return new CustomFileTypeTokenizer(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
            }
            Tokenizer<PsiElement> tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                SpellcheckingStrategy.$$$reportNull$$$0(6);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(7);
        }
        return tokenizer;
    }

    protected static boolean isInjectedLanguageFragment(@Nullable PsiElement element) {
        return element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element));
    }

    public LocalQuickFix[] getRegularFixes(PsiElement element, @NotNull TextRange textRange, boolean useRename, String typo) {
        if (textRange == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(8);
        }
        return SpellcheckingStrategy.getDefaultRegularFixes(useRename, typo, element, textRange);
    }

    public static LocalQuickFix[] getDefaultRegularFixes(boolean useRename, String typo, @Nullable PsiElement element, @NotNull TextRange range) {
        if (range == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(9);
        }
        ArrayList<SpellCheckerQuickFix> result2 = new ArrayList<SpellCheckerQuickFix>();
        if (useRename) {
            result2.add(new RenameTo(typo));
        } else if (element != null) {
            result2.addAll(new ChangeTo(typo, element, range).getAllAsFixes());
        }
        if (element == null) {
            result2.add(new SaveTo(typo));
            return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
        SpellCheckerSettings settings = SpellCheckerSettings.getInstance(element.getProject());
        if (settings.isUseSingleDictionaryToSave()) {
            result2.add(new SaveTo(typo, DictionaryLevel.getLevelByName(settings.getDictionaryToSave())));
            return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
        }
        result2.add(new SaveTo(typo));
        return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public static SpellCheckerQuickFix[] getDefaultBatchFixes() {
        return BATCH_FIXES;
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        if (element == null) {
            SpellcheckingStrategy.$$$reportNull$$$0(10);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/tokenizer/SpellcheckingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRegularFixes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRegularFixes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 8, 9, 10 -> new IllegalArgumentException(string2);
        };
    }
}

