/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.choice.ChoiceTitleIntentionAction;
import com.intellij.codeInsight.intention.choice.ChoiceVariantIntentionAction;
import com.intellij.codeInsight.intention.choice.DefaultIntentionActionWithChoice;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.spellchecker.quickfixes.ChangeTo;
import com.intellij.spellchecker.quickfixes.LazySuggestions;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0003\u0013\u0014\u0015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R!\u0010\n\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u00060\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo;", "Lcom/intellij/codeInsight/intention/choice/DefaultIntentionActionWithChoice;", "Lcom/intellij/spellchecker/quickfixes/LazySuggestions;", "typo", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTitle", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "getVariants", "", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "ChangeToTitleAction", "ChangeToVariantAction", "Companion", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nChangeTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeTo.kt\ncom/intellij/spellchecker/quickfixes/ChangeTo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1549#2:92\n1620#2,3:93\n*S KotlinDebug\n*F\n+ 1 ChangeTo.kt\ncom/intellij/spellchecker/quickfixes/ChangeTo\n*L\n89#1:92\n89#1:93,3\n*E\n"})
public final class ChangeTo
extends LazySuggestions
implements DefaultIntentionActionWithChoice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextRange range;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> pointer;
    @NotNull
    private static final Lazy<String> fixName$delegate = LazyKt.lazy((Function0)Companion.fixName.2.INSTANCE);

    public ChangeTo(@NotNull String typo, @NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)typo, (String)"typo");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(typo);
        this.range = range;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element, element.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"getInstance(element.proj\u2026, element.containingFile)");
        this.pointer = smartPsiElementPointer;
    }

    @NotNull
    public ChoiceTitleIntentionAction getTitle() {
        return ChangeToTitleAction.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChoiceVariantIntentionAction> getVariants() {
        void $this$mapTo$iv$iv;
        int limit = Registry.intValue((String)"spellchecker.corrections.limit");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)limit);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChangeToVariantAction((int)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String getFixName() {
        return Companion.getFixName();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToTitleAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "intellij.spellchecker"})
    private static final class ChangeToTitleAction
    extends ChoiceTitleIntentionAction
    implements HighPriorityAction {
        @NotNull
        public static final ChangeToTitleAction INSTANCE = new ChangeToTitleAction();

        private ChangeToTitleAction() {
            super(Companion.getFixName(), Companion.getFixName());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\tH\u0016J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToVariantAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "index", "", "(Lcom/intellij/spellchecker/quickfixes/ChangeTo;I)V", "getIndex", "()I", "suggestion", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "getName", "getRange", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "getTooltipText", "isAvailable", "", "startInWriteAction", "intellij.spellchecker"})
    private final class ChangeToVariantAction
    extends ChoiceVariantIntentionAction
    implements HighPriorityAction {
        private final int index;
        @NlsSafe
        @Nullable
        private String suggestion;

        public ChangeToVariantAction(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @NotNull
        public String getName() {
            String string2 = this.suggestion;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @NotNull
        public String getTooltipText() {
            Object[] objectArray = new Object[]{this.getName()};
            return SpellCheckerBundle.message("change.to.tooltip", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return Companion.getFixName();
        }

        public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            List<String> list = ChangeTo.this.getSuggestions(project2);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestions(project)");
            List<String> suggestions = list;
            if (suggestions.size() <= this.getIndex()) {
                return false;
            }
            Document document2 = file.getViewProvider().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"file.viewProvider.document");
            if (this.getRange(document2) == null) {
                return false;
            }
            this.suggestion = suggestions.get(this.getIndex());
            return true;
        }

        public void applyFix(@NotNull Project project2, @NotNull PsiFile file, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string2 = this.suggestion;
            if (string2 == null) {
                return;
            }
            String suggestion = string2;
            Document document2 = file.getViewProvider().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
            TextRange textRange = this.getRange(document2);
            if (textRange == null) {
                return;
            }
            TextRange myRange = textRange;
            UpdateHighlightersUtil.removeHighlightersWithExactRange((Document)document2, (Project)project2, (Segment)((Segment)myRange));
            document2.replaceString(myRange.getStartOffset(), myRange.getEndOffset(), (CharSequence)suggestion);
        }

        private final TextRange getRange(Document document2) {
            PsiElement psiElement = ChangeTo.this.pointer.getElement();
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            TextRange textRange = ChangeTo.this.range.shiftRight(UtilsKt.getStartOffset((PsiElement)element));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range.shiftRight(element.startOffset)");
            TextRange range = textRange;
            if (range.getStartOffset() < 0 || range.getEndOffset() > document2.getTextLength()) {
                return null;
            }
            String string2 = document2.getText(range);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.getText(range)");
            String text2 = string2;
            if (!Intrinsics.areEqual((Object)text2, (Object)ChangeTo.this.typo)) {
                return null;
            }
            return range;
        }

        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return (FileModifier)this;
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$Companion;", "", "()V", "fixName", "", "getFixName$annotations", "getFixName", "()Ljava/lang/String;", "fixName$delegate", "Lkotlin/Lazy;", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFixName() {
            Lazy lazy = fixName$delegate;
            return (String)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getFixName$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

