/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.highlighting;

import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonColorsPage
implements RainbowColorSettingsPage,
DisplayPrioritySortable {
    private static final Map<String, TextAttributesKey> ourAdditionalHighlighting = ImmutableMap.of((Object)"propertyKey", (Object)JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY);
    private static final AttributesDescriptor[] ourAttributeDescriptors = new AttributesDescriptor[]{new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.property.key", new Object[0]), JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.braces", new Object[0]), JsonSyntaxHighlighterFactory.JSON_BRACES), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.brackets", new Object[0]), JsonSyntaxHighlighterFactory.JSON_BRACKETS), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.comma", new Object[0]), JsonSyntaxHighlighterFactory.JSON_COMMA), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.colon", new Object[0]), JsonSyntaxHighlighterFactory.JSON_COLON), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.number", new Object[0]), JsonSyntaxHighlighterFactory.JSON_NUMBER), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.string", new Object[0]), JsonSyntaxHighlighterFactory.JSON_STRING), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.keyword", new Object[0]), JsonSyntaxHighlighterFactory.JSON_KEYWORD), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.line.comment", new Object[0]), JsonSyntaxHighlighterFactory.JSON_LINE_COMMENT), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.block.comment", new Object[0]), JsonSyntaxHighlighterFactory.JSON_BLOCK_COMMENT), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.valid.escape.sequence", new Object[0]), JsonSyntaxHighlighterFactory.JSON_VALID_ESCAPE), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.invalid.escape.sequence", new Object[0]), JsonSyntaxHighlighterFactory.JSON_INVALID_ESCAPE), new AttributesDescriptor(JsonBundle.messagePointer("color.page.attribute.parameter", new Object[0]), JsonSyntaxHighlighterFactory.JSON_PARAMETER)};

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Json;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)JsonLanguage.INSTANCE, null, null);
        if (syntaxHighlighter == null) {
            JsonColorsPage.$$$reportNull$$$0(0);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        return "{\n  // Line comments are not included in standard but nonetheless allowed.\n  /* As well as block comments. */\n  <propertyKey>\"the only keywords are\"</propertyKey>: [true, false, null],\n  <propertyKey>\"strings with\"</propertyKey>: {\n    <propertyKey>\"no escapes\"</propertyKey>: \"pseudopolinomiality\"\n    <propertyKey>\"valid escapes\"</propertyKey>: \"C-style\\r\\n and unicode\\u0021\",\n    <propertyKey>\"illegal escapes\"</propertyKey>: \"\\0377\\x\\\"\n  },\n  <propertyKey>\"some numbers\"</propertyKey>: [\n    42,\n    -0.0e-0,\n    6.626e-34\n  ] \n}";
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ourAdditionalHighlighting;
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ourAttributeDescriptors == null) {
            JsonColorsPage.$$$reportNull$$$0(1);
        }
        return ourAttributeDescriptors;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            JsonColorsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        String string2 = JsonBundle.message("settings.display.name.json", new Object[0]);
        if (string2 == null) {
            JsonColorsPage.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.LANGUAGE_SETTINGS;
    }

    public boolean isRainbowType(TextAttributesKey type2) {
        return JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY.equals((Object)type2) || JsonSyntaxHighlighterFactory.JSON_BRACES.equals((Object)type2) || JsonSyntaxHighlighterFactory.JSON_BRACKETS.equals((Object)type2) || JsonSyntaxHighlighterFactory.JSON_STRING.equals((Object)type2) || JsonSyntaxHighlighterFactory.JSON_NUMBER.equals((Object)type2) || JsonSyntaxHighlighterFactory.JSON_KEYWORD.equals((Object)type2);
    }

    @Nullable
    public Language getLanguage() {
        return JsonLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/json/highlighting/JsonColorsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

