/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.TestApplicationManager;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"CHECK_START", "", "LEAK_CHECK_INTERVAL", "LOG_PROJECT_LEAKAGE", "", "MAX_LEAKY_PROJECTS", "", "totalCreatedProjectsCount", "getTotalCreatedProjectsCount", "()I", "setTotalCreatedProjectsCount", "(I)V", "reportLeakedProjects", "", "leakedProjects", "", "Lcom/intellij/openapi/project/Project;", "intellij.platform.testFramework"})
public final class TestProjectManagerKt {
    private static final int MAX_LEAKY_PROJECTS = 5;
    private static final long LEAK_CHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);
    private static long CHECK_START = System.currentTimeMillis();
    private static final boolean LOG_PROJECT_LEAKAGE;
    private static int totalCreatedProjectsCount;

    public static final int getTotalCreatedProjectsCount() {
        return totalCreatedProjectsCount;
    }

    public static final void setTotalCreatedProjectsCount(int n) {
        totalCreatedProjectsCount = n;
    }

    @TestOnly
    private static final void reportLeakedProjects(Iterable<? extends Project> leakedProjects) {
        HashSet<Integer> hashCodes = new HashSet<Integer>();
        Ref.ObjectRef message = new Ref.ObjectRef();
        message.element = "Too many projects leaked: \n";
        for (Project project2 : leakedProjects) {
            int hashCode = System.identityHashCode(project2);
            hashCodes.add(hashCode);
            message.element = message.element + LeakHunter.getLeakedObjectDetails(project2, null, false);
        }
        String dumpPath2 = TestApplicationManager.Companion.publishHeapDump("leakedProjects");
        LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, arg_0 -> TestProjectManagerKt.reportLeakedProjects$lambda$0((Function1)new Function1<ProjectImpl, Boolean>(hashCodes){
            final /* synthetic */ HashSet<Integer> $hashCodes;
            {
                this.$hashCodes = $hashCodes;
                super(1);
            }

            @NotNull
            public final Boolean invoke(ProjectImpl it) {
                return this.$hashCodes.contains(System.identityHashCode(it));
            }
        }, arg_0), (arg_0, arg_1) -> TestProjectManagerKt.reportLeakedProjects$lambda$1((Function2)new Function2<ProjectImpl, Object, Boolean>((Ref.ObjectRef<String>)message, hashCodes){
            final /* synthetic */ Ref.ObjectRef<String> $message;
            final /* synthetic */ HashSet<Integer> $hashCodes;
            {
                this.$message = $message;
                this.$hashCodes = $hashCodes;
                super(2);
            }

            @NotNull
            public final Boolean invoke(ProjectImpl leaked, Object backLink) {
                int hashCode = System.identityHashCode(leaked);
                this.$message.element = this.$message.element + LeakHunter.getLeakedObjectDetails(leaked, backLink, false);
                this.$hashCodes.remove(hashCode);
                return !this.$hashCodes.isEmpty();
            }
        }, arg_0, arg_1));
        message.element = message.element + LeakHunter.getLeakedObjectErrorDescription(dumpPath2);
        throw new AssertionError(message.element);
    }

    private static final boolean reportLeakedProjects$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean reportLeakedProjects$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ boolean access$getLOG_PROJECT_LEAKAGE$p() {
        return LOG_PROJECT_LEAKAGE;
    }

    public static final /* synthetic */ long access$getCHECK_START$p() {
        return CHECK_START;
    }

    public static final /* synthetic */ long access$getLEAK_CHECK_INTERVAL$p() {
        return LEAK_CHECK_INTERVAL;
    }

    public static final /* synthetic */ void access$setCHECK_START$p(long l) {
        CHECK_START = l;
    }

    public static final /* synthetic */ void access$reportLeakedProjects(Iterable leakedProjects) {
        TestProjectManagerKt.reportLeakedProjects(leakedProjects);
    }

    static {
        String string = System.getProperty("idea.log.leaked.projects.in.tests", "true");
        Intrinsics.checkNotNull((Object)string);
        LOG_PROJECT_LEAKAGE = Boolean.parseBoolean(string);
    }
}

