/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.NodeType;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchTreeNodeComparator;", "Ljava/util/Comparator;", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "Lkotlin/Comparator;", "()V", "compare", "", "d1", "d2", "getOrderWeight", "descriptor", "intellij.vcs.git"})
public final class BranchTreeNodeComparator
implements Comparator<BranchNodeDescriptor> {
    @NotNull
    public static final BranchTreeNodeComparator INSTANCE = new BranchTreeNodeComparator();

    private BranchTreeNodeComparator() {
    }

    @Override
    public int compare(@NotNull BranchNodeDescriptor d1, @NotNull BranchNodeDescriptor d2) {
        Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
        int weight1 = this.getOrderWeight(d1);
        int weight2 = this.getOrderWeight(d2);
        int weightDelta = Intrinsics.compare((int)weight1, (int)weight2);
        if (weightDelta != 0) {
            return weightDelta;
        }
        String displayText1 = d1.getDisplayText();
        String displayText2 = d2.getDisplayText();
        if (displayText1 != null && displayText2 != null) {
            return displayText1.compareTo(displayText2);
        }
        if (displayText1 != null) {
            return -1;
        }
        if (displayText2 != null) {
            return 1;
        }
        return d1.getType().compareTo((Enum)d2.getType());
    }

    private final int getOrderWeight(BranchNodeDescriptor descriptor) {
        boolean isGroupNode;
        boolean isFavorite;
        boolean isCurrent;
        BranchInfo branchInfo = descriptor.getBranchInfo();
        boolean bl = isCurrent = branchInfo != null && branchInfo.isCurrent();
        if (isCurrent) {
            return 0;
        }
        boolean bl2 = isFavorite = branchInfo != null && branchInfo.isFavorite();
        if (isFavorite) {
            return 1;
        }
        boolean bl3 = isGroupNode = descriptor.getType() == NodeType.GROUP_NODE;
        if (isGroupNode) {
            return 2;
        }
        return 3;
    }
}

