/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote;

import com.intellij.codeWithMe.ClientId;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.remote.GitConfigureRemotesDialogKt;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u000512345B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u0015H\u0002J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u0019H\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\b\u0010(\u001a\u00020\u0006H\u0002J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u0015H\u0002J\b\u0010,\u001a\u00020\u0015H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000f2\u0006\u0010/\u001a\u00020\u0006H\u0002J\b\u00100\u001a\u00020\u0015H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "NAME_COLUMN", "", "REMOTE_PADDING", "URL_COLUMN", "git", "Lgit4idea/commands/Git;", "nodes", "", "Lgit4idea/remote/GitConfigureRemotesDialog$Node;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rebuildTreeOnSuccess", "Lkotlin/Function0;", "", "getRepositories", "()Ljava/util/Collection;", "table", "Lcom/intellij/ui/table/JBTable;", "addRemote", "buildNodes", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "editRemote", "getDimensionServiceKey", "", "getPreferredFocusedComponent", "getSelectedRemote", "Lgit4idea/remote/GitConfigureRemotesDialog$RemoteNode;", "getSelectedRepo", "isRemoteSelected", "", "rebuildTable", "removeRemote", "sortedRemotes", "Lgit4idea/repo/GitRemote;", "repository", "updateTableWidth", "MyCellRenderer", "Node", "RemoteNode", "RemotesTableModel", "RepoNode", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitConfigureRemotesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfigureRemotesDialog.kt\ngit4idea/remote/GitConfigureRemotesDialog\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n43#2,3:325\n1747#3,3:328\n*S KotlinDebug\n*F\n+ 1 GitConfigureRemotesDialog.kt\ngit4idea/remote/GitConfigureRemotesDialog\n*L\n45#1:325,3\n93#1:328,3\n*E\n"})
public final class GitConfigureRemotesDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<GitRepository> repositories;
    @NotNull
    private final Git git;
    private final int NAME_COLUMN;
    private final int URL_COLUMN;
    private final int REMOTE_PADDING;
    @NotNull
    private final JBTable table;
    @NotNull
    private List<? extends Node> nodes;
    @NotNull
    private final Function0<Unit> rebuildTreeOnSuccess;

    public GitConfigureRemotesDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        super(project, true, GitConfigureRemotesDialogKt.access$getModalityType());
        this.project = project;
        this.repositories = repositories2;
        boolean $i$f$service = false;
        Class<Git> serviceClass$iv = Git.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.git = (Git)object;
        this.URL_COLUMN = 1;
        this.REMOTE_PADDING = 30;
        this.table = new JBTable((TableModel)new RemotesTableModel());
        this.nodes = this.buildNodes(this.repositories);
        this.init();
        this.setTitle(GitBundle.message("remotes.dialog.title", new Object[0]));
        this.updateTableWidth();
        this.rebuildTreeOnSuccess = (Function0)new Function0<Unit>(this){
            final /* synthetic */ GitConfigureRemotesDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GitConfigureRemotesDialog.access$rebuildTable(this.this$0);
            }
        };
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Collection<GitRepository> getRepositories() {
        return this.repositories;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.name");
        return string;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"okAction");
        return actionArray;
    }

    @NotNull
    public JBTable getPreferredFocusedComponent() {
        return this.table;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.table.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel());
        this.table.setSelectionMode(0);
        this.table.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new MyCellRenderer()));
        new DoubleClickListener(this){
            final /* synthetic */ GitConfigureRemotesDialog this$0;
            {
                this.this$0 = $receiver;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (GitConfigureRemotesDialog.access$isRemoteSelected(this.this$0)) {
                    GitConfigureRemotesDialog.access$editRemote(this.this$0);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.table);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).setAddAction(arg_0 -> GitConfigureRemotesDialog.createCenterPanel$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> GitConfigureRemotesDialog.createCenterPanel$lambda$1(this, arg_0)).setEditAction(arg_0 -> GitConfigureRemotesDialog.createCenterPanel$lambda$2(this, arg_0)).setEditActionUpdater(arg_0 -> GitConfigureRemotesDialog.createCenterPanel$lambda$3(this, arg_0)).setRemoveActionUpdater(arg_0 -> GitConfigureRemotesDialog.createCenterPanel$lambda$4(this, arg_0)).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createDecorator(table).\n\u2026wnActions().createPanel()");
        return jPanel;
    }

    private final void addRemote() {
        boolean bl;
        GitRepository repository;
        block4: {
            repository = this.getSelectedRepo();
            Collection<GitRemote> collection = repository.getRemotes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.remotes");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRemote it = (GitRemote)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"origin")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        String proposedName = bl ? "" : "origin";
        GitDefineRemoteDialog dialog2 = new GitDefineRemoteDialog(repository, this.git, proposedName, "");
        if (dialog2.showAndGet()) {
            String string = GitBundle.message("remotes.dialog.adding.remote", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"remotes.dialog.adding.remote\")");
            String string2 = GitBundle.message("remote.dialog.add.remote", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"remote.dialog.add.remote\")");
            Object[] objectArray = new Object[]{dialog2.getRemoteName(), dialog2.getRemoteUrl()};
            String string3 = GitBundle.message("remotes.dialog.cannot.add.remote.error.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"remotes.dialog.\u2026teName, dialog.remoteUrl)");
            GitConfigureRemotesDialogKt.access$runInModalTask(string, string2, string3, repository, this.rebuildTreeOnSuccess, (Function0)new Function0<List<? extends GitCommandResult>>(this, repository, dialog2){
                final /* synthetic */ GitConfigureRemotesDialog this$0;
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ GitDefineRemoteDialog $dialog;
                {
                    this.this$0 = $receiver;
                    this.$repository = $repository;
                    this.$dialog = $dialog;
                    super(0);
                }

                @Nullable
                public final List<GitCommandResult> invoke() {
                    ArrayList<GitCommandResult> arrayList = new ArrayList<GitCommandResult>();
                    GitConfigureRemotesDialog gitConfigureRemotesDialog = this.this$0;
                    GitRepository gitRepository = this.$repository;
                    GitDefineRemoteDialog gitDefineRemoteDialog = this.$dialog;
                    ArrayList<GitCommandResult> $this$invoke_u24lambda_u240 = arrayList;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.add(GitConfigureRemotesDialog.access$getGit$p(gitConfigureRemotesDialog).addRemote(gitRepository, gitDefineRemoteDialog.getRemoteName(), gitDefineRemoteDialog.getRemoteUrl()));
                    return arrayList;
                }
            });
        }
    }

    private final void removeRemote() {
        RemoteNode remoteNode = this.getSelectedRemote();
        Intrinsics.checkNotNull((Object)remoteNode);
        RemoteNode remoteNode2 = remoteNode;
        GitRemote remote = remoteNode2.getRemote();
        GitRepository repository = remoteNode2.getRepository();
        GitConfigureRemotesDialogKt.removeRemotes(this.git, repository, SetsKt.setOf((Object)remote), this.rebuildTreeOnSuccess);
    }

    private final void editRemote() {
        RemoteNode remoteNode = this.getSelectedRemote();
        Intrinsics.checkNotNull((Object)remoteNode);
        RemoteNode remoteNode2 = remoteNode;
        GitRemote remote = remoteNode2.getRemote();
        GitRepository repository = remoteNode2.getRepository();
        GitConfigureRemotesDialogKt.editRemote(this.git, repository, remote, this.rebuildTreeOnSuccess);
    }

    private final void updateTableWidth() {
        int maxNameWidth = 30;
        int maxUrlWidth = 250;
        for (Node node : this.nodes) {
            int urlWidth;
            GitRemote remote;
            FontMetrics fontMetrics = this.table.getFontMetrics(UIManager.getFont("Table.font").deriveFont(1));
            int nameWidth = fontMetrics.stringWidth(node.getPresentableString());
            RemoteNode remoteNode = node instanceof RemoteNode ? (RemoteNode)node : null;
            GitRemote gitRemote = remote = remoteNode != null ? remoteNode.getRemote() : null;
            int n = urlWidth = gitRemote == null ? 0 : fontMetrics.stringWidth(GitConfigureRemotesDialogKt.access$getUrl(gitRemote));
            if (maxNameWidth < nameWidth) {
                maxNameWidth = nameWidth;
            }
            if (maxUrlWidth >= urlWidth) continue;
            maxUrlWidth = urlWidth;
        }
        this.table.getColumnModel().getColumn(this.NAME_COLUMN).setPreferredWidth(maxNameWidth += this.REMOTE_PADDING + 10);
        this.table.getColumnModel().getColumn(this.URL_COLUMN).setPreferredWidth(maxUrlWidth);
        this.table.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)(maxNameWidth + maxUrlWidth + 10), (int)-1));
        this.table.setVisibleRowCount(Math.min(this.nodes.size() + 3, 8));
    }

    private final List<Node> buildNodes(Collection<? extends GitRepository> repositories2) {
        List nodes = new ArrayList();
        for (GitRepository repository : DvcsUtil.sortRepositories(repositories2)) {
            if (repositories2.size() > 1) {
                Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"repository");
                nodes.add(new RepoNode(repository));
            }
            Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"repository");
            for (GitRemote remote : this.sortedRemotes(repository)) {
                nodes.add(new RemoteNode(remote, repository));
            }
        }
        return nodes;
    }

    private final List<GitRemote> sortedRemotes(GitRepository repository) {
        Collection<GitRemote> collection = repository.getRemotes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.remotes");
        return CollectionsKt.sortedWith((Iterable)collection, GitConfigureRemotesDialog::sortedRemotes$lambda$6);
    }

    private final void rebuildTable() {
        this.nodes = this.buildNodes(this.repositories);
        TableModel tableModel = this.table.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type git4idea.remote.GitConfigureRemotesDialog.RemotesTableModel");
        ((RemotesTableModel)tableModel).fireTableDataChanged();
    }

    private final GitRepository getSelectedRepo() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            List list2 = DvcsUtil.sortRepositories(this.repositories);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"sortRepositories(repositories)");
            Object object = CollectionsKt.first((List)list2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sortRepositories(repositories).first()");
            return (GitRepository)object;
        }
        Node value = this.nodes.get(selectedRow);
        if (value instanceof RepoNode) {
            return ((RepoNode)value).getRepository();
        }
        if (value instanceof RemoteNode) {
            return ((RemoteNode)value).getRepository();
        }
        throw new IllegalStateException("Unexpected selected value: " + value);
    }

    private final RemoteNode getSelectedRemote() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        Node node = this.nodes.get(selectedRow);
        return node instanceof RemoteNode ? (RemoteNode)node : null;
    }

    private final boolean isRemoteSelected() {
        return this.getSelectedRemote() != null;
    }

    private static final void createCenterPanel$lambda$0(GitConfigureRemotesDialog this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.addRemote();
    }

    private static final void createCenterPanel$lambda$1(GitConfigureRemotesDialog this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.removeRemote();
    }

    private static final void createCenterPanel$lambda$2(GitConfigureRemotesDialog this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.editRemote();
    }

    private static final boolean createCenterPanel$lambda$3(GitConfigureRemotesDialog this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isRemoteSelected();
    }

    private static final boolean createCenterPanel$lambda$4(GitConfigureRemotesDialog this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isRemoteSelected();
    }

    private static final int sortedRemotes$lambda$6(GitRemote r1, GitRemote r2) {
        int n;
        if (Intrinsics.areEqual((Object)r1.getName(), (Object)"origin")) {
            n = Intrinsics.areEqual((Object)r2.getName(), (Object)"origin") ? 0 : -1;
        } else if (Intrinsics.areEqual((Object)r2.getName(), (Object)"origin")) {
            n = 1;
        } else {
            String string = r1.getName();
            String string2 = r2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"r2.name");
            n = string.compareTo(string2);
        }
        return n;
    }

    public static final /* synthetic */ boolean access$isRemoteSelected(GitConfigureRemotesDialog $this) {
        return $this.isRemoteSelected();
    }

    public static final /* synthetic */ void access$editRemote(GitConfigureRemotesDialog $this) {
        $this.editRemote();
    }

    public static final /* synthetic */ Git access$getGit$p(GitConfigureRemotesDialog $this) {
        return $this.git;
    }

    public static final /* synthetic */ void access$rebuildTable(GitConfigureRemotesDialog $this) {
        $this.rebuildTable();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$MyCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "(Lgit4idea/remote/GitConfigureRemotesDialog;)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.vcs.git"})
    private final class MyCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Object object = value;
            if (object instanceof RepoNode) {
                this.append(((RepoNode)value).getPresentableString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else if (object instanceof RemoteNode) {
                if (GitConfigureRemotesDialog.this.getRepositories().size() > 1) {
                    this.append("", SimpleTextAttributes.REGULAR_ATTRIBUTES, GitConfigureRemotesDialog.this.REMOTE_PADDING, 2);
                }
                this.append(((RemoteNode)value).getPresentableString());
            } else if (object instanceof String) {
                this.append((String)value);
            }
            this.setBorder(null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H'\u00a8\u0006\u0005"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$Node;", "", "()V", "getPresentableString", "", "intellij.vcs.git"})
    private static abstract class Node {
        @Nls
        @NotNull
        public abstract String getPresentableString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0016J\u0012\u0010\u000f\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$RemoteNode;", "Lgit4idea/remote/GitConfigureRemotesDialog$Node;", "remote", "Lgit4idea/repo/GitRemote;", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRemote;Lgit4idea/repo/GitRepository;)V", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "getPresentableString", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "toString", "intellij.vcs.git"})
    private static final class RemoteNode
    extends Node {
        @NotNull
        private final GitRemote remote;
        @NotNull
        private final GitRepository repository;

        public RemoteNode(@NotNull GitRemote remote, @NotNull GitRepository repository) {
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            this.remote = remote;
            this.repository = repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public String toString() {
            String string = this.remote.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remote.name");
            return string;
        }

        @Override
        @NotNull
        public String getPresentableString() {
            String string = this.remote.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remote.name");
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$RemotesTableModel;", "Ljavax/swing/table/AbstractTableModel;", "(Lgit4idea/remote/GitConfigureRemotesDialog;)V", "getColumnCount", "", "getColumnName", "", "column", "getRowCount", "getValueAt", "", "rowIndex", "columnIndex", "intellij.vcs.git"})
    private final class RemotesTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return GitConfigureRemotesDialog.this.nodes.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            if (column == GitConfigureRemotesDialog.this.NAME_COLUMN) {
                String string = GitBundle.message("remotes.remote.column.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"remotes.remote.column.name\")");
                return string;
            }
            String string = GitBundle.message("remotes.remote.column.url", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"remotes.remote.column.url\")");
            return string;
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            Node node = (Node)GitConfigureRemotesDialog.this.nodes.get(rowIndex);
            if (columnIndex == GitConfigureRemotesDialog.this.NAME_COLUMN) {
                return node;
            }
            if (node instanceof RepoNode) {
                return "";
            }
            if (node instanceof RemoteNode) {
                return GitConfigureRemotesDialogKt.access$getUrl(((RemoteNode)node).getRemote());
            }
            GitConfigureRemotesDialogKt.access$getLOG$p().error("Unexpected position at row " + rowIndex + " and column " + columnIndex);
            return "";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0012\u0010\u000b\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lgit4idea/remote/GitConfigureRemotesDialog$RepoNode;", "Lgit4idea/remote/GitConfigureRemotesDialog$Node;", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getPresentableString", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "toString", "intellij.vcs.git"})
    private static final class RepoNode
    extends Node {
        @NotNull
        private final GitRepository repository;

        public RepoNode(@NotNull GitRepository repository) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            this.repository = repository;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public String toString() {
            String string = this.repository.getPresentableUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.presentableUrl");
            return string;
        }

        @Override
        @NotNull
        public String getPresentableString() {
            String string = DvcsUtil.getShortRepositoryName((Repository)this.repository);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortRepositoryName(repository)");
            return string;
        }
    }
}

