/*
 * Decompiled with CFR 0.152.
 */
package git4idea.fetch;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import git4idea.fetch.GitRemoteOperationQueue;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R4\u0010\u0003\u001a(\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006 \b*\u0012\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/fetch/GitRemoteOperationQueueImpl;", "Lgit4idea/fetch/GitRemoteOperationQueue;", "()V", "busyRemotes", "", "Lgit4idea/fetch/GitRemoteOperationQueueImpl$RemoteCoordinates;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "executeForRemote", "T", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "operation", "Lkotlin/Function0;", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "RemoteCoordinates", "intellij.vcs.git"})
public final class GitRemoteOperationQueueImpl
implements GitRemoteOperationQueue {
    @NotNull
    private final Set<RemoteCoordinates> busyRemotes;

    public GitRemoteOperationQueueImpl() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet<RemoteCoordinates>()");
        this.busyRemotes = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeForRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull Function0<? extends T> operation) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        RemoteCoordinates remoteCoordinates = new RemoteCoordinates(repository, remote);
        while (true) {
            indicator.checkCanceled();
            if (this.busyRemotes.add(remoteCoordinates)) break;
            TimeoutUtil.sleep((long)50L);
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            this.busyRemotes.remove(remoteCoordinates);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lgit4idea/fetch/GitRemoteOperationQueueImpl$RemoteCoordinates;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;)V", "repositoryRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lgit4idea/repo/GitRemote;)V", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepositoryRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    private static final class RemoteCoordinates {
        @NotNull
        private final VirtualFile repositoryRoot;
        @NotNull
        private final GitRemote remote;

        public RemoteCoordinates(@NotNull VirtualFile repositoryRoot, @NotNull GitRemote remote) {
            Intrinsics.checkNotNullParameter((Object)repositoryRoot, (String)"repositoryRoot");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            this.repositoryRoot = repositoryRoot;
            this.remote = remote;
        }

        @NotNull
        public final VirtualFile getRepositoryRoot() {
            return this.repositoryRoot;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        public RemoteCoordinates(@NotNull GitRepository repository, @NotNull GitRemote remote) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
            this(virtualFile, remote);
        }

        @NotNull
        public final VirtualFile component1() {
            return this.repositoryRoot;
        }

        @NotNull
        public final GitRemote component2() {
            return this.remote;
        }

        @NotNull
        public final RemoteCoordinates copy(@NotNull VirtualFile repositoryRoot, @NotNull GitRemote remote) {
            Intrinsics.checkNotNullParameter((Object)repositoryRoot, (String)"repositoryRoot");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            return new RemoteCoordinates(repositoryRoot, remote);
        }

        public static /* synthetic */ RemoteCoordinates copy$default(RemoteCoordinates remoteCoordinates, VirtualFile virtualFile, GitRemote gitRemote, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = remoteCoordinates.repositoryRoot;
            }
            if ((n & 2) != 0) {
                gitRemote = remoteCoordinates.remote;
            }
            return remoteCoordinates.copy(virtualFile, gitRemote);
        }

        @NotNull
        public String toString() {
            return "RemoteCoordinates(repositoryRoot=" + this.repositoryRoot + ", remote=" + this.remote + ")";
        }

        public int hashCode() {
            int result2 = this.repositoryRoot.hashCode();
            result2 = result2 * 31 + this.remote.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoteCoordinates)) {
                return false;
            }
            RemoteCoordinates remoteCoordinates = (RemoteCoordinates)other;
            if (!Intrinsics.areEqual((Object)this.repositoryRoot, (Object)remoteCoordinates.repositoryRoot)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.remote, (Object)remoteCoordinates.remote);
        }
    }
}

