/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.accounts;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.AccountManagerBase;
import com.intellij.collaboration.auth.AccountsRepository;
import com.intellij.collaboration.auth.PasswordSafeCredentialsRepository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.google.accounts.GooglePersistentAccounts;
import org.intellij.plugins.markdown.google.accounts.data.GoogleAccount;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserInfo;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0014J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;", "Lcom/intellij/collaboration/auth/AccountManagerBase;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "Lcom/intellij/openapi/Disposable;", "()V", "accountsRepository", "Lcom/intellij/collaboration/auth/AccountsRepository;", "credentialsRepository", "Lcom/intellij/collaboration/auth/PasswordSafeCredentialsRepository;", "dispose", "", "Companion", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nGoogleAccountManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleAccountManager.kt\norg/intellij/plugins/markdown/google/accounts/GoogleAccountManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,43:1\n10#2:44\n43#3,3:45\n*S KotlinDebug\n*F\n+ 1 GoogleAccountManager.kt\norg/intellij/plugins/markdown/google/accounts/GoogleAccountManager\n*L\n21#1:44\n28#1:45,3\n*E\n"})
public final class GoogleAccountManager
extends AccountManagerBase<GoogleAccount, GoogleCredentials>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SERVICE_DISPLAY_NAME = "Google Accounts";

    public GoogleAccountManager() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleAccountManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        super(logger);
    }

    @NotNull
    protected AccountsRepository<GoogleAccount> accountsRepository() {
        boolean $i$f$service = false;
        Class<GooglePersistentAccounts> serviceClass$iv = GooglePersistentAccounts.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (AccountsRepository)object;
    }

    @NotNull
    protected PasswordSafeCredentialsRepository<GoogleAccount, GoogleCredentials> credentialsRepository() {
        return new PasswordSafeCredentialsRepository(SERVICE_DISPLAY_NAME, (PasswordSafeCredentialsRepository.CredentialsMapper)new PasswordSafeCredentialsRepository.CredentialsMapper<GoogleCredentials>(){

            @NotNull
            public String serialize(@NotNull GoogleCredentials credentials) {
                Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
                String string = GoogleAccountsUtils.INSTANCE.getJacksonMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)credentials);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonMapper.writerWith\u2026alueAsString(credentials)");
                return string;
            }

            @NotNull
            public GoogleCredentials deserialize(@NotNull String credentials) {
                Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
                Object object = GoogleAccountsUtils.INSTANCE.getJacksonMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).readValue(credentials, GoogleCredentials.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jacksonMapper.disable(De\u2026eCredentials::class.java)");
                return (GoogleCredentials)object;
            }
        });
    }

    public void dispose() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager$Companion;", "", "()V", "SERVICE_DISPLAY_NAME", "", "createAccount", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "userInfo", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserInfo;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GoogleAccount createAccount(@NotNull GoogleUserInfo userInfo) {
            Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
            return new GoogleAccount(userInfo.getId(), userInfo.getEmail());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

