/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.googleDocs;

import com.google.api.client.auth.oauth2.Credential;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.utils.GoogleDocsImportUtils;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsImportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "docsLinkField", "Lcom/intellij/ui/EditorTextField;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "validateDocsLink", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "field", "Companion", "intellij.markdown.core"})
public final class GoogleDocsImportDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorTextField docsLinkField;
    private static final int PREFERRED_WIDTH = 500;

    public GoogleDocsImportDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true);
        this.project = project;
        this.docsLinkField = new EditorTextField();
        this.setTitle(MarkdownBundle.message("markdown.google.docs.import.dialog.title", new Object[0]));
        super.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCenterPanel_u24lambda_u240 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GoogleDocsImportDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = MarkdownBundle.message("markdown.google.docs.import.dialog.url.field", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.google\u2026import.dialog.url.field\")");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GoogleDocsImportDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)GoogleDocsImportDialog.access$getDocsLinkField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)new Function2<ValidationInfoBuilder, EditorTextField, ValidationInfo>(this.this$0){
                            final /* synthetic */ GoogleDocsImportDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull EditorTextField it) {
                                Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return GoogleDocsImportDialog.access$validateDocsLink(this.this$0, $this$validationOnApply, it);
                            }
                        }).focused();
                    }
                });
            }
        }));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.withPreferredWidth(500);
        return (JComponent)dialogPanel;
    }

    protected void doOKAction() {
        String string = this.docsLinkField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docsLinkField.text");
        String docsLink = string;
        String docsId = GoogleDocsImportUtils.INSTANCE.extractDocsId(docsLink);
        this.close(0);
        Credential credential = GoogleAccountsUtils.INSTANCE.chooseAccount(this.project);
        if (credential == null) {
            return;
        }
        Credential credentials = credential;
        GoogleDocsImportUtils.importGoogleDoc$default(GoogleDocsImportUtils.INSTANCE, this.project, credentials, docsId, null, 8, null);
    }

    private final ValidationInfo validateDocsLink(ValidationInfoBuilder $this$validateDocsLink, EditorTextField field) {
        ValidationInfo validationInfo;
        String string = field.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.text");
        String docsLink = string;
        if (field.isNull() || ((CharSequence)docsLink).length() == 0) {
            String string2 = MarkdownBundle.message("markdown.google.docs.import.empty.link.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"markdown.google\u2026import.empty.link.error\")");
            validationInfo = $this$validateDocsLink.error(string2);
        } else if (!GoogleDocsImportUtils.INSTANCE.isLinkToDocumentCorrect(docsLink)) {
            String string3 = MarkdownBundle.message("markdown.google.docs.import.invalid.url", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"markdown.google.docs.import.invalid.url\")");
            validationInfo = $this$validateDocsLink.error(string3);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    public static final /* synthetic */ EditorTextField access$getDocsLinkField$p(GoogleDocsImportDialog $this) {
        return $this.docsLinkField;
    }

    public static final /* synthetic */ ValidationInfo access$validateDocsLink(GoogleDocsImportDialog $this, ValidationInfoBuilder $receiver, EditorTextField field) {
        return $this.validateDocsLink($receiver, field);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsImportDialog$Companion;", "", "()V", "PREFERRED_WIDTH", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

