from collections.abc import Mapping
from enum import IntEnum

class Base(IntEnum):
    InteropIndex: int
    ProcessingSoftware: int
    NewSubfileType: int
    SubfileType: int
    ImageWidth: int
    ImageLength: int
    BitsPerSample: int
    Compression: int
    PhotometricInterpretation: int
    Thresholding: int
    CellWidth: int
    CellLength: int
    FillOrder: int
    DocumentName: int
    ImageDescription: int
    Make: int
    Model: int
    StripOffsets: int
    Orientation: int
    SamplesPerPixel: int
    RowsPerStrip: int
    StripByteCounts: int
    MinSampleValue: int
    MaxSampleValue: int
    XResolution: int
    YResolution: int
    PlanarConfiguration: int
    PageName: int
    FreeOffsets: int
    FreeByteCounts: int
    GrayResponseUnit: int
    GrayResponseCurve: int
    T4Options: int
    T6Options: int
    ResolutionUnit: int
    PageNumber: int
    TransferFunction: int
    Software: int
    DateTime: int
    Artist: int
    HostComputer: int
    Predictor: int
    WhitePoint: int
    PrimaryChromaticities: int
    ColorMap: int
    HalftoneHints: int
    TileWidth: int
    TileLength: int
    TileOffsets: int
    TileByteCounts: int
    SubIFDs: int
    InkSet: int
    InkNames: int
    NumberOfInks: int
    DotRange: int
    TargetPrinter: int
    ExtraSamples: int
    SampleFormat: int
    SMinSampleValue: int
    SMaxSampleValue: int
    TransferRange: int
    ClipPath: int
    XClipPathUnits: int
    YClipPathUnits: int
    Indexed: int
    JPEGTables: int
    OPIProxy: int
    JPEGProc: int
    JpegIFOffset: int
    JpegIFByteCount: int
    JpegRestartInterval: int
    JpegLosslessPredictors: int
    JpegPointTransforms: int
    JpegQTables: int
    JpegDCTables: int
    JpegACTables: int
    YCbCrCoefficients: int
    YCbCrSubSampling: int
    YCbCrPositioning: int
    ReferenceBlackWhite: int
    XMLPacket: int
    RelatedImageFileFormat: int
    RelatedImageWidth: int
    RelatedImageLength: int
    Rating: int
    RatingPercent: int
    ImageID: int
    CFARepeatPatternDim: int
    BatteryLevel: int
    Copyright: int
    ExposureTime: int
    FNumber: int
    IPTCNAA: int
    ImageResources: int
    ExifOffset: int
    InterColorProfile: int
    ExposureProgram: int
    SpectralSensitivity: int
    GPSInfo: int
    ISOSpeedRatings: int
    OECF: int
    Interlace: int
    TimeZoneOffset: int
    SelfTimerMode: int
    SensitivityType: int
    StandardOutputSensitivity: int
    RecommendedExposureIndex: int
    ISOSpeed: int
    ISOSpeedLatitudeyyy: int
    ISOSpeedLatitudezzz: int
    ExifVersion: int
    DateTimeOriginal: int
    DateTimeDigitized: int
    OffsetTime: int
    OffsetTimeOriginal: int
    OffsetTimeDigitized: int
    ComponentsConfiguration: int
    CompressedBitsPerPixel: int
    ShutterSpeedValue: int
    ApertureValue: int
    BrightnessValue: int
    ExposureBiasValue: int
    MaxApertureValue: int
    SubjectDistance: int
    MeteringMode: int
    LightSource: int
    Flash: int
    FocalLength: int
    Noise: int
    ImageNumber: int
    SecurityClassification: int
    ImageHistory: int
    TIFFEPStandardID: int
    MakerNote: int
    UserComment: int
    SubsecTime: int
    SubsecTimeOriginal: int
    SubsecTimeDigitized: int
    AmbientTemperature: int
    Humidity: int
    Pressure: int
    WaterDepth: int
    Acceleration: int
    CameraElevationAngle: int
    XPTitle: int
    XPComment: int
    XPAuthor: int
    XPKeywords: int
    XPSubject: int
    FlashPixVersion: int
    ColorSpace: int
    ExifImageWidth: int
    ExifImageHeight: int
    RelatedSoundFile: int
    ExifInteroperabilityOffset: int
    FlashEnergy: int
    SpatialFrequencyResponse: int
    FocalPlaneXResolution: int
    FocalPlaneYResolution: int
    FocalPlaneResolutionUnit: int
    SubjectLocation: int
    ExposureIndex: int
    SensingMethod: int
    FileSource: int
    SceneType: int
    CFAPattern: int
    CustomRendered: int
    ExposureMode: int
    WhiteBalance: int
    DigitalZoomRatio: int
    FocalLengthIn35mmFilm: int
    SceneCaptureType: int
    GainControl: int
    Contrast: int
    Saturation: int
    Sharpness: int
    DeviceSettingDescription: int
    SubjectDistanceRange: int
    ImageUniqueID: int
    CameraOwnerName: int
    BodySerialNumber: int
    LensSpecification: int
    LensMake: int
    LensModel: int
    LensSerialNumber: int
    CompositeImage: int
    CompositeImageCount: int
    CompositeImageExposureTimes: int
    Gamma: int
    PrintImageMatching: int
    DNGVersion: int
    DNGBackwardVersion: int
    UniqueCameraModel: int
    LocalizedCameraModel: int
    CFAPlaneColor: int
    CFALayout: int
    LinearizationTable: int
    BlackLevelRepeatDim: int
    BlackLevel: int
    BlackLevelDeltaH: int
    BlackLevelDeltaV: int
    WhiteLevel: int
    DefaultScale: int
    DefaultCropOrigin: int
    DefaultCropSize: int
    ColorMatrix1: int
    ColorMatrix2: int
    CameraCalibration1: int
    CameraCalibration2: int
    ReductionMatrix1: int
    ReductionMatrix2: int
    AnalogBalance: int
    AsShotNeutral: int
    AsShotWhiteXY: int
    BaselineExposure: int
    BaselineNoise: int
    BaselineSharpness: int
    BayerGreenSplit: int
    LinearResponseLimit: int
    CameraSerialNumber: int
    LensInfo: int
    ChromaBlurRadius: int
    AntiAliasStrength: int
    ShadowScale: int
    DNGPrivateData: int
    MakerNoteSafety: int
    CalibrationIlluminant1: int
    CalibrationIlluminant2: int
    BestQualityScale: int
    RawDataUniqueID: int
    OriginalRawFileName: int
    OriginalRawFileData: int
    ActiveArea: int
    MaskedAreas: int
    AsShotICCProfile: int
    AsShotPreProfileMatrix: int
    CurrentICCProfile: int
    CurrentPreProfileMatrix: int
    ColorimetricReference: int
    CameraCalibrationSignature: int
    ProfileCalibrationSignature: int
    AsShotProfileName: int
    NoiseReductionApplied: int
    ProfileName: int
    ProfileHueSatMapDims: int
    ProfileHueSatMapData1: int
    ProfileHueSatMapData2: int
    ProfileToneCurve: int
    ProfileEmbedPolicy: int
    ProfileCopyright: int
    ForwardMatrix1: int
    ForwardMatrix2: int
    PreviewApplicationName: int
    PreviewApplicationVersion: int
    PreviewSettingsName: int
    PreviewSettingsDigest: int
    PreviewColorSpace: int
    PreviewDateTime: int
    RawImageDigest: int
    OriginalRawFileDigest: int
    SubTileBlockSize: int
    RowInterleaveFactor: int
    ProfileLookTableDims: int
    ProfileLookTableData: int
    OpcodeList1: int
    OpcodeList2: int
    OpcodeList3: int
    NoiseProfile: int

TAGS: Mapping[int, str]

class GPS(IntEnum):
    GPSVersionID: int
    GPSLatitudeRef: int
    GPSLatitude: int
    GPSLongitudeRef: int
    GPSLongitude: int
    GPSAltitudeRef: int
    GPSAltitude: int
    GPSTimeStamp: int
    GPSSatellites: int
    GPSStatus: int
    GPSMeasureMode: int
    GPSDOP: int
    GPSSpeedRef: int
    GPSSpeed: int
    GPSTrackRef: int
    GPSTrack: int
    GPSImgDirectionRef: int
    GPSImgDirection: int
    GPSMapDatum: int
    GPSDestLatitudeRef: int
    GPSDestLatitude: int
    GPSDestLongitudeRef: int
    GPSDestLongitude: int
    GPSDestBearingRef: int
    GPSDestBearing: int
    GPSDestDistanceRef: int
    GPSDestDistance: int
    GPSProcessingMethod: int
    GPSAreaInformation: int
    GPSDateStamp: int
    GPSDifferential: int
    GPSHPositioningError: int

GPSTAGS: Mapping[int, str]

class Interop(IntEnum):
    InteropIndex: int
    InteropVersion: int
    RelatedImageFileFormat: int
    RelatedImageWidth: int
    RleatedImageHeight: int

class IFD(IntEnum):
    Exif: int
    GPSInfo: int
    Makernote: int
    Interop: int
    IFD1: int

class LightSource(IntEnum):
    Unknown: int
    Daylight: int
    Fluorescent: int
    Tungsten: int
    Flash: int
    Fine: int
    Cloudy: int
    Shade: int
    DaylightFluorescent: int
    DayWhiteFluorescent: int
    CoolWhiteFluorescent: int
    WhiteFluorescent: int
    StandardLightA: int
    StandardLightB: int
    StandardLightC: int
    D55: int
    D65: int
    D75: int
    D50: int
    ISO: int
    Other: int
