/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpCallerChooser;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterTableModel;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterTableModelItem;
import com.jetbrains.php.refactoring.validation.PhpFunctionConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpMethodConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpNameConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpParameterValidator;
import com.jetbrains.php.refactoring.validation.PhpReturnTypeValidator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeSignatureDialog
extends ChangeSignatureDialogBase<PhpParameterInfo, Function, String, PhpMethodDescriptor, PhpParameterTableModelItem, PhpParameterTableModel> {
    private static Font defaultTableFont = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
    private JCheckBox myInitializeParametersCheckBox;
    private final PhpNameConflictDetector myNameConflictDetector;

    public PhpChangeSignatureDialog(Project project, PhpMethodDescriptor method, PsiElement defaultValueContext) {
        super(project, (MethodDescriptor)method, false, defaultValueContext);
        Function function = method.getMethod();
        this.myNameConflictDetector = function instanceof Method ? new PhpMethodConflictDetector((Method)function) : new PhpFunctionConflictDetector(function);
    }

    protected LanguageFileType getFileType() {
        return PhpFileType.INSTANCE;
    }

    @NotNull
    protected PhpParameterTableModel createParametersInfoModel(@NotNull PhpMethodDescriptor method) {
        if (method == null) {
            PhpChangeSignatureDialog.$$$reportNull$$$0(0);
        }
        PsiElement parameterList = PhpPsiUtil.getChildOfType((PsiElement)method.getMethod(), PhpElementTypes.PARAMETER_LIST);
        PhpParameterTableModel phpParameterTableModel = new PhpParameterTableModel(parameterList, this.myDefaultValueContext, this.myProject);
        if (phpParameterTableModel == null) {
            PhpChangeSignatureDialog.$$$reportNull$$$0(1);
        }
        return phpParameterTableModel;
    }

    protected BaseRefactoringProcessor createRefactoringProcessor() {
        List parameters = this.getParameters();
        return new PhpChangeSignatureProcessor(this.myProject, (PhpMethodDescriptor)this.myMethod, this.getVisibility(), this.getMethodName(), this.myReturnTypeField != null ? this.myReturnTypeField.getText() : null, parameters.toArray(new PhpParameterInfo[0]), this.myMethodsToPropagateParameters, this.initializeParameters());
    }

    private boolean initializeParameters() {
        return this.myInitializeParametersCheckBox != null && this.myInitializeParametersCheckBox.isSelected();
    }

    @Nullable
    protected PsiCodeFragment createReturnTypeCodeFragment() {
        return PhpPsiElementFactory.createTypeCodeFragment(this.myProject, StringUtil.notNullize((String)((PhpMethodDescriptor)this.myMethod).getReturnTypeText()), (PsiElement)((PhpMethodDescriptor)this.myMethod).getMethod(), true);
    }

    protected CallerChooserBase<Function> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<Function>> callback) {
        return new PhpCallerChooser(((PhpMethodDescriptor)this.myMethod).getMethod(), this.myProject, title, treeToReuse, callback);
    }

    @Nullable
    protected String getVisibility() {
        return ((PhpMethodDescriptor)this.myMethod).getMethod() instanceof Method ? (String)super.getVisibility() : null;
    }

    protected String calculateSignature() {
        StringBuilder builder = new StringBuilder();
        String visibility = this.getVisibility();
        if (StringUtil.isNotEmpty((String)visibility)) {
            builder.append(visibility);
            builder.append(" ");
            PhpModifier modifier = ((Method)((PhpMethodDescriptor)this.myMethod).getMethod()).getModifier();
            if (modifier.isStatic()) {
                builder.append("static ");
            }
            if (modifier.isAbstract()) {
                builder.append("abstract ");
            } else if (modifier.isFinal()) {
                builder.append("final ");
            }
        }
        String signature = PhpFunctionCodeGenerator.PREVIEW.generate(this.getMethodName(), ((PhpParameterTableModel)this.myParametersTableModel).getItems(), this.myReturnTypeField != null ? this.myReturnTypeField.getText() : "");
        builder.append(signature);
        return builder.toString();
    }

    protected VisibilityPanelBase<String> createVisibilityControl() {
        return new ComboBoxVisibilityPanel((Object[])new String[]{PhpModifier.Access.PRIVATE.toString(), PhpModifier.Access.PROTECTED.toString(), PhpModifier.Access.PUBLIC.toString(), ""}, new String[]{"private", "protected", "public", "default"});
    }

    protected MethodSignatureComponent createSignaturePreviewComponent() {
        return new MethodSignatureComponent(this.calculateSignature(), this.getProject(), (FileType)this.getFileType()){

            protected String getFileName() {
                return "dummy." + PhpFileType.INSTANCE.getDefaultExtension();
            }
        };
    }

    protected JComponent createCenterPanel() {
        JComponent panel = super.createCenterPanel();
        assert (panel != null);
        if (((PhpMethodDescriptor)this.myMethod).isConstructor()) {
            JPanel subPanel = new JPanel(new BorderLayout());
            this.myInitializeParametersCheckBox = new JCheckBox(PhpBundle.message("change.signature.initialize.new.parameters", new Object[0]), true);
            subPanel.add((Component)this.myInitializeParametersCheckBox, "Center");
            panel.add((Component)subPanel, "North");
        }
        return panel;
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    protected JComponent getRowPresentation(ParameterTableModelItemBase<PhpParameterInfo> item, boolean selected, boolean focused) {
        assert (item instanceof PhpParameterTableModelItem);
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 2, 1, true, true));
        PhpParameterTableModelItem phpItem = (PhpParameterTableModelItem)item;
        StringBuilder text = new StringBuilder(" ");
        String parameter = phpItem.getNewParameter();
        text.append(parameter);
        String defaultValue = phpItem.defaultValueCodeFragment.getText();
        if (StringUtil.isNotEmpty((String)defaultValue)) {
            String separator = StringUtil.repeatSymbol((char)' ', (int)(this.getParametersMaxLength() - parameter.length() + 1));
            text.append(separator);
            text.append(" // ");
            text.append(defaultValue);
        }
        EditorTextField field = new EditorTextField(text.toString(), this.getProject(), (FileType)this.getFileType()){

            protected boolean shouldHaveBorder() {
                return false;
            }
        };
        field.addSettingsProvider(EditorSettingsProvider.NO_WHITESPACE);
        field.setFont(defaultTableFont);
        if (selected && focused) {
            panel.setBackground(UIUtil.getTableSelectionBackground());
            field.setAsRendererWithSelection(UIUtil.getTableSelectionBackground(), UIUtil.getTableSelectionForeground());
        } else {
            panel.setBackground(UIUtil.getTableBackground());
            if (selected && !focused) {
                panel.setBorder((Border)new DottedBorder(UIUtil.getTableForeground()));
            }
        }
        panel.add((Component)field);
        panel.setToolTipText(PhpBundle.message("change.signature.tooltip", new Object[0]));
        return panel;
    }

    private int getParametersMaxLength() {
        int len = 0;
        for (ParameterTableModelItemBase item : ((PhpParameterTableModel)this.myParametersTableModel).getItems()) {
            String text = ((PhpParameterTableModelItem)item).parameterCodeFragment;
            len = Math.max(len, text == null ? 0 : text.length());
        }
        return len;
    }

    protected JBTableRowEditor getTableEditor(final JTable t, final ParameterTableModelItemBase<PhpParameterInfo> item) {
        assert (item instanceof PhpParameterTableModelItem);
        final PhpParameterTableModelItem phpItem = (PhpParameterTableModelItem)item;
        return new JBTableRowEditor(){
            private EditorTextField myParameterEditor;
            private EditorTextField myDefaultValueEditor;

            public void prepareEditor(JTable table, int row) {
                this.setLayout(new BorderLayout());
                JPanel parameterPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 5, 2, true, true));
                this.myParameterEditor = new MyEditorTextField(phpItem.getNewParameter(), PhpChangeSignatureDialog.this.getProject(), PhpChangeSignatureDialog.this.getFileType());
                this.myParameterEditor.addDocumentListener((DocumentListener)PhpChangeSignatureDialog.this.mySignatureUpdater);
                this.myParameterEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 0));
                this.myParameterEditor.setBorder(BorderFactory.createLineBorder(UIUtil.getTableBackground()));
                this.myParameterEditor.setFont(defaultTableFont);
                parameterPanel.setToolTipText(PhpBundle.message("change.signature.tooltip.parameter", new Object[0]));
                this.myParameterEditor.setToolTipText(PhpBundle.message("change.signature.tooltip.parameter", new Object[0]));
                parameterPanel.add((Component)this.myParameterEditor);
                this.add(parameterPanel, "Center");
                if (phpItem.defaultValueNeeded(PhpChangeSignatureDialog.this.myProject)) {
                    BorderLayout layout = new BorderLayout();
                    JPanel defaultValuePanel = new JPanel(layout);
                    Document doc = PsiDocumentManager.getInstance((Project)PhpChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.defaultValueCodeFragment);
                    this.myDefaultValueEditor = new MyEditorTextField(doc, PhpChangeSignatureDialog.this.getProject(), PhpChangeSignatureDialog.this.getFileType());
                    JPanel defaultValueEditorPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 2, 1, true, true));
                    JBLabel defaultValueLabel = new JBLabel("Default:", UIUtil.ComponentStyle.SMALL);
                    defaultValuePanel.add((Component)defaultValueLabel, "West");
                    defaultValueEditorPanel.add((Component)this.myDefaultValueEditor);
                    defaultValuePanel.add((Component)defaultValueEditorPanel, "East");
                    IJSwingUtilities.adjustComponentsOnMac((JLabel)defaultValueLabel, (JComponent)this.myDefaultValueEditor);
                    this.myDefaultValueEditor.setPreferredWidth(t.getWidth() / 3);
                    this.myDefaultValueEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 1));
                    defaultValuePanel.setToolTipText(PhpBundle.message("change.signature.tooltip.default.value", new Object[0]));
                    this.myDefaultValueEditor.setToolTipText(PhpBundle.message("change.signature.tooltip.default.value", new Object[0]));
                    this.myDefaultValueEditor.setFont(defaultTableFont);
                    this.add(defaultValuePanel, "East");
                }
            }

            public JBTableRow getValue() {
                return new JBTableRow(){

                    @Nullable
                    public Object getValueAt(int column) {
                        switch (column) {
                            case 0: {
                                return phpItem.parameterCodeFragment;
                            }
                            case 1: {
                                return phpItem.defaultValueCodeFragment;
                            }
                        }
                        return null;
                    }
                };
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myParameterEditor.getFocusTarget();
            }

            public JComponent[] getFocusableComponents() {
                ArrayList<JComponent> focusable = new ArrayList<JComponent>();
                focusable.add(this.myParameterEditor.getFocusTarget());
                if (this.myDefaultValueEditor != null) {
                    focusable.add(this.myDefaultValueEditor.getFocusTarget());
                }
                return focusable.toArray(new JComponent[0]);
            }

            class MyEditorTextField
            extends EditorTextField {
                MyEditorTextField(String parameter, Project project, LanguageFileType type) {
                    super(parameter, project, (FileType)type);
                }

                MyEditorTextField(Document doc, Project project, LanguageFileType type) {
                    super(doc, project, (FileType)type);
                }

                protected void updateBorder(@NotNull EditorEx editor) {
                    if (editor == null) {
                        MyEditorTextField.$$$reportNull$$$0(0);
                    }
                    super.updateBorder(editor);
                    editor.setBorder(BorderFactory.createLineBorder(UIUtil.getTableBackground()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureDialog$3$MyEditorTextField", "updateBorder"));
                }
            }
        };
    }

    protected boolean mayPropagateParameters() {
        List items = this.getParameters();
        for (PhpParameterInfo item : items) {
            if (item.getOldIndex() != -1) continue;
            return true;
        }
        return false;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String functionValidationMessage;
        if (!((PhpMethodDescriptor)this.myMethod).isAnonymous() && (functionValidationMessage = this.myNameConflictDetector.findConflicts(this.getMethodName())) != null) {
            return new ValidationInfo(functionValidationMessage, (JComponent)this.myNameField);
        }
        if (this.getTableComponent().isEditing()) {
            return super.doValidate();
        }
        if (this.myReturnTypeField != null) {
            String returnType = this.myReturnTypeField.getText();
            ValidationInfo validate = PhpReturnTypeValidator.validate(((PhpMethodDescriptor)this.myMethod).getMethod().getProject(), returnType, (PsiElement)((PhpMethodDescriptor)this.myMethod).getMethod());
            if (validate != null) {
                return validate;
            }
        }
        return PhpParameterValidator.validate(this.myProject, ((PhpParameterTableModel)this.myParametersTableModel).getItems());
    }

    @Nullable
    protected String validateAndCommitData() {
        String newName = this.getMethodName();
        if (!((PhpMethodDescriptor)this.myMethod).isAnonymous() && !PhpNameUtil.isValidFunctionName(newName)) {
            return PhpBundle.message("validation.invalid.identifier", newName);
        }
        ValidationInfo validationInfo = PhpParameterValidator.validateAndCommit(this.myProject, ((PhpParameterTableModel)this.myParametersTableModel).getItems());
        if (validationInfo == null) {
            return this.validateReturnType();
        }
        return validationInfo.message;
    }

    @Nullable
    private String validateReturnType() {
        ValidationInfo validateReturn;
        if (this.myReturnTypeField != null && (validateReturn = PhpReturnTypeValidator.validate(this.myProject, this.myReturnTypeField.getText(), (PsiElement)((PhpMethodDescriptor)this.myMethod).getMethod())) != null) {
            return validateReturn.message;
        }
        return null;
    }

    static {
        defaultTableFont = new Font(defaultTableFont.getFontName(), defaultTableFont.getStyle(), 12);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createParametersInfoModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createParametersInfoModel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

