/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.svn.ignore.FileIterationListener;
import org.jetbrains.idea.svn.ignore.IgnoreInfoGetter;

public class FileGroupInfo
implements FileIterationListener,
IgnoreInfoGetter {
    private String commonExtension;
    private final Map<VirtualFile, Set<String>> folders = new HashMap<VirtualFile, Set<String>>();
    private int fileCount = 0;
    private boolean sameExtensionCase = true;

    @Override
    public void onFileEnabled(VirtualFile file) {
        VirtualFile parentVirtualFile;
        ++this.fileCount;
        if (this.sameExtensionCase) {
            String extension = file.getExtension();
            if (extension == null) {
                this.sameExtensionCase = false;
            } else if (this.commonExtension == null) {
                this.commonExtension = extension;
            } else {
                this.sameExtensionCase &= this.commonExtension.equals(extension);
            }
        }
        if ((parentVirtualFile = file.getParent()) != null) {
            Set<String> namesList = this.folders.get(parentVirtualFile);
            if (namesList == null) {
                namesList = new HashSet<String>();
                this.folders.put(parentVirtualFile, namesList);
            }
            namesList.add(file.getName());
        }
    }

    public boolean oneFileSelected() {
        return this.fileCount == 1;
    }

    public boolean sameExtension() {
        return this.sameExtensionCase;
    }

    public String getExtensionMask() {
        return "*." + this.commonExtension;
    }

    @Override
    public Map<VirtualFile, Set<String>> getInfo(boolean useCommonExtension) {
        if (!useCommonExtension) {
            return this.folders;
        }
        HashMap<VirtualFile, Set<String>> result = new HashMap<VirtualFile, Set<String>>(this.folders.size(), 1.0f);
        for (Map.Entry<VirtualFile, Set<String>> entry : this.folders.entrySet()) {
            HashSet<String> set = new HashSet<String>();
            set.add(this.getExtensionMask());
            result.put(entry.getKey(), set);
        }
        return result;
    }

    public String getFileName() {
        return this.folders.values().iterator().next().iterator().next();
    }
}

