/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ToggleAutoUploadAction
extends ToggleAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleAutoUploadAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Project project = e.getProject();
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(project != null);
        } else {
            e.getPresentation().setEnabled(project != null);
        }
        if (project != null) {
            PublishConfig.AutoUploadState state = PublishConfig.getInstance(project).getAutoUploadState();
            switch (state) {
                case ALWAYS: {
                    e.getPresentation().setText(WDBundle.message("toggle.auto.upload.action.always", new Object[0]));
                    break;
                }
                case ON_EXPLICIT_SAVE: {
                    e.getPresentation().setText(WDBundle.message("toggle.auto.upload.action.on.explicit.save", new Object[0]));
                    break;
                }
                case NEVER: {
                    e.getPresentation().setText(WDBundle.message("toggle.auto.upload.action.never", new Object[0]));
                }
            }
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleAutoUploadAction.$$$reportNull$$$0(1);
        }
        return (project = e.getProject()) != null && PublishConfig.getInstance(project).getAutoUploadState() != PublishConfig.AutoUploadState.NEVER;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project;
        if (e == null) {
            ToggleAutoUploadAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) != null) {
            PublishConfig config = PublishConfig.getInstance(project);
            if (state) {
                WebServerGroupingWrap defaultWrap = config.findDefaultServerOrGroupAsWrap();
                if (defaultWrap == null) {
                    List<WebServerGroupingWrap> wraps = GroupedServersConfigManager.getInstance(project).getGroupedServers();
                    ArrayList<WebServerGroupingWrap> filteredServers = new ArrayList<WebServerGroupingWrap>();
                    block0: for (WebServerGroupingWrap wrap2 : wraps) {
                        if (wrap2 == null) continue;
                        for (WebServerConfig serverConfig2 : wrap2.getServers()) {
                            List<DeploymentPathMapping> mappings;
                            if (!serverConfig2.needsTransfer() || serverConfig2.getFileTransferConfig().validateFast() != null || (mappings = config.getPathMappings(serverConfig2.getId())) == null || mappings.isEmpty()) continue;
                            filteredServers.add(wrap2);
                            continue block0;
                        }
                    }
                    if (filteredServers.isEmpty()) {
                        ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.or.group.is.not.configured.and.no.valid.servers", new Object[0]));
                    } else {
                        PublishActionUtil.chooseServerFromWraps(config, filteredServers, e, WDBundle.message("choose.default.server.or.group", new Object[0]), true).onSuccess(wrap -> {
                            config.setDefaultGroupOrServerName(wrap.getName());
                            ToggleAutoUploadAction.setState(state, project, config);
                        });
                    }
                    return;
                }
                if (defaultWrap.getServers().stream().noneMatch(serverConfig -> serverConfig.needsTransfer())) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.does.n.t.need.automatic.upload", defaultWrap.getName(), defaultWrap.getPresentableName()));
                    return;
                }
                String validationResult = defaultWrap.validateFileTransferFast();
                if (validationResult != null) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.is.invalid.1", defaultWrap.getName(), StringUtil.decapitalize((String)validationResult), defaultWrap.getPresentableName()));
                    return;
                }
                if (!config.hasValidMapping(defaultWrap)) {
                    ToggleAutoUploadAction.showMessage(project, WDBundle.message("default.server.0.has.no.valid.mappings", defaultWrap.getName(), defaultWrap.getPresentableName()));
                    return;
                }
            }
            ToggleAutoUploadAction.setState(state, project, config);
        }
    }

    private static void setState(boolean state, Project project, PublishConfig config) {
        if (state) {
            config.setAutoUploadState(PublishConfig.AutoUploadState.ALWAYS);
        } else {
            config.setAutoUploadState(PublishConfig.AutoUploadState.NEVER);
        }
        ((DeploymentConfigChangeListener)project.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).optionsChanged();
    }

    private static void showMessage(Project project, String message) {
        Messages.showWarningDialog((Project)project, (String)WDBundle.message("0.n.automatic.upload.is.not.enabled", message), (String)WDBundle.message("automatic.upload.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/ToggleAutoUploadAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

