/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.ui.GithubSettingsPanel;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u00012\u00020\u0004:\u0001\u0016B?\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0002H\u0014J\f\u0010\u0015\u001a\u00060\u0003R\u00020\u0000H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable;", "Lcom/intellij/openapi/options/ConfigurableBase;", "Lorg/jetbrains/plugins/github/ui/GithubSettingsPanel;", "Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable$GithubSettingsHolder;", "Lcom/intellij/openapi/options/Configurable$NoMargin;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "defaultAccountHolder", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubProjectDefaultAccountHolder;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "avatarLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imageResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/util/GithubSettings;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;Lorg/jetbrains/plugins/github/authentication/accounts/GithubProjectDefaultAccountHolder;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;)V", "createUi", "getSettings", "GithubSettingsHolder", "intellij.vcs.github"})
public final class GithubSettingsConfigurable
extends ConfigurableBase<GithubSettingsPanel, GithubSettingsHolder>
implements Configurable.NoMargin {
    private final Project project;
    private final GithubSettings settings;
    private final GithubAccountManager accountManager;
    private final GithubProjectDefaultAccountHolder defaultAccountHolder;
    private final GithubApiRequestExecutor.Factory executorFactory;
    private final CachingGithubUserAvatarLoader avatarLoader;
    private final GithubImageResizer imageResizer;

    @NotNull
    protected GithubSettingsHolder getSettings() {
        return new GithubSettingsHolder(this.settings, this.accountManager, this.defaultAccountHolder);
    }

    @NotNull
    protected GithubSettingsPanel createUi() {
        return new GithubSettingsPanel(this.project, this.executorFactory, this.avatarLoader, this.imageResizer);
    }

    public GithubSettingsConfigurable(@NotNull Project project, @NotNull GithubSettings settings, @NotNull GithubAccountManager accountManager, @NotNull GithubProjectDefaultAccountHolder defaultAccountHolder, @NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull CachingGithubUserAvatarLoader avatarLoader, @NotNull GithubImageResizer imageResizer) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)accountManager, (String)"accountManager");
        Intrinsics.checkParameterIsNotNull((Object)defaultAccountHolder, (String)"defaultAccountHolder");
        Intrinsics.checkParameterIsNotNull((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkParameterIsNotNull((Object)avatarLoader, (String)"avatarLoader");
        Intrinsics.checkParameterIsNotNull((Object)imageResizer, (String)"imageResizer");
        super("settings.github", "GitHub", "settings.github");
        this.project = project;
        this.settings = settings;
        this.accountManager = accountManager;
        this.defaultAccountHolder = defaultAccountHolder;
        this.executorFactory = executorFactory;
        this.avatarLoader = avatarLoader;
        this.imageResizer = imageResizer;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this.project).subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)new AccountTokenChangedListener(){

            @Override
            public void tokenChanged(@NotNull GithubAccount account) {
                Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
                if (!this.isModified()) {
                    this.reset();
                }
            }
        });
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable$GithubSettingsHolder;", "", "application", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "applicationAccounts", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "projectAccount", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubProjectDefaultAccountHolder;", "(Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable;Lorg/jetbrains/plugins/github/util/GithubSettings;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;Lorg/jetbrains/plugins/github/authentication/accounts/GithubProjectDefaultAccountHolder;)V", "getApplication", "()Lorg/jetbrains/plugins/github/util/GithubSettings;", "getApplicationAccounts", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "getProjectAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubProjectDefaultAccountHolder;", "intellij.vcs.github"})
    public final class GithubSettingsHolder {
        @NotNull
        private final GithubSettings application;
        @NotNull
        private final GithubAccountManager applicationAccounts;
        @NotNull
        private final GithubProjectDefaultAccountHolder projectAccount;

        @NotNull
        public final GithubSettings getApplication() {
            return this.application;
        }

        @NotNull
        public final GithubAccountManager getApplicationAccounts() {
            return this.applicationAccounts;
        }

        @NotNull
        public final GithubProjectDefaultAccountHolder getProjectAccount() {
            return this.projectAccount;
        }

        public GithubSettingsHolder(@NotNull GithubSettings application, @NotNull GithubAccountManager applicationAccounts, GithubProjectDefaultAccountHolder projectAccount) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)applicationAccounts, (String)"applicationAccounts");
            Intrinsics.checkParameterIsNotNull((Object)projectAccount, (String)"projectAccount");
            this.application = application;
            this.applicationAccounts = applicationAccounts;
            this.projectAccount = projectAccount;
        }
    }
}

