/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0004R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "", "()V", "cachedTokens", "", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$TokenInfo;", "getCachedTokens", "()Ljava/util/List;", "filteredTokens", "getFilteredTokens", "originalText", "", "getOriginalText", "()Ljava/lang/CharSequence;", "originalTextRange", "Lkotlin/ranges/IntRange;", "getOriginalTextRange", "()Lkotlin/ranges/IntRange;", "getRawCharAt", "", "index", "", "verify", "", "Iterator", "RangesListIterator", "TokenInfo", "3ce148cfd89a773"})
public abstract class TokensCache {
    @NotNull
    public abstract List<TokenInfo> getCachedTokens();

    @NotNull
    public abstract List<TokenInfo> getFilteredTokens();

    @NotNull
    public abstract CharSequence getOriginalText();

    @NotNull
    public abstract IntRange getOriginalTextRange();

    public final char getRawCharAt(int index) {
        if (index < this.getOriginalTextRange().getStart()) {
            return (char)0;
        }
        if (index > this.getOriginalTextRange().getEndInclusive()) {
            return (char)0;
        }
        return this.getOriginalText().charAt(index);
    }

    protected final void verify() {
        int i;
        boolean bl;
        int n = 0;
        int n2 = ((Collection)this.getCachedTokens()).size();
        while (n < n2) {
            boolean bl2 = bl = this.getCachedTokens().get(i).getRawIndex() == i;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ++i;
        }
        n2 = ((Collection)this.getFilteredTokens()).size();
        for (i = 0; i < n2; ++i) {
            boolean bl3 = bl = this.getFilteredTokens().get(i).getNormIndex() == i;
            if (!_Assertions.ENABLED || bl) continue;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B%\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u00060\u0000R\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\f\u0010\u000f\u001a\u00060\u0000R\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$RangesListIterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "ranges", "", "Lkotlin/ranges/IntRange;", "(Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;Ljava/util/List;)V", "listIndex", "", "value", "(Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;Ljava/util/List;II)V", "advance", "rawLookup", "Lorg/intellij/markdown/IElementType;", "steps", "rollback", "3ce148cfd89a773"})
    public final class RangesListIterator
    extends Iterator {
        private final List<IntRange> ranges;
        private final int listIndex;
        final /* synthetic */ TokensCache this$0;

        @Override
        @NotNull
        public RangesListIterator advance() {
            if (this.listIndex >= this.ranges.size()) {
                return this;
            }
            if (this.getIndex() == this.ranges.get(this.listIndex).getEndInclusive().intValue()) {
                IntRange intRange = (IntRange)CollectionsKt.getOrNull(this.ranges, (int)(this.listIndex + 1));
                return new RangesListIterator(this.this$0, this.ranges, this.listIndex + 1, intRange != null ? intRange.getStart().intValue() : this.this$0.getFilteredTokens().size());
            }
            return new RangesListIterator(this.this$0, this.ranges, this.listIndex, this.getIndex() + 1);
        }

        @Override
        @NotNull
        public RangesListIterator rollback() {
            if (this.listIndex < 0) {
                return this;
            }
            if (this.getIndex() == this.ranges.get(this.listIndex).getStart().intValue()) {
                IntRange intRange = (IntRange)CollectionsKt.getOrNull(this.ranges, (int)(this.listIndex - 1));
                return new RangesListIterator(this.this$0, this.ranges, this.listIndex - 1, intRange != null ? intRange.getEndInclusive() : -1);
            }
            return new RangesListIterator(this.this$0, this.ranges, this.listIndex, this.getIndex() - 1);
        }

        @Override
        @Nullable
        public IElementType rawLookup(int steps) {
            IntRange intRange = (IntRange)CollectionsKt.getOrNull(this.ranges, (int)this.listIndex);
            if (intRange == null) {
                return null;
            }
            if (intRange.contains(this.getIndex() + steps)) {
                return super.rawLookup(steps);
            }
            return null;
        }

        private RangesListIterator(TokensCache $outer, List<IntRange> ranges, int listIndex, int value) {
            this.this$0 = $outer;
            super(value);
            this.ranges = ranges;
            this.listIndex = listIndex;
        }

        public RangesListIterator(@NotNull TokensCache $outer, List<IntRange> ranges) {
            Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
            IntRange intRange = (IntRange)CollectionsKt.firstOrNull(ranges);
            this($outer, ranges, 0, intRange != null ? intRange.getStart() : -1);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0015\u001a\u00060\u0000R\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\f\u0010\u001e\u001a\u00060\u0000R\u00020\u0016H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "", "index", "", "(Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;I)V", "end", "getEnd", "()I", "firstChar", "", "getFirstChar", "()C", "getIndex", "length", "getLength", "start", "getStart", "type", "Lorg/intellij/markdown/IElementType;", "getType", "()Lorg/intellij/markdown/IElementType;", "advance", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "charLookup", "steps", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$TokenInfo;", "rawSteps", "rawLookup", "rawStart", "rollback", "toString", "", "3ce148cfd89a773"})
    public class Iterator {
        private final int index;

        @Nullable
        public final IElementType getType() {
            return this.info(0).getType();
        }

        public final char getFirstChar() {
            return TokensCache.this.getRawCharAt(this.info(0).getTokenStart());
        }

        public final int getLength() {
            return this.info(0).getTokenEnd() - this.info(0).getTokenStart();
        }

        public final int getStart() {
            return this.info(0).getTokenStart();
        }

        public final int getEnd() {
            return this.info(0).getTokenEnd();
        }

        @NotNull
        public Iterator advance() {
            return new Iterator(this.index + 1);
        }

        @NotNull
        public Iterator rollback() {
            return new Iterator(this.index - 1);
        }

        private final TokenInfo info(int rawSteps) {
            int rawIndex;
            if (this.index < 0) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getStart(), TokensCache.this.getOriginalTextRange().getStart(), 0, 0);
            }
            if (this.index > TokensCache.this.getFilteredTokens().size()) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getEndInclusive() + 1, TokensCache.this.getOriginalTextRange().getEndInclusive() + 1, 0, 0);
            }
            int n = rawIndex = this.index < TokensCache.this.getFilteredTokens().size() ? TokensCache.this.getFilteredTokens().get(this.index).getRawIndex() + rawSteps : TokensCache.this.getCachedTokens().size() + rawSteps;
            if (rawIndex < 0) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getStart(), TokensCache.this.getOriginalTextRange().getStart(), 0, 0);
            }
            if (rawIndex >= TokensCache.this.getCachedTokens().size()) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getEndInclusive() + 1, TokensCache.this.getOriginalTextRange().getEndInclusive() + 1, 0, 0);
            }
            return TokensCache.this.getCachedTokens().get(rawIndex);
        }

        @Nullable
        public IElementType rawLookup(int steps) {
            return this.info(steps).getType();
        }

        public final int rawStart(int steps) {
            return this.info(steps).getTokenStart();
        }

        public char charLookup(int steps) {
            if (steps == 0) {
                return TokensCache.this.getRawCharAt(this.getStart());
            }
            if (steps == 1) {
                return TokensCache.this.getRawCharAt(this.getEnd());
            }
            if (steps == -1) {
                return TokensCache.this.getRawCharAt(this.getStart() - 1);
            }
            int pos = steps > 0 ? this.rawStart(steps) : this.rawStart(steps + 1) - 1;
            return TokensCache.this.getRawCharAt(pos);
        }

        @NotNull
        public String toString() {
            return "Iterator: " + this.index + ": " + this.getType();
        }

        public final int getIndex() {
            return this.index;
        }

        public Iterator(int index) {
            this.index = index;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$TokenInfo;", "", "type", "Lorg/intellij/markdown/IElementType;", "tokenStart", "", "tokenEnd", "rawIndex", "normIndex", "(Lorg/intellij/markdown/IElementType;IIII)V", "getNormIndex", "()I", "setNormIndex", "(I)V", "getRawIndex", "getTokenEnd", "getTokenStart", "getType", "()Lorg/intellij/markdown/IElementType;", "toString", "", "3ce148cfd89a773"})
    public static final class TokenInfo {
        @Nullable
        private final IElementType type;
        private final int tokenStart;
        private final int tokenEnd;
        private final int rawIndex;
        private int normIndex;

        @NotNull
        public String toString() {
            return "TokenInfo: " + String.valueOf(this.type) + " [" + this.tokenStart + ", " + this.tokenEnd + ")";
        }

        @Nullable
        public final IElementType getType() {
            return this.type;
        }

        public final int getTokenStart() {
            return this.tokenStart;
        }

        public final int getTokenEnd() {
            return this.tokenEnd;
        }

        public final int getRawIndex() {
            return this.rawIndex;
        }

        public final int getNormIndex() {
            return this.normIndex;
        }

        public final void setNormIndex(int n) {
            this.normIndex = n;
        }

        public TokenInfo(@Nullable IElementType type, int tokenStart, int tokenEnd, int rawIndex, int normIndex) {
            this.type = type;
            this.tokenStart = tokenStart;
            this.tokenEnd = tokenEnd;
            this.rawIndex = rawIndex;
            this.normIndex = normIndex;
        }
    }
}

