/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.async.JsonStreamProcessor;
import com.github.dockerjava.jaxrs.AbstrAsyncDockerCmdExec;
import com.github.dockerjava.jaxrs.async.AbstractCallbackNotifier;
import com.github.dockerjava.jaxrs.async.POSTCallbackNotifier;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang.StringUtils;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildImageCmdExec
extends AbstrAsyncDockerCmdExec<BuildImageCmd, BuildResponseItem>
implements BuildImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildImageCmdExec.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public BuildImageCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    private Invocation.Builder resourceWithOptionalAuthConfig(BuildImageCmd command, Invocation.Builder request) {
        AuthConfigurations authConfigs = BuildImageCmdExec.firstNonNull(command.getBuildAuthConfigs(), this.getBuildAuthConfigs());
        if (authConfigs != null && !authConfigs.getConfigs().isEmpty()) {
            request = request.header("X-Registry-Config", (Object)this.registryConfigs(authConfigs));
        }
        return request;
    }

    private static AuthConfigurations firstNonNull(AuthConfigurations fromCommand, AuthConfigurations fromConfig) {
        if (fromCommand != null) {
            return fromCommand;
        }
        if (fromConfig != null) {
            return fromConfig;
        }
        return null;
    }

    @Override
    protected AbstractCallbackNotifier<BuildResponseItem> callbackNotifier(BuildImageCmd command, ResultCallback<BuildResponseItem> resultCallback) {
        WebTarget webTarget = this.getBaseResource().path("/build");
        String dockerFilePath = command.getPathToDockerfile();
        if (dockerFilePath != null && command.getRemote() == null && !"Dockerfile".equals(dockerFilePath)) {
            webTarget = webTarget.queryParam("dockerfile", new Object[]{dockerFilePath});
        }
        if (command.getTags() != null && !command.getTags().isEmpty()) {
            for (String t : command.getTags()) {
                webTarget = webTarget.queryParam("t", new Object[]{t});
            }
        } else if (StringUtils.isNotBlank((String)command.getTag())) {
            webTarget = webTarget.queryParam("t", new Object[]{command.getTag()});
        }
        if (command.getCacheFrom() != null) {
            for (String c : command.getCacheFrom()) {
                webTarget = webTarget.queryParam("cachefrom", new Object[]{c});
            }
        }
        if (command.getRemote() != null) {
            webTarget = webTarget.queryParam("remote", new Object[]{command.getRemote().toString()});
        }
        webTarget = this.booleanQueryParam(webTarget, "q", command.isQuiet());
        webTarget = this.booleanQueryParam(webTarget, "nocache", command.hasNoCacheEnabled());
        webTarget = this.booleanQueryParam(webTarget, "pull", command.hasPullEnabled());
        webTarget = this.booleanQueryParam(webTarget, "rm", command.hasRemoveEnabled());
        webTarget = this.booleanQueryParam(webTarget, "forcerm", command.isForcerm());
        if (command.hasRemoveEnabled() == null || !command.hasRemoveEnabled().booleanValue()) {
            webTarget = webTarget.queryParam("rm", new Object[]{"false"});
        }
        if (command.getMemory() != null) {
            webTarget = webTarget.queryParam("memory", new Object[]{command.getMemory()});
        }
        if (command.getMemswap() != null) {
            webTarget = webTarget.queryParam("memswap", new Object[]{command.getMemswap()});
        }
        if (command.getCpushares() != null) {
            webTarget = webTarget.queryParam("cpushares", new Object[]{command.getCpushares()});
        }
        if (command.getCpusetcpus() != null) {
            webTarget = webTarget.queryParam("cpusetcpus", new Object[]{command.getCpusetcpus()});
        }
        if (command.hasRemoveEnabled() == null || !command.hasRemoveEnabled().booleanValue()) {
            webTarget = webTarget.queryParam("rm", new Object[]{"false"});
        }
        webTarget = this.writeMap(webTarget, "buildargs", command.getBuildArgs());
        if (command.getShmsize() != null) {
            webTarget = webTarget.queryParam("shmsize", new Object[]{command.getShmsize()});
        }
        webTarget = this.writeMap(webTarget, "labels", command.getLabels());
        if (command.getNetworkMode() != null) {
            webTarget = webTarget.queryParam("networkmode", new Object[]{command.getNetworkMode()});
        }
        webTarget.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        webTarget.property("jersey.config.client.chunkedEncodingSize", (Object)0x100000);
        LOGGER.trace("POST: {}", (Object)webTarget);
        return new POSTCallbackNotifier<BuildResponseItem>(new JsonStreamProcessor<BuildResponseItem>(BuildResponseItem.class), resultCallback, this.resourceWithOptionalAuthConfig(command, webTarget.request()).accept(new String[]{"text/plain"}), Entity.entity((Object)command.getTarInputStream(), (String)"application/tar"));
    }

    private WebTarget writeMap(WebTarget webTarget, String name, Map<String, String> value) {
        if (value != null && !value.isEmpty()) {
            try {
                return webTarget.queryParam(name, new Object[]{URLEncoder.encode(MAPPER.writeValueAsString(value), "UTF-8").replaceAll("\\+", "%20")});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return webTarget;
    }
}

